/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.transformation;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.external.asm.Frame;
import mockit.external.asm.Label;
import mockit.external.asm.MethodVisitor;
import mockit.external.asm.MethodWriter;
import mockit.external.asm.Type;
import mockit.internal.expectations.transformation.ActiveInvocations;
import mockit.internal.expectations.transformation.ArgumentCapturing;
import mockit.internal.util.TypeConversion;

final class InvocationBlockModifier
extends MethodVisitor {
    private static final String CLASS_DESC = Type.getInternalName(ActiveInvocations.class);
    private static final Type[] NO_PARAMETERS = new Type[0];
    private static final String ANY_FIELDS = "any anyString anyInt anyBoolean anyLong anyDouble anyFloat anyChar anyShort anyByte";
    private static final String WITH_METHODS = "withArgThat(Lorg/hamcrest/Matcher;)Ljava/lang/Object; with(Lmockit/Delegate;)Ljava/lang/Object; withAny(Ljava/lang/Object;)Ljava/lang/Object; withCapture()Ljava/lang/Object; withCapture(Ljava/util/List;)Ljava/lang/Object; withCapture(Ljava/lang/Object;)Ljava/util/List; withEqual(Ljava/lang/Object;)Ljava/lang/Object; withEqual(DD)D withEqual(FD)F withInstanceLike(Ljava/lang/Object;)Ljava/lang/Object; withInstanceOf(Ljava/lang/Class;)Ljava/lang/Object; withNotEqual(Ljava/lang/Object;)Ljava/lang/Object; withNull()Ljava/lang/Object; withNotNull()Ljava/lang/Object; withSameInstance(Ljava/lang/Object;)Ljava/lang/Object; withSubstring(Ljava/lang/CharSequence;)Ljava/lang/CharSequence; withPrefix(Ljava/lang/CharSequence;)Ljava/lang/CharSequence; withSuffix(Ljava/lang/CharSequence;)Ljava/lang/CharSequence; withMatch(Ljava/lang/CharSequence;)Ljava/lang/CharSequence;";
    @Nonnull
    private final MethodWriter mw;
    @Nonnull
    private final String blockOwner;
    private final boolean callEndInvocations;
    private boolean justAfterWithCaptureInvocation;
    @Nonnull
    private final ArgumentCapturing argumentCapturing;
    private int lastLoadedVarIndex;
    @Nonnull
    private final int[] matcherStacks;
    private int matcherCount;
    private int stackSize;
    @Nonnull
    private Type[] parameterTypes;

    InvocationBlockModifier(@Nonnull MethodWriter mw, @Nonnull String blockOwner, boolean callEndInvocations) {
        super(mw);
        this.mw = mw;
        this.blockOwner = blockOwner;
        this.callEndInvocations = callEndInvocations;
        this.matcherStacks = new int[40];
        this.argumentCapturing = new ArgumentCapturing(this);
        this.parameterTypes = NO_PARAMETERS;
    }

    private void generateCallToActiveInvocationsMethod(@Nonnull String name, @Nonnull String desc) {
        this.visitMethodInstruction(184, CLASS_DESC, name, desc, false);
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        boolean getField;
        boolean bl = getField = opcode == 180;
        if ((getField || opcode == 181) && this.blockOwner.equals(owner) && name.indexOf(36) <= 0) {
            if (getField && name.startsWith("any") && ANY_FIELDS.contains(name)) {
                this.generateCodeToAddArgumentMatcherForAnyField(owner, name, desc);
                return;
            }
            if (!getField && this.generateCodeThatReplacesAssignmentToSpecialField(name)) {
                this.visitInsn(87);
                return;
            }
        }
        this.stackSize += InvocationBlockModifier.stackSizeVariationForFieldAccess(opcode, desc);
        this.mw.visitFieldInsn(opcode, owner, name, desc);
    }

    private boolean generateCodeThatReplacesAssignmentToSpecialField(@Nonnull String fieldName) {
        if ("result".equals(fieldName)) {
            this.generateCallToActiveInvocationsMethod("addResult", "(Ljava/lang/Object;)V");
            return true;
        }
        if ("times".equals(fieldName) || "minTimes".equals(fieldName) || "maxTimes".equals(fieldName)) {
            this.generateCallToActiveInvocationsMethod(fieldName, "(I)V");
            return true;
        }
        return false;
    }

    private void generateCodeToAddArgumentMatcherForAnyField(@Nonnull String fieldOwner, @Nonnull String name, @Nonnull String desc) {
        this.mw.visitFieldInsn(180, fieldOwner, name, desc);
        this.generateCallToActiveInvocationsMethod(name, "()V");
        this.matcherStacks[this.matcherCount++] = this.stackSize;
    }

    private static int stackSizeVariationForFieldAccess(int opcode, @Nonnull String fieldType) {
        char c = fieldType.charAt(0);
        boolean twoByteType = c == 'D' || c == 'J';
        switch (opcode) {
            case 178: {
                return twoByteType ? 2 : 1;
            }
            case 179: {
                return twoByteType ? -2 : -1;
            }
            case 180: {
                return twoByteType ? 1 : 0;
            }
        }
        return twoByteType ? -3 : -2;
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (opcode == 184 && (TypeConversion.isBoxing(owner, name, desc) || this.isAccessMethod(owner, name))) {
            this.visitMethodInstruction(184, owner, name, desc, itf);
        } else if (this.isCallToArgumentMatcher(opcode, owner, name, desc)) {
            this.visitMethodInstruction(182, owner, name, desc, itf);
            boolean withCaptureMethod = "withCapture".equals(name);
            if (this.argumentCapturing.registerMatcher(withCaptureMethod, desc, this.lastLoadedVarIndex)) {
                this.justAfterWithCaptureInvocation = withCaptureMethod;
                this.matcherStacks[this.matcherCount++] = this.stackSize;
            }
        } else if (TypeConversion.isUnboxing(opcode, owner, desc)) {
            if (this.justAfterWithCaptureInvocation) {
                this.generateCodeToReplaceNullWithZeroOnTopOfStack(desc);
                this.justAfterWithCaptureInvocation = false;
            } else {
                this.visitMethodInstruction(opcode, owner, name, desc, itf);
            }
        } else {
            this.handleMockedOrNonMockedInvocation(opcode, owner, name, desc, itf);
        }
    }

    private boolean isAccessMethod(@Nonnull String methodOwner, @Nonnull String name) {
        return !methodOwner.equals(this.blockOwner) && name.startsWith("access$");
    }

    private void visitMethodInstruction(@Nonnegative int opcode, @Nonnull String owner, @Nonnull String name, @Nonnull String desc, boolean itf) {
        int argSize = Type.getArgumentsAndReturnSizes(desc);
        int sizeVariation = (argSize & 3) - (argSize >> 2);
        if (opcode == 184) {
            ++sizeVariation;
        }
        this.stackSize += sizeVariation;
        this.mw.visitMethodInsn(opcode, owner, name, desc, itf);
    }

    private boolean isCallToArgumentMatcher(@Nonnegative int opcode, @Nonnull String owner, @Nonnull String name, @Nonnull String desc) {
        return opcode == 182 && owner.equals(this.blockOwner) && name.startsWith("with") && WITH_METHODS.contains(name + desc);
    }

    private void generateCodeToReplaceNullWithZeroOnTopOfStack(@Nonnull String unboxingMethodDesc) {
        int zeroOpcode;
        char primitiveTypeCode = unboxingMethodDesc.charAt(2);
        this.visitInsn(87);
        switch (primitiveTypeCode) {
            case 'J': {
                zeroOpcode = 9;
                break;
            }
            case 'F': {
                zeroOpcode = 11;
                break;
            }
            case 'D': {
                zeroOpcode = 14;
                break;
            }
            default: {
                zeroOpcode = 3;
            }
        }
        this.visitInsn(zeroOpcode);
    }

    private void handleMockedOrNonMockedInvocation(@Nonnegative int opcode, @Nonnull String owner, @Nonnull String name, @Nonnull String desc, boolean itf) {
        if (this.matcherCount == 0) {
            this.visitMethodInstruction(opcode, owner, name, desc, itf);
        } else {
            boolean mockedInvocationUsingTheMatchers = this.handleInvocationParameters(desc);
            this.visitMethodInstruction(opcode, owner, name, desc, itf);
            this.handleArgumentCapturingIfNeeded(mockedInvocationUsingTheMatchers);
        }
    }

    private boolean handleInvocationParameters(@Nonnull String desc) {
        boolean mockedInvocationUsingTheMatchers;
        this.parameterTypes = Type.getArgumentTypes(desc);
        int stackAfter = this.stackSize - this.sumOfParameterSizes();
        boolean bl = mockedInvocationUsingTheMatchers = stackAfter < this.matcherStacks[0];
        if (mockedInvocationUsingTheMatchers) {
            this.generateCallsToMoveArgMatchers(stackAfter);
            this.argumentCapturing.generateCallsToSetArgumentTypesToCaptureIfAny();
            this.matcherCount = 0;
        }
        return mockedInvocationUsingTheMatchers;
    }

    @Nonnegative
    private int sumOfParameterSizes() {
        int sum = 0;
        for (Type argType : this.parameterTypes) {
            sum += argType.getSize();
        }
        return sum;
    }

    private void generateCallsToMoveArgMatchers(@Nonnegative int initialStack) {
        int stack = initialStack;
        int nextMatcher = 0;
        int matcherStack = this.matcherStacks[0];
        for (int i = 0; i < this.parameterTypes.length && nextMatcher < this.matcherCount; ++i) {
            if ((stack += this.parameterTypes[i].getSize()) != matcherStack && stack != matcherStack + 1) continue;
            if (nextMatcher < i) {
                this.generateCallToMoveArgMatcher(nextMatcher, i);
                this.argumentCapturing.updateCaptureIfAny(nextMatcher, i);
            }
            matcherStack = this.matcherStacks[++nextMatcher];
        }
    }

    private void generateCallToMoveArgMatcher(@Nonnegative int originalMatcherIndex, @Nonnegative int toIndex) {
        this.mw.visitIntInsn(17, originalMatcherIndex);
        this.mw.visitIntInsn(17, toIndex);
        this.generateCallToActiveInvocationsMethod("moveArgMatcher", "(II)V");
    }

    private void handleArgumentCapturingIfNeeded(boolean mockedInvocationUsingTheMatchers) {
        if (mockedInvocationUsingTheMatchers) {
            this.argumentCapturing.generateCallsToCaptureMatchedArgumentsIfPending();
        }
        this.justAfterWithCaptureInvocation = false;
    }

    @Override
    public void visitLabel(Label label) {
        this.mw.visitLabel(label);
        if (!label.isDebug()) {
            this.stackSize = 0;
        }
    }

    @Override
    public void visitTypeInsn(int opcode, @Nonnull String type) {
        this.argumentCapturing.registerTypeToCaptureIfApplicable(opcode, type);
        if (opcode == 187) {
            ++this.stackSize;
        }
        this.mw.visitTypeInsn(opcode, type);
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        if (opcode != 188) {
            ++this.stackSize;
        }
        this.mw.visitIntInsn(opcode, operand);
    }

    @Override
    public void visitVarInsn(int opcode, int varIndex) {
        if (opcode == 25) {
            this.lastLoadedVarIndex = varIndex;
        }
        this.argumentCapturing.registerAssignmentToCaptureVariableIfApplicable(opcode, varIndex);
        if (opcode != 169) {
            this.stackSize += Frame.SIZE[opcode];
        }
        this.mw.visitVarInsn(opcode, varIndex);
    }

    @Override
    public void visitLdcInsn(Object cst) {
        ++this.stackSize;
        if (cst instanceof Long || cst instanceof Double) {
            ++this.stackSize;
        }
        this.mw.visitLdcInsn(cst);
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        if (opcode != 168) {
            this.stackSize += Frame.SIZE[opcode];
        }
        this.mw.visitJumpInsn(opcode, label);
    }

    @Override
    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        --this.stackSize;
        this.mw.visitTableSwitchInsn(min, max, dflt, labels);
    }

    @Override
    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        --this.stackSize;
        this.mw.visitLookupSwitchInsn(dflt, keys, labels);
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.stackSize += 1 - dims;
        this.mw.visitMultiANewArrayInsn(desc, dims);
    }

    @Override
    public void visitInsn(int opcode) {
        if (opcode == 177 && this.callEndInvocations) {
            this.generateCallToActiveInvocationsMethod("endInvocations", "()V");
        } else {
            this.stackSize += Frame.SIZE[opcode];
        }
        this.mw.visitInsn(opcode);
    }

    @Override
    public void visitLocalVariable(@Nonnull String name, @Nonnull String desc, @Nullable String signature, @Nonnull Label start, @Nonnull Label end, int index) {
        if (signature != null) {
            this.argumentCapturing.registerTypeToCaptureIntoListIfApplicable(index, signature);
        }
        if (end.position > 0) {
            this.mw.visitLocalVariable(name, desc, signature, start, end, index);
        }
    }

    final class Capture {
        final int opcode;
        final int varIndex;
        @Nullable
        String typeToCapture;
        private int parameterIndex;
        private boolean parameterIndexFixed;

        Capture(int opcode, @Nullable int varIndex, String typeToCapture) {
            this.opcode = opcode;
            this.varIndex = varIndex;
            this.typeToCapture = typeToCapture;
            this.parameterIndex = InvocationBlockModifier.this.matcherCount - 1;
        }

        Capture(int varIndex) {
            this.opcode = 25;
            this.varIndex = varIndex;
            this.parameterIndex = InvocationBlockModifier.this.matcherCount;
        }

        void generateCodeToStoreCapturedValue() {
            if (this.opcode != 25) {
                InvocationBlockModifier.this.mw.visitIntInsn(17, this.parameterIndex);
                InvocationBlockModifier.this.generateCallToActiveInvocationsMethod("matchedArgument", "(I)Ljava/lang/Object;");
                Type argType = this.getArgumentType();
                TypeConversion.generateCastOrUnboxing(InvocationBlockModifier.this.mw, argType, this.opcode);
                InvocationBlockModifier.this.mw.visitVarInsn(this.opcode, this.varIndex);
            }
        }

        @Nonnull
        private Type getArgumentType() {
            if (this.typeToCapture == null) {
                return InvocationBlockModifier.this.parameterTypes[this.parameterIndex];
            }
            if (this.typeToCapture.charAt(0) == '[') {
                return Type.getType(this.typeToCapture);
            }
            return Type.getType('L' + this.typeToCapture + ';');
        }

        boolean fixParameterIndex(int originalIndex, int newIndex) {
            if (!this.parameterIndexFixed && this.parameterIndex == originalIndex) {
                this.parameterIndex = newIndex;
                this.parameterIndexFixed = true;
                return true;
            }
            return false;
        }

        void generateCallToSetArgumentTypeIfNeeded() {
            if (this.opcode == 25) {
                InvocationBlockModifier.this.mw.visitIntInsn(17, this.parameterIndex);
                InvocationBlockModifier.this.mw.visitLdcInsn(this.varIndex);
                InvocationBlockModifier.this.generateCallToActiveInvocationsMethod("setExpectedArgumentType", "(II)V");
            } else if (this.typeToCapture != null && !this.isTypeToCaptureSameAsParameterType(this.typeToCapture)) {
                InvocationBlockModifier.this.mw.visitIntInsn(17, this.parameterIndex);
                InvocationBlockModifier.this.mw.visitLdcInsn(this.typeToCapture);
                InvocationBlockModifier.this.generateCallToActiveInvocationsMethod("setExpectedArgumentType", "(ILjava/lang/String;)V");
            }
        }

        private boolean isTypeToCaptureSameAsParameterType(@Nonnull String typeDesc) {
            Type parameterType = InvocationBlockModifier.this.parameterTypes[this.parameterIndex];
            int sort = parameterType.getSort();
            if (sort == 10 || sort == 9) {
                return typeDesc.equals(parameterType.getInternalName());
            }
            return TypeConversion.isPrimitiveWrapper(typeDesc);
        }
    }
}

