/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.transformation;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.expectations.BaseVerificationPhase;
import mockit.internal.expectations.RecordAndReplayExecution;
import mockit.internal.expectations.RecordPhase;
import mockit.internal.expectations.TestOnlyPhase;
import mockit.internal.expectations.argumentMatching.AlwaysTrueMatcher;
import mockit.internal.expectations.argumentMatching.ArgumentMatcher;
import mockit.internal.state.TestRun;
import mockit.internal.util.ClassLoad;

public final class ActiveInvocations {
    static final Map<Integer, String> varIndexToTypeDesc = new HashMap<Integer, String>();

    private ActiveInvocations() {
    }

    public static void anyString() {
        ActiveInvocations.addArgMatcher(AlwaysTrueMatcher.ANY_STRING);
    }

    public static void anyBoolean() {
        ActiveInvocations.addArgMatcher(AlwaysTrueMatcher.ANY_BOOLEAN);
    }

    public static void anyChar() {
        ActiveInvocations.addArgMatcher(AlwaysTrueMatcher.ANY_CHAR);
    }

    public static void anyByte() {
        ActiveInvocations.addArgMatcher(AlwaysTrueMatcher.ANY_BYTE);
    }

    public static void anyShort() {
        ActiveInvocations.addArgMatcher(AlwaysTrueMatcher.ANY_SHORT);
    }

    public static void anyInt() {
        ActiveInvocations.addArgMatcher(AlwaysTrueMatcher.ANY_INT);
    }

    public static void anyFloat() {
        ActiveInvocations.addArgMatcher(AlwaysTrueMatcher.ANY_FLOAT);
    }

    public static void anyLong() {
        ActiveInvocations.addArgMatcher(AlwaysTrueMatcher.ANY_LONG);
    }

    public static void anyDouble() {
        ActiveInvocations.addArgMatcher(AlwaysTrueMatcher.ANY_DOUBLE);
    }

    public static void any() {
        ActiveInvocations.addArgMatcher(AlwaysTrueMatcher.ANY_VALUE);
    }

    private static void addArgMatcher(@Nonnull ArgumentMatcher<?> argumentMatcher) {
        TestOnlyPhase currentPhase;
        RecordAndReplayExecution instance = TestRun.getRecordAndReplayForRunningTest();
        if (instance != null && (currentPhase = instance.getCurrentTestOnlyPhase()) != null) {
            currentPhase.addArgMatcher(argumentMatcher);
        }
    }

    public static void moveArgMatcher(@Nonnegative int originalMatcherIndex, @Nonnegative int toIndex) {
        TestOnlyPhase currentPhase;
        RecordAndReplayExecution instance = TestRun.getRecordAndReplayForRunningTest();
        if (instance != null && (currentPhase = instance.getCurrentTestOnlyPhase()) != null) {
            currentPhase.moveArgMatcher(originalMatcherIndex, toIndex);
        }
    }

    public static void setExpectedArgumentType(@Nonnegative int parameterIndex, @Nonnull String typeDesc) {
        TestOnlyPhase currentPhase;
        RecordAndReplayExecution instance = TestRun.getRecordAndReplayForRunningTest();
        if (instance != null && (currentPhase = instance.getCurrentTestOnlyPhase()) != null) {
            Class argumentType = ClassLoad.loadByInternalName(typeDesc);
            currentPhase.setExpectedSingleArgumentType(parameterIndex, argumentType);
        }
    }

    public static void setExpectedArgumentType(@Nonnegative int parameterIndex, int varIndex) {
        TestOnlyPhase currentPhase;
        String typeDesc;
        RecordAndReplayExecution instance = TestRun.getRecordAndReplayForRunningTest();
        if (instance != null && (typeDesc = varIndexToTypeDesc.remove(varIndex)) != null && (currentPhase = instance.getCurrentTestOnlyPhase()) != null) {
            Class argumentType = ClassLoad.loadByInternalName(typeDesc);
            currentPhase.setExpectedMultiArgumentType(parameterIndex, argumentType);
        }
    }

    @Nullable
    public static Object matchedArgument(@Nonnegative int parameterIndex) {
        BaseVerificationPhase verificationPhase;
        RecordAndReplayExecution instance = TestRun.getRecordAndReplayForRunningTest();
        if (instance != null && (verificationPhase = (BaseVerificationPhase)instance.getCurrentTestOnlyPhase()) != null) {
            return verificationPhase.getArgumentValueForCurrentVerification(parameterIndex);
        }
        return null;
    }

    public static void addResult(@Nullable Object result) {
        RecordPhase recordPhase;
        RecordAndReplayExecution instance = TestRun.getRecordAndReplayForRunningTest();
        if (instance != null && (recordPhase = instance.getRecordPhase()) != null) {
            recordPhase.addResult(result);
        }
    }

    public static void times(int n) {
        TestOnlyPhase currentPhase;
        RecordAndReplayExecution instance = TestRun.getRecordAndReplayForRunningTest();
        if (instance != null && (currentPhase = instance.getCurrentTestOnlyPhase()) != null) {
            currentPhase.handleInvocationCountConstraint(n, n);
        }
    }

    public static void minTimes(int n) {
        TestOnlyPhase currentPhase;
        RecordAndReplayExecution instance = TestRun.getRecordAndReplayForRunningTest();
        if (instance != null && (currentPhase = instance.getCurrentTestOnlyPhase()) != null) {
            currentPhase.handleInvocationCountConstraint(n, -1);
        }
    }

    public static void maxTimes(int n) {
        TestOnlyPhase currentPhase;
        RecordAndReplayExecution instance = TestRun.getRecordAndReplayForRunningTest();
        if (instance != null && (currentPhase = instance.getCurrentTestOnlyPhase()) != null) {
            currentPhase.setMaxInvocationCount(n);
        }
    }

    public static void endInvocations() {
        TestRun.enterNoMockingZone();
        try {
            RecordAndReplayExecution instance = TestRun.getRecordAndReplayForRunningTest();
            assert (instance != null);
            instance.endInvocations();
        }
        finally {
            TestRun.exitNoMockingZone();
        }
    }
}

