/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.mocking;

import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.external.asm.ClassReader;
import mockit.internal.classGeneration.BaseImplementationGenerator;
import mockit.internal.classGeneration.MockedTypeInfo;
import mockit.internal.expectations.mocking.MockedTypeModifier;

final class InterfaceImplementationGenerator
extends BaseImplementationGenerator {
    @Nonnull
    private final MockedTypeInfo mockedTypeInfo;
    private String interfaceName;

    InterfaceImplementationGenerator(@Nonnull ClassReader classReader, @Nonnull Type mockedType, @Nonnull String implementationClassName) {
        super(classReader, implementationClassName);
        this.mockedTypeInfo = new MockedTypeInfo(mockedType);
    }

    @Override
    public void visit(int version, int access, @Nonnull String name, @Nullable String signature, @Nullable String superName, @Nullable String[] interfaces) {
        this.interfaceName = name;
        String classSignature = signature == null ? null : signature + this.mockedTypeInfo.implementationSignature;
        super.visit(version, access, name, classSignature, superName, interfaces);
    }

    @Override
    protected void generateMethodBody(int access, @Nonnull String name, @Nonnull String desc, @Nullable String signature, @Nullable String[] exceptions) {
        String subInterfaceOverride;
        this.mw = this.cw.visitMethod(1, name, desc, signature, exceptions);
        String className = null;
        if (signature != null && (subInterfaceOverride = this.getSubInterfaceOverride(this.mockedTypeInfo.genericTypeMap, name, signature)) != null) {
            className = this.interfaceName;
            desc = subInterfaceOverride.substring(name.length());
            signature = null;
        }
        if (className == null) {
            className = this.isOverrideOfMethodFromSuperInterface(name, desc) ? this.interfaceName : this.methodOwner;
        }
        MockedTypeModifier.generateDirectCallToHandler(this.mw, className, access, name, desc, signature);
        this.generateReturnWithObjectAtTopOfTheStack(desc);
        this.mw.visitMaxs(1, 0);
    }
}

