/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.argumentMatching;

import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.Delegate;
import mockit.internal.expectations.argumentMatching.ArgumentMatcher;
import mockit.internal.expectations.argumentMatching.ArgumentMismatch;
import mockit.internal.util.MethodReflection;

public final class ReflectiveMatcher
implements ArgumentMatcher<ReflectiveMatcher> {
    @Nonnull
    private final Delegate<?> delegate;
    @Nullable
    private Method handlerMethod;
    @Nullable
    private Object matchedValue;

    public ReflectiveMatcher(@Nonnull Delegate<?> delegate) {
        this.delegate = delegate;
    }

    @Override
    public boolean same(@Nonnull ReflectiveMatcher other) {
        return this.delegate == other.delegate;
    }

    @Override
    public boolean matches(@Nullable Object argValue) {
        if (this.handlerMethod == null) {
            this.handlerMethod = MethodReflection.findNonPrivateHandlerMethod(this.delegate);
        }
        this.matchedValue = argValue;
        Boolean result = (Boolean)MethodReflection.invoke(this.delegate, this.handlerMethod, argValue);
        return result == null || result != false;
    }

    @Override
    public void writeMismatchPhrase(@Nonnull ArgumentMismatch argumentMismatch) {
        if (this.handlerMethod != null) {
            argumentMismatch.append(this.handlerMethod.getName()).append('(');
            argumentMismatch.appendFormatted(this.matchedValue);
            argumentMismatch.append(") (should return true, was false)");
        } else {
            argumentMismatch.append('?');
        }
        argumentMismatch.markAsFinished();
    }
}

