/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.expectations.Expectation;

final class SequenceOfReturnValues {
    @Nonnull
    private final Expectation expectation;
    @Nonnull
    private final Class<?> returnType;
    @Nullable
    private final Object firstValue;
    @Nonnull
    private final Object[] remainingValues;

    SequenceOfReturnValues(@Nonnull Expectation expectation, @Nullable Object firstValue, @Nonnull Object[] remainingValues) {
        this.expectation = expectation;
        this.returnType = expectation.getReturnType();
        this.firstValue = firstValue;
        this.remainingValues = remainingValues;
    }

    boolean addResultWithSequenceOfValues() {
        boolean added = false;
        if (this.returnType != Void.TYPE) {
            if (this.returnType.isArray()) {
                added = this.addValuesInArrayIfApplicable();
            } else if (Iterator.class.isAssignableFrom(this.returnType)) {
                added = this.addValuesInIteratorIfApplicable();
            } else if (Iterable.class.isAssignableFrom(this.returnType)) {
                added = this.addValuesInIterableIfApplicable();
            }
        }
        return added;
    }

    private boolean addValuesInArrayIfApplicable() {
        if (this.firstValue == null || !this.firstValue.getClass().isArray()) {
            this.addArrayAsReturnValue();
            return true;
        }
        return false;
    }

    private void addArrayAsReturnValue() {
        Class<?> elementType = this.returnType.getComponentType();
        int n = 1 + this.remainingValues.length;
        Object values = Array.newInstance(elementType, n);
        SequenceOfReturnValues.setArrayElement(elementType, values, 0, this.firstValue);
        for (int i = 1; i < n; ++i) {
            SequenceOfReturnValues.setArrayElement(elementType, values, i, this.remainingValues[i - 1]);
        }
        this.expectation.getResults().addReturnValue(values);
    }

    private static void setArrayElement(Class<?> elementType, Object array, int index, @Nullable Object value) {
        Object arrayValue = value;
        if (value != null) {
            if (elementType == Byte.TYPE || elementType == Byte.class) {
                arrayValue = ((Number)value).byteValue();
            } else if (elementType == Short.TYPE || elementType == Short.class) {
                arrayValue = ((Number)value).shortValue();
            }
        }
        Array.set(array, index, arrayValue);
    }

    private boolean addValuesInIteratorIfApplicable() {
        if (this.firstValue == null || !Iterator.class.isAssignableFrom(this.firstValue.getClass())) {
            ArrayList<Object> values = new ArrayList<Object>(1 + this.remainingValues.length);
            this.addAllValues(values);
            this.expectation.getResults().addReturnValue(values.iterator());
            return true;
        }
        return false;
    }

    private void addAllValues(@Nonnull Collection<Object> values) {
        values.add(this.firstValue);
        Collections.addAll(values, this.remainingValues);
    }

    private boolean addValuesInIterableIfApplicable() {
        if (this.firstValue == null || !Iterable.class.isAssignableFrom(this.firstValue.getClass())) {
            if (this.returnType.isAssignableFrom(List.class)) {
                ArrayList<Object> values = new ArrayList<Object>(1 + this.remainingValues.length);
                this.addReturnValues(values);
                return true;
            }
            if (this.returnType.isAssignableFrom(Set.class)) {
                LinkedHashSet<Object> values = new LinkedHashSet<Object>(1 + this.remainingValues.length);
                this.addReturnValues(values);
                return true;
            }
            if (this.returnType.isAssignableFrom(SortedSet.class)) {
                this.addReturnValues(new TreeSet<Object>());
                return true;
            }
        }
        return false;
    }

    private void addReturnValues(@Nonnull Collection<Object> values) {
        this.addAllValues(values);
        this.expectation.getResults().addReturnValue(values);
    }
}

