/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.expectations.Expectation;
import mockit.internal.expectations.Phase;
import mockit.internal.expectations.RecordAndReplayExecution;
import mockit.internal.expectations.RecordPhase;
import mockit.internal.expectations.invocation.ExpectedInvocation;
import mockit.internal.expectations.invocation.InvocationConstraints;
import mockit.internal.state.TestRun;

final class ReplayPhase
extends Phase {
    private int initialStrictExpectationIndexForCurrentBlock;
    int currentStrictExpectationIndex;
    @Nullable
    private Expectation strictExpectation;
    @Nonnull
    final List<Expectation> invocations = new ArrayList<Expectation>();
    @Nonnull
    final List<Object> invocationInstances = new ArrayList<Object>();
    @Nonnull
    final List<Object[]> invocationArguments = new ArrayList<Object[]>();

    ReplayPhase(@Nonnull RecordAndReplayExecution recordAndReplay) {
        super(recordAndReplay);
        this.initialStrictExpectationIndexForCurrentBlock = Math.max(recordAndReplay.lastExpectationIndexInPreviousReplayPhase, 0);
        this.positionOnFirstStrictExpectation();
    }

    private void positionOnFirstStrictExpectation() {
        List<Expectation> strictExpectations = this.getStrictExpectations();
        if (strictExpectations.isEmpty()) {
            this.currentStrictExpectationIndex = -1;
            this.strictExpectation = null;
        } else {
            this.currentStrictExpectationIndex = this.initialStrictExpectationIndexForCurrentBlock;
            this.strictExpectation = this.currentStrictExpectationIndex < strictExpectations.size() ? strictExpectations.get(this.currentStrictExpectationIndex) : null;
        }
    }

    @Nonnull
    private List<Expectation> getStrictExpectations() {
        return this.recordAndReplay.executionState.strictExpectations;
    }

    @Override
    @Nullable
    Object handleInvocation(@Nullable Object mock, int mockAccess, @Nonnull String mockClassDesc, @Nonnull String mockNameAndDesc, @Nullable String genericSignature, boolean withRealImpl, @Nonnull Object[] args) throws Throwable {
        Object replacementInstance;
        Expectation notStrictExpectation = this.recordAndReplay.executionState.findNotStrictExpectation(mock, mockClassDesc, mockNameAndDesc, args);
        Object object = replacementInstance = mock == null ? null : this.recordAndReplay.executionState.getReplacementInstanceForMethodInvocation(mock, mockNameAndDesc);
        if (notStrictExpectation == null) {
            notStrictExpectation = this.createExpectationIfNotStrictInvocation(replacementInstance == null ? mock : replacementInstance, mockAccess, mockClassDesc, mockNameAndDesc, genericSignature, args);
        } else if (notStrictExpectation.recordPhase != null) {
            this.registerNewInstanceAsEquivalentToOneFromRecordedConstructorInvocation(mock, notStrictExpectation.invocation);
        }
        if (notStrictExpectation != null) {
            this.invocations.add(notStrictExpectation);
            this.invocationInstances.add(mock);
            this.invocationArguments.add(args);
            notStrictExpectation.constraints.incrementInvocationCount();
            if (withRealImpl && replacementInstance != null) {
                return this.produceResult(notStrictExpectation, replacementInstance, args);
            }
            return this.produceResult(notStrictExpectation, mock, withRealImpl, args);
        }
        return this.handleStrictInvocation(mock, mockClassDesc, mockNameAndDesc, withRealImpl, args);
    }

    @Nullable
    private Expectation createExpectationIfNotStrictInvocation(@Nullable Object mock, int mockAccess, @Nonnull String mockClassDesc, @Nonnull String mockNameAndDesc, @Nullable String genericSignature, @Nonnull Object[] args) {
        Expectation expectation = null;
        if (!TestRun.getExecutingTest().isStrictInvocation(mock, mockClassDesc, mockNameAndDesc)) {
            ExpectedInvocation invocation = new ExpectedInvocation(mock, mockAccess, mockClassDesc, mockNameAndDesc, false, genericSignature, args);
            expectation = new Expectation(invocation);
            this.recordAndReplay.executionState.addExpectation(expectation, false);
        }
        return expectation;
    }

    private void registerNewInstanceAsEquivalentToOneFromRecordedConstructorInvocation(@Nullable Object mock, @Nonnull ExpectedInvocation invocation) {
        if (mock != null && invocation.isConstructor()) {
            Map<Object, Object> instanceMap = this.getInstanceMap();
            Object recordedInstance = invocation.getRecordedInstance();
            instanceMap.put(mock, recordedInstance);
        }
    }

    @Nullable
    private Object produceResult(@Nonnull Expectation expectation, @Nonnull Object replacementInstance, @Nonnull Object[] args) throws Throwable {
        if (expectation.recordPhase == null) {
            expectation.executedRealImplementation = true;
        } else if (expectation.constraints.isInvocationCountMoreThanMaximumExpected()) {
            this.recordAndReplay.setErrorThrown(expectation.invocation.errorForUnexpectedInvocation(args));
            return null;
        }
        return expectation.executeRealImplementation(replacementInstance, args);
    }

    @Nullable
    private Object produceResult(@Nonnull Expectation expectation, @Nullable Object mock, boolean withRealImpl, @Nonnull Object[] args) throws Throwable {
        boolean executeRealImpl;
        boolean bl = executeRealImpl = withRealImpl && expectation.recordPhase == null;
        if (executeRealImpl) {
            expectation.executedRealImplementation = true;
            return Void.class;
        }
        if (expectation.constraints.isInvocationCountMoreThanMaximumExpected()) {
            this.recordAndReplay.setErrorThrown(expectation.invocation.errorForUnexpectedInvocation(args));
            return null;
        }
        return expectation.produceResult(mock, args);
    }

    @Nullable
    private Object handleStrictInvocation(@Nullable Object mock, @Nonnull String mockClassDesc, @Nonnull String mockNameAndDesc, boolean withRealImpl, @Nonnull Object[] replayArgs) throws Throwable {
        ExpectedInvocation invocation;
        Map<Object, Object> instanceMap = this.getInstanceMap();
        while (true) {
            Expectation expectation;
            if ((expectation = this.strictExpectation) == null) {
                return this.handleUnexpectedInvocation(mock, mockClassDesc, mockNameAndDesc, withRealImpl, replayArgs);
            }
            invocation = expectation.invocation;
            InvocationConstraints constraints = expectation.constraints;
            if (invocation.isMatch(mock, mockClassDesc, mockNameAndDesc, null)) {
                this.registerNewInstanceAsEquivalentToOneFromRecordedConstructorInvocation(mock, invocation);
                Error error = invocation.assertThatArgumentsMatch(replayArgs, instanceMap);
                if (error != null) {
                    if (constraints.isInvocationCountInExpectedRange()) {
                        this.moveToNextExpectation();
                        continue;
                    }
                    if (withRealImpl) {
                        return Void.class;
                    }
                    this.recordAndReplay.setErrorThrown(error);
                    return null;
                }
                constraints.incrementInvocationCount();
                if (constraints.isInvocationCountAtMaximumAllowed()) {
                    this.moveToNextExpectation();
                } else if (constraints.isInvocationCountMoreThanMaximumExpected()) {
                    this.recordAndReplay.setErrorThrown(invocation.errorForUnexpectedInvocation(replayArgs));
                    return null;
                }
                return expectation.produceResult(mock, replayArgs);
            }
            if (!constraints.isInvocationCountInExpectedRange()) break;
            this.moveToNextExpectation();
        }
        if (withRealImpl) {
            return Void.class;
        }
        this.recordAndReplay.setErrorThrown(invocation.errorForUnexpectedInvocation(mock, mockClassDesc, mockNameAndDesc, replayArgs));
        return null;
    }

    @Nullable
    private Object handleUnexpectedInvocation(@Nullable Object mock, @Nonnull String mockClassDesc, @Nonnull String mockNameAndDesc, boolean withRealImpl, @Nonnull Object[] replayArgs) {
        if (withRealImpl) {
            return Void.class;
        }
        this.recordAndReplay.setErrorThrown(new ExpectedInvocation(mock, mockClassDesc, mockNameAndDesc, replayArgs).errorForUnexpectedInvocation());
        return null;
    }

    private void moveToNextExpectation() {
        List<Expectation> strictExpectations = this.getStrictExpectations();
        assert (this.strictExpectation != null);
        RecordPhase expectationBlock = this.strictExpectation.recordPhase;
        assert (expectationBlock != null);
        ++this.currentStrictExpectationIndex;
        Expectation expectation = this.strictExpectation = this.currentStrictExpectationIndex < strictExpectations.size() ? strictExpectations.get(this.currentStrictExpectationIndex) : null;
        if (expectationBlock.numberOfIterations <= 1) {
            if (this.strictExpectation != null && this.strictExpectation.recordPhase != expectationBlock) {
                this.initialStrictExpectationIndexForCurrentBlock = this.currentStrictExpectationIndex;
            }
        } else if (this.strictExpectation == null || this.strictExpectation.recordPhase != expectationBlock) {
            --expectationBlock.numberOfIterations;
            this.positionOnFirstStrictExpectation();
            this.resetInvocationCountsForStrictExpectations(expectationBlock);
        }
    }

    private void resetInvocationCountsForStrictExpectations(@Nonnull RecordPhase expectationBlock) {
        for (Expectation expectation : this.getStrictExpectations()) {
            if (expectation.recordPhase != expectationBlock) continue;
            expectation.constraints.invocationCount = 0;
        }
    }

    @Nullable
    Error endExecution() {
        Expectation strict = this.strictExpectation;
        this.strictExpectation = null;
        Error missingInvocation = this.getErrorIfStrictExpectationIsMissing(strict);
        if (missingInvocation == null && (missingInvocation = this.getErrorForFirstNotStrictExpectationThatIsMissing()) == null) {
            missingInvocation = this.getErrorIfNextStrictExpectationIsMissing();
        }
        return missingInvocation;
    }

    @Nullable
    private Error getErrorIfStrictExpectationIsMissing(@Nullable Expectation strict) {
        if (strict != null && strict.constraints.isInvocationCountLessThanMinimumExpected()) {
            return strict.invocation.errorForMissingInvocation(Collections.<ExpectedInvocation>emptyList());
        }
        return null;
    }

    @Nullable
    private Error getErrorForFirstNotStrictExpectationThatIsMissing() {
        List<Expectation> notStrictExpectations = this.recordAndReplay.executionState.notStrictExpectations;
        int n = notStrictExpectations.size();
        for (int i = 0; i < n; ++i) {
            Expectation notStrict = notStrictExpectations.get(i);
            InvocationConstraints constraints = notStrict.constraints;
            if (!constraints.isInvocationCountLessThanMinimumExpected()) continue;
            List<ExpectedInvocation> nonMatchingInvocations = this.getNonMatchingInvocations(notStrict);
            return constraints.errorForMissingExpectations(notStrict.invocation, nonMatchingInvocations);
        }
        return null;
    }

    @Nonnull
    private List<ExpectedInvocation> getNonMatchingInvocations(@Nonnull Expectation unsatisfiedExpectation) {
        ExpectedInvocation unsatisfiedInvocation = unsatisfiedExpectation.invocation;
        ArrayList<ExpectedInvocation> nonMatchingInvocations = new ArrayList<ExpectedInvocation>();
        for (Expectation replayedExpectation : this.invocations) {
            ExpectedInvocation replayedInvocation = replayedExpectation.invocation;
            if (replayedExpectation == unsatisfiedExpectation || !replayedInvocation.isMatch(unsatisfiedInvocation)) continue;
            nonMatchingInvocations.add(replayedInvocation);
        }
        return nonMatchingInvocations;
    }

    @Nullable
    private Error getErrorIfNextStrictExpectationIsMissing() {
        int nextStrictExpectationIndex = this.currentStrictExpectationIndex + 1;
        List<Expectation> strictExpectations = this.getStrictExpectations();
        if (nextStrictExpectationIndex < strictExpectations.size()) {
            Expectation nextStrictExpectation = strictExpectations.get(nextStrictExpectationIndex);
            if (nextStrictExpectation.constraints.isInvocationCountLessThanMinimumExpected()) {
                return nextStrictExpectation.invocation.errorForMissingInvocation(Collections.<ExpectedInvocation>emptyList());
            }
        }
        return null;
    }
}

