/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.expectations.Expectation;
import mockit.internal.expectations.RecordAndReplayExecution;
import mockit.internal.expectations.TestOnlyPhase;
import mockit.internal.expectations.invocation.ExpectedInvocation;
import mockit.internal.state.ExecutingTest;
import mockit.internal.state.TestRun;

public final class RecordPhase
extends TestOnlyPhase {
    final boolean strict;

    RecordPhase(@Nonnull RecordAndReplayExecution recordAndReplay, boolean strict) {
        super(recordAndReplay);
        this.strict = strict;
    }

    public void addResult(@Nullable Object result) {
        if (this.currentExpectation != null) {
            this.currentExpectation.addResult(result);
        }
    }

    public void addSequenceOfReturnValues(@Nonnull Object[] values) {
        if (this.currentExpectation != null) {
            this.currentExpectation.addSequenceOfReturnValues(values);
        }
    }

    @Override
    @Nullable
    Object handleInvocation(@Nullable Object mock, int mockAccess, @Nonnull String mockClassDesc, @Nonnull String mockNameAndDesc, @Nullable String genericSignature, boolean withRealImpl, @Nonnull Object[] args) throws Throwable {
        mock = this.configureMatchingOnMockInstanceIfSpecified(mock);
        ExpectedInvocation invocation = new ExpectedInvocation(mock, mockAccess, mockClassDesc, mockNameAndDesc, this.matchInstance, genericSignature, args);
        boolean nonStrictInvocation = false;
        if (this.strict) {
            TestRun.getExecutingTest().addStrictMock(mock, this.matchInstance ? null : mockClassDesc);
        } else if (!this.matchInstance && invocation.isConstructor()) {
            invocation.replacementInstance = mock;
            this.getReplacementMap().put(mock, mock);
        } else {
            nonStrictInvocation = ExecutingTest.isInstanceMethodWithStandardBehavior(mock, mockNameAndDesc);
        }
        this.currentExpectation = new Expectation(this, invocation, this.strict, nonStrictInvocation);
        if (this.argMatchers != null) {
            invocation.arguments.setMatchers(this.argMatchers);
            this.argMatchers = null;
        }
        this.recordAndReplay.executionState.addExpectation(this.currentExpectation, this.strict);
        return invocation.getDefaultValueForReturnType();
    }

    @Nullable
    private Object configureMatchingOnMockInstanceIfSpecified(@Nullable Object mock) {
        this.matchInstance = false;
        if (mock == null) {
            return null;
        }
        Object replacementInstance = this.getReplacementMap().get(mock);
        this.matchInstance = mock == replacementInstance || RecordPhase.isEnumElement(mock);
        return mock;
    }

    @Override
    public void handleInvocationCountConstraint(int minInvocations, int maxInvocations) {
        if (this.currentExpectation != null) {
            int lowerLimit = minInvocations;
            int upperLimit = maxInvocations;
            if (this.numberOfIterations > 1 && !this.strict) {
                lowerLimit *= this.numberOfIterations;
                upperLimit *= this.numberOfIterations;
            }
            this.currentExpectation.constraints.setLimits(lowerLimit, upperLimit);
        }
    }
}

