/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.capturing;

import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.external.asm.ClassReader;
import mockit.external.asm.ClassVisitor;
import mockit.external.asm.Type;
import mockit.internal.BaseClassModifier;
import mockit.internal.ClassFile;
import mockit.internal.ClassIdentification;
import mockit.internal.RedefinitionEngine;
import mockit.internal.capturing.CaptureOfImplementations;
import mockit.internal.capturing.CapturedType;
import mockit.internal.state.TestRun;
import mockit.internal.util.VisitInterruptedException;

public final class CaptureTransformer<M>
implements ClassFileTransformer {
    @Nonnull
    private final CapturedType capturedType;
    @Nonnull
    private final String capturedTypeDesc;
    @Nonnull
    private final CaptureOfImplementations<M> captureOfImplementations;
    @Nonnull
    private final Map<ClassIdentification, byte[]> transformedClasses;
    @Nullable
    private final M typeMetadata;
    private boolean inactive;

    CaptureTransformer(@Nonnull CapturedType capturedType, @Nonnull CaptureOfImplementations<M> captureOfImplementations, boolean registerTransformedClasses, @Nullable M typeMetadata) {
        this.capturedType = capturedType;
        this.capturedTypeDesc = Type.getInternalName(capturedType.baseType);
        this.captureOfImplementations = captureOfImplementations;
        this.transformedClasses = registerTransformedClasses ? new HashMap(2) : Collections.emptyMap();
        this.typeMetadata = typeMetadata;
    }

    public void deactivate() {
        this.inactive = true;
        if (!this.transformedClasses.isEmpty()) {
            RedefinitionEngine redefinitionEngine = new RedefinitionEngine();
            for (Map.Entry<ClassIdentification, byte[]> classNameAndOriginalBytecode : this.transformedClasses.entrySet()) {
                ClassIdentification classId = classNameAndOriginalBytecode.getKey();
                byte[] originalBytecode = classNameAndOriginalBytecode.getValue();
                redefinitionEngine.restoreToDefinition(classId.getLoadedClass(), originalBytecode);
            }
            this.transformedClasses.clear();
        }
    }

    @Override
    @Nullable
    public byte[] transform(@Nullable ClassLoader loader, @Nonnull String classDesc, @Nullable Class<?> classBeingRedefined, @Nullable ProtectionDomain protectionDomain, @Nonnull byte[] classfileBuffer) {
        block3: {
            if (classBeingRedefined != null || this.inactive || CapturedType.isNotToBeCaptured(loader, protectionDomain, classDesc)) {
                return null;
            }
            ClassReader cr = new ClassReader(classfileBuffer);
            SuperTypeCollector superTypeCollector = new SuperTypeCollector(loader);
            try {
                cr.accept(superTypeCollector, 2);
            }
            catch (VisitInterruptedException ignore) {
                if (!superTypeCollector.classExtendsCapturedType) break block3;
                String className = classDesc.replace('/', '.');
                return this.modifyAndRegisterClass(loader, className, cr);
            }
        }
        return null;
    }

    @Nonnull
    private byte[] modifyAndRegisterClass(@Nullable ClassLoader loader, @Nonnull String className, @Nonnull ClassReader cr) {
        BaseClassModifier modifier = this.captureOfImplementations.createModifier(loader, cr, this.capturedType.baseType, this.typeMetadata);
        cr.accept(modifier, 4);
        ClassIdentification classId = new ClassIdentification(loader, className);
        byte[] originalBytecode = cr.b;
        if (this.transformedClasses == Collections.emptyMap()) {
            TestRun.mockFixture().addTransformedClass(classId, originalBytecode);
        } else {
            this.transformedClasses.put(classId, originalBytecode);
        }
        TestRun.mockFixture().registerMockedClass(this.capturedType.baseType);
        return modifier.toByteArray();
    }

    @Nullable
    public <C extends CaptureOfImplementations<?>> C getCaptureOfImplementationsIfApplicable(@Nonnull Class<?> baseType) {
        if (baseType == this.capturedType.baseType && this.typeMetadata != null) {
            return (C)this.captureOfImplementations;
        }
        return null;
    }

    public boolean areCapturedClasses(@Nonnull Class<?> mockedClass1, @Nonnull Class<?> mockedClass2) {
        Class<?> baseType = this.capturedType.baseType;
        return baseType.isAssignableFrom(mockedClass1) && baseType.isAssignableFrom(mockedClass2);
    }

    private final class SuperTypeCollector
    extends ClassVisitor {
        @Nullable
        private final ClassLoader loader;
        boolean classExtendsCapturedType;

        private SuperTypeCollector(ClassLoader loader) {
            this.loader = loader;
        }

        @Override
        public void visit(int version, int access, @Nonnull String name, @Nullable String signature, @Nullable String superName, @Nullable String[] interfaces) {
            boolean haveInterfaces;
            this.classExtendsCapturedType = false;
            if (CaptureTransformer.this.capturedTypeDesc.equals(superName)) {
                this.classExtendsCapturedType = true;
                throw VisitInterruptedException.INSTANCE;
            }
            boolean bl = haveInterfaces = interfaces != null && interfaces.length > 0;
            if (haveInterfaces) {
                for (String implementedInterface : interfaces) {
                    if (!CaptureTransformer.this.capturedTypeDesc.equals(implementedInterface)) continue;
                    this.classExtendsCapturedType = true;
                    throw VisitInterruptedException.INSTANCE;
                }
            }
            if (superName != null) {
                if (!"java/lang/Object mockit/MockUp".contains(superName)) {
                    this.searchSuperType(superName);
                }
                if (haveInterfaces) {
                    for (String implementedInterface : interfaces) {
                        this.searchSuperType(implementedInterface);
                    }
                }
            }
            throw VisitInterruptedException.INSTANCE;
        }

        private void searchSuperType(@Nonnull String superName) {
            block2: {
                ClassReader cr = ClassFile.createClassFileReader(this.loader, superName);
                try {
                    cr.accept(this, 2);
                }
                catch (VisitInterruptedException e) {
                    if (!this.classExtendsCapturedType) break block2;
                    throw e;
                }
            }
        }
    }
}

