/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.external.asm.ClassReader;
import mockit.external.asm.ClassVisitor;
import mockit.internal.state.CachedClassfiles;
import mockit.internal.state.TestRun;

public final class ClassFile {
    private static final Map<String, ClassReader> CLASS_FILES = new ConcurrentHashMap<String, ClassReader>();

    private ClassFile() {
    }

    private static void verifyClassFileFound(@Nullable InputStream classFile, @Nonnull String classNameOrDesc) {
        if (classFile == null) {
            throw new NotFoundException(classNameOrDesc);
        }
    }

    @Nonnull
    public static ClassReader createClassFileReader(@Nonnull Class<?> aClass) {
        byte[] cachedClassfile = CachedClassfiles.getClassfile(aClass);
        if (cachedClassfile != null) {
            return new ClassReader(cachedClassfile);
        }
        String className = aClass.getName();
        InputStream classFile = aClass.getResourceAsStream('/' + className.replace('.', '/') + ".class");
        ClassFile.verifyClassFileFound(classFile, className);
        try {
            return new ClassReader(classFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read class file for " + className, e);
        }
    }

    @Nonnull
    public static ClassReader createReaderOrGetFromCache(@Nonnull Class<?> aClass) {
        byte[] cachedClassfile = CachedClassfiles.getClassfile(aClass);
        if (cachedClassfile != null) {
            return new ClassReader(cachedClassfile);
        }
        String classDesc = aClass.getName().replace('.', '/');
        ClassReader reader = CLASS_FILES.get(classDesc);
        if (reader == null) {
            reader = ClassFile.readFromFile(classDesc);
            CLASS_FILES.put(classDesc, reader);
        }
        return reader;
    }

    @Nonnull
    private static InputStream readClassFromClasspath(@Nonnull String classDesc) {
        Class<?> testClass;
        ClassLoader thisClassLoader;
        String classFileName = classDesc + ".class";
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = null;
        if (contextClassLoader != null) {
            inputStream = contextClassLoader.getResourceAsStream(classFileName);
        }
        if (inputStream == null && (thisClassLoader = ClassFile.class.getClassLoader()) != contextClassLoader && (inputStream = thisClassLoader.getResourceAsStream(classFileName)) == null && (testClass = TestRun.getCurrentTestClass()) != null) {
            inputStream = testClass.getClassLoader().getResourceAsStream(classFileName);
        }
        ClassFile.verifyClassFileFound(inputStream, classDesc);
        return inputStream;
    }

    @Nonnull
    public static ClassReader createReaderFromLastRedefinitionIfAny(@Nonnull Class<?> aClass) {
        byte[] classfile = TestRun.mockFixture().getRedefinedClassfile(aClass);
        if (classfile == null) {
            classfile = CachedClassfiles.getClassfile(aClass);
        }
        if (classfile != null) {
            return new ClassReader(classfile);
        }
        String classDesc = aClass.getName().replace('.', '/');
        ClassReader reader = ClassFile.readFromFile(classDesc);
        CLASS_FILES.put(classDesc, reader);
        return reader;
    }

    @Nonnull
    public static ClassReader createClassFileReader(@Nullable ClassLoader loader, @Nonnull String internalClassName) {
        byte[] cachedClassfile = CachedClassfiles.getClassfile(loader, internalClassName);
        if (cachedClassfile != null) {
            return new ClassReader(cachedClassfile);
        }
        return ClassFile.readFromFile(internalClassName);
    }

    @Nonnull
    public static ClassReader readFromFile(@Nonnull Class<?> aClass) {
        String classDesc = aClass.getName().replace('.', '/');
        return ClassFile.readFromFile(classDesc);
    }

    @Nonnull
    public static ClassReader readFromFile(@Nonnull String classDesc) {
        byte[] classfile;
        if ((classDesc.startsWith("java/") || classDesc.startsWith("javax/")) && (classfile = CachedClassfiles.getClassfile(classDesc)) != null) {
            return new ClassReader(classfile);
        }
        InputStream classFile = ClassFile.readClassFromClasspath(classDesc);
        try {
            return new ClassReader(classFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read class file for " + classDesc.replace('/', '.'), e);
        }
    }

    public static void visitClass(@Nonnull String classDesc, @Nonnull ClassVisitor visitor) {
        byte[] classfile = CachedClassfiles.getClassfile(classDesc);
        ClassReader cr = classfile != null ? new ClassReader(classfile) : ClassFile.readFromFile(classDesc);
        cr.accept(visitor, 6);
    }

    public static final class NotFoundException
    extends RuntimeException {
        private NotFoundException(@Nonnull String classNameOrDesc) {
            super("Unable to find class file for " + classNameOrDesc.replace('/', '.'));
        }
    }
}

