/*
 * Decompiled with CFR 0.152.
 */
package mockit.integration.junit5;

import mockit.Invocation;
import mockit.Mock;
import mockit.MockUp;
import mockit.integration.junit5.JMockitExtension;
import mockit.internal.startup.Startup;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;

public final class JMockitTestEngine
implements TestEngine {
    private static TestDescriptor descriptor;

    public JMockitTestEngine() {
        if (descriptor != null) {
            return;
        }
        descriptor = new EngineDescriptor(UniqueId.forEngine((String)"jmockit"), "JMockit integration");
        if (Startup.initializeIfPossible()) {
            new MockUp<ExtensionRegistry>(){

                @Mock
                ExtensionRegistry createRegistryWithDefaultExtensions(Invocation inv) {
                    ExtensionRegistry registry = (ExtensionRegistry)inv.proceed(new Object[0]);
                    JMockitExtension extension = new JMockitExtension();
                    registry.registerExtension((Extension)extension, (Object)extension);
                    return registry;
                }
            };
        }
    }

    public String getId() {
        return "jmockit";
    }

    public TestDescriptor discover(EngineDiscoveryRequest discoveryRequest, UniqueId uniqueId) {
        return descriptor;
    }

    public void execute(ExecutionRequest executionRequest) {
        EngineExecutionListener executionListener = executionRequest.getEngineExecutionListener();
        executionListener.executionStarted(descriptor);
        executionListener.executionFinished(descriptor, TestExecutionResult.successful());
    }
}

