/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.paths;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import mockit.coverage.CoveragePercentage;
import mockit.coverage.data.PerFileCoverage;
import mockit.coverage.paths.MethodCoverageData;

public final class PerFilePathCoverage
implements PerFileCoverage {
    private static final long serialVersionUID = 6075064821486644269L;
    @Nonnull
    public final Map<Integer, MethodCoverageData> firstLineToMethodData = new HashMap<Integer, MethodCoverageData>();
    private transient int totalPaths;
    private transient int coveredPaths;

    public PerFilePathCoverage() {
        this.initializeCache();
    }

    private void initializeCache() {
        this.coveredPaths = -1;
        this.totalPaths = -1;
    }

    private void readObject(@Nonnull ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.initializeCache();
        in.defaultReadObject();
    }

    public void addMethod(@Nonnull MethodCoverageData methodData) {
        int firstLineInBody = methodData.getFirstLineInBody();
        this.firstLineToMethodData.put(firstLineInBody, methodData);
    }

    public int registerExecution(int firstLineInMethodBody, int node) {
        MethodCoverageData methodData = this.firstLineToMethodData.get(firstLineInMethodBody);
        if (methodData != null) {
            return methodData.markNodeAsReached(node);
        }
        return -1;
    }

    @Override
    public int getTotalItems() {
        this.computeValuesIfNeeded();
        return this.totalPaths;
    }

    @Override
    public int getCoveredItems() {
        this.computeValuesIfNeeded();
        return this.coveredPaths;
    }

    @Override
    public int getCoveragePercentage() {
        this.computeValuesIfNeeded();
        return CoveragePercentage.calculate(this.coveredPaths, this.totalPaths);
    }

    private void computeValuesIfNeeded() {
        if (this.totalPaths >= 0) {
            return;
        }
        this.coveredPaths = 0;
        this.totalPaths = 0;
        for (MethodCoverageData method : this.firstLineToMethodData.values()) {
            this.totalPaths += method.getTotalPaths();
            this.coveredPaths += method.getCoveredPaths();
        }
    }

    public void reset() {
        for (MethodCoverageData methodData : this.firstLineToMethodData.values()) {
            methodData.reset();
        }
        this.initializeCache();
    }

    public void mergeInformation(@Nonnull PerFilePathCoverage previousCoverage) {
        Map<Integer, MethodCoverageData> previousInfo = previousCoverage.firstLineToMethodData;
        this.addExecutionCountsFromPreviousTestRun(previousInfo);
        this.addPathInfoFromPreviousTestRunForMethodsNotExecutedInCurrentTestRun(previousInfo);
    }

    private void addExecutionCountsFromPreviousTestRun(@Nonnull Map<Integer, MethodCoverageData> previousInfo) {
        for (Map.Entry<Integer, MethodCoverageData> firstLineAndInfo : this.firstLineToMethodData.entrySet()) {
            Integer firstLine = firstLineAndInfo.getKey();
            MethodCoverageData previousPathInfo = previousInfo.get(firstLine);
            if (previousPathInfo == null) continue;
            MethodCoverageData pathInfo = firstLineAndInfo.getValue();
            pathInfo.addCountsFromPreviousTestRun(previousPathInfo);
        }
    }

    private void addPathInfoFromPreviousTestRunForMethodsNotExecutedInCurrentTestRun(@Nonnull Map<Integer, MethodCoverageData> previousInfo) {
        for (Map.Entry<Integer, MethodCoverageData> firstLineAndInfo : previousInfo.entrySet()) {
            Integer firstLine = firstLineAndInfo.getKey();
            if (this.firstLineToMethodData.containsKey(firstLine)) continue;
            MethodCoverageData pathInfo = firstLineAndInfo.getValue();
            this.firstLineToMethodData.put(firstLine, pathInfo);
        }
    }
}

