// Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package v20180426

import (
    "github.com/tencentcloud/tencentcloud-sdk-go/tencentcloud/common"
    tchttp "github.com/tencentcloud/tencentcloud-sdk-go/tencentcloud/common/http"
    "github.com/tencentcloud/tencentcloud-sdk-go/tencentcloud/common/profile"
)

const APIVersion = "2018-04-26"

type Client struct {
    common.Client
}

// Deprecated
func NewClientWithSecretId(secretId, secretKey, region string) (client *Client, err error) {
    cpf := profile.NewClientProfile()
    client = &Client{}
    client.Init(region).WithSecretId(secretId, secretKey).WithProfile(cpf)
    return
}

func NewClient(credential *common.Credential, region string, clientProfile *profile.ClientProfile) (client *Client, err error) {
    client = &Client{}
    client.Init(region).
        WithCredential(credential).
        WithProfile(clientProfile)
    return
}


func NewDeleteCertRequest() (request *DeleteCertRequest) {
    request = &DeleteCertRequest{
        BaseRequest: &tchttp.BaseRequest{},
    }
    request.Init().WithApiInfo("wss", APIVersion, "DeleteCert")
    return
}

func NewDeleteCertResponse() (response *DeleteCertResponse) {
    response = &DeleteCertResponse{
        BaseResponse: &tchttp.BaseResponse{},
    }
    return
}

// 本接口（DeleteCert）用于删除证书。
func (c *Client) DeleteCert(request *DeleteCertRequest) (response *DeleteCertResponse, err error) {
    if request == nil {
        request = NewDeleteCertRequest()
    }
    response = NewDeleteCertResponse()
    err = c.Send(request, response)
    return
}

func NewDescribeCertListRequest() (request *DescribeCertListRequest) {
    request = &DescribeCertListRequest{
        BaseRequest: &tchttp.BaseRequest{},
    }
    request.Init().WithApiInfo("wss", APIVersion, "DescribeCertList")
    return
}

func NewDescribeCertListResponse() (response *DescribeCertListResponse) {
    response = &DescribeCertListResponse{
        BaseResponse: &tchttp.BaseResponse{},
    }
    return
}

// 本接口(DescribeCertList)用于获取证书列表。
func (c *Client) DescribeCertList(request *DescribeCertListRequest) (response *DescribeCertListResponse, err error) {
    if request == nil {
        request = NewDescribeCertListRequest()
    }
    response = NewDescribeCertListResponse()
    err = c.Send(request, response)
    return
}

func NewUploadCertRequest() (request *UploadCertRequest) {
    request = &UploadCertRequest{
        BaseRequest: &tchttp.BaseRequest{},
    }
    request.Init().WithApiInfo("wss", APIVersion, "UploadCert")
    return
}

func NewUploadCertResponse() (response *UploadCertResponse) {
    response = &UploadCertResponse{
        BaseResponse: &tchttp.BaseResponse{},
    }
    return
}

// 本接口（UploadCert）用于上传证书。
func (c *Client) UploadCert(request *UploadCertRequest) (response *UploadCertResponse, err error) {
    if request == nil {
        request = NewUploadCertRequest()
    }
    response = NewUploadCertResponse()
    err = c.Send(request, response)
    return
}
