/*
 * Decompiled with CFR 0.152.
 */
package osx.macadapter;

import com.apple.eawt.AboutHandler;
import com.apple.eawt.AppEvent;
import com.apple.eawt.AppReOpenedListener;
import com.apple.eawt.Application;
import com.apple.eawt.FullScreenUtilities;
import com.apple.eawt.OpenFilesHandler;
import com.apple.eawt.PreferencesHandler;
import com.apple.eawt.QuitHandler;
import com.apple.eawt.QuitResponse;
import java.io.File;
import java.util.List;
import net.sf.jabref.gui.JabRefFrame;

public class MacAdapter
implements PreferencesHandler,
AboutHandler,
QuitHandler,
OpenFilesHandler,
AppReOpenedListener {
    private JabRefFrame parentFrame;

    public void registerMacEvents(JabRefFrame inputFrame) {
        this.parentFrame = inputFrame;
        Application.getApplication().setOpenFileHandler(this);
        Application.getApplication().setAboutHandler(this);
        Application.getApplication().setPreferencesHandler(this);
        Application.getApplication().setQuitHandler(this);
        Application.getApplication().addAppEventListener(this);
        FullScreenUtilities.setWindowCanFullScreen(this.parentFrame, true);
    }

    @Override
    public void openFiles(AppEvent.OpenFilesEvent event) {
        if (this.parentFrame == null) {
            return;
        }
        List<File> files = event.getFiles();
        for (File file : files) {
            this.parentFrame.openAction(file.getAbsolutePath());
        }
    }

    @Override
    public void handleQuitRequestWith(AppEvent.QuitEvent evt, QuitResponse resp) {
        if (this.parentFrame == null) {
            return;
        }
        if (this.parentFrame.quit()) {
            resp.performQuit();
        } else {
            resp.cancelQuit();
        }
    }

    @Override
    public void handleAbout(AppEvent.AboutEvent arg0) {
        if (this.parentFrame == null) {
            return;
        }
        this.parentFrame.about();
    }

    @Override
    public void handlePreferences(AppEvent.PreferencesEvent arg0) {
        if (this.parentFrame == null) {
            return;
        }
        this.parentFrame.showPreferencesDialog();
    }

    @Override
    public void appReOpened(AppEvent.AppReOpenedEvent appReOpenedEvent) {
        this.parentFrame.setVisible(true);
    }
}

