/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.matchers;

import java.util.Map;
import javax.xml.transform.Source;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.w3c.dom.Node;
import org.xmlunit.builder.Input;
import org.xmlunit.util.Convert;
import org.xmlunit.xpath.JAXPXPathEngine;

public class HasXPathMatcher
extends BaseMatcher<Object> {
    private String xPath;
    private Map<String, String> prefix2Uri;

    public HasXPathMatcher(String xPath) {
        this.xPath = xPath;
    }

    @Override
    public boolean matches(Object object) {
        JAXPXPathEngine engine = new JAXPXPathEngine();
        if (this.prefix2Uri != null) {
            engine.setNamespaceContext(this.prefix2Uri);
        }
        Source s = Input.from(object).build();
        Node n = Convert.toNode(s);
        Iterable<Node> nodes = engine.selectNodes(this.xPath, n);
        return nodes.iterator().hasNext();
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("XML with XPath ").appendText(this.xPath);
    }

    @Override
    public void describeMismatch(Object item, Description mismatchDescription) {
        mismatchDescription.appendText("XPath returned no results.");
    }

    @Factory
    public static HasXPathMatcher hasXPath(String xPath) {
        return new HasXPathMatcher(xPath);
    }

    public HasXPathMatcher withNamespaceContext(Map<String, String> prefix2Uri) {
        this.prefix2Uri = prefix2Uri;
        return this;
    }
}

