/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jsoup.SerializationException;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.BooleanAttribute;
import org.jsoup.nodes.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attributes
implements Iterable<Attribute>,
Cloneable {
    protected static final String dataPrefix = "data-";
    private LinkedHashMap<String, Attribute> attributes = null;

    public String get(String key) {
        Validate.notEmpty(key);
        if (this.attributes == null) {
            return "";
        }
        Attribute attr = this.attributes.get(key);
        return attr != null ? attr.getValue() : "";
    }

    public String getIgnoreCase(String key) {
        Validate.notEmpty(key);
        if (this.attributes == null) {
            return "";
        }
        for (String attrKey : this.attributes.keySet()) {
            if (!attrKey.equalsIgnoreCase(key)) continue;
            return this.attributes.get(attrKey).getValue();
        }
        return "";
    }

    public void put(String key, String value) {
        Attribute attr = new Attribute(key, value);
        this.put(attr);
    }

    public void put(String key, boolean value) {
        if (value) {
            this.put(new BooleanAttribute(key));
        } else {
            this.remove(key);
        }
    }

    public void put(Attribute attribute) {
        Validate.notNull(attribute);
        if (this.attributes == null) {
            this.attributes = new LinkedHashMap(2);
        }
        this.attributes.put(attribute.getKey(), attribute);
    }

    public void remove(String key) {
        Validate.notEmpty(key);
        if (this.attributes == null) {
            return;
        }
        this.attributes.remove(key);
    }

    public void removeIgnoreCase(String key) {
        Validate.notEmpty(key);
        if (this.attributes == null) {
            return;
        }
        for (String attrKey : this.attributes.keySet()) {
            if (!attrKey.equalsIgnoreCase(key)) continue;
            this.attributes.remove(attrKey);
        }
    }

    public boolean hasKey(String key) {
        return this.attributes != null && this.attributes.containsKey(key);
    }

    public boolean hasKeyIgnoreCase(String key) {
        if (this.attributes == null) {
            return false;
        }
        for (String attrKey : this.attributes.keySet()) {
            if (!attrKey.equalsIgnoreCase(key)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        if (this.attributes == null) {
            return 0;
        }
        return this.attributes.size();
    }

    public void addAll(Attributes incoming) {
        if (incoming.size() == 0) {
            return;
        }
        if (this.attributes == null) {
            this.attributes = new LinkedHashMap(incoming.size());
        }
        this.attributes.putAll(incoming.attributes);
    }

    @Override
    public Iterator<Attribute> iterator() {
        if (this.attributes == null || this.attributes.isEmpty()) {
            return Collections.emptyList().iterator();
        }
        return this.attributes.values().iterator();
    }

    public List<Attribute> asList() {
        if (this.attributes == null) {
            return Collections.emptyList();
        }
        ArrayList<Attribute> list = new ArrayList<Attribute>(this.attributes.size());
        for (Map.Entry<String, Attribute> entry : this.attributes.entrySet()) {
            list.add(entry.getValue());
        }
        return Collections.unmodifiableList(list);
    }

    public Map<String, String> dataset() {
        return new Dataset();
    }

    public String html() {
        StringBuilder accum = new StringBuilder();
        try {
            this.html(accum, new Document("").outputSettings());
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
        return accum.toString();
    }

    void html(Appendable accum, Document.OutputSettings out) throws IOException {
        if (this.attributes == null) {
            return;
        }
        for (Map.Entry<String, Attribute> entry : this.attributes.entrySet()) {
            Attribute attribute = entry.getValue();
            accum.append(" ");
            attribute.html(accum, out);
        }
    }

    public String toString() {
        return this.html();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Attributes)) {
            return false;
        }
        Attributes that = (Attributes)o;
        return !(this.attributes == null ? that.attributes != null : !this.attributes.equals(that.attributes));
    }

    public int hashCode() {
        return this.attributes != null ? this.attributes.hashCode() : 0;
    }

    public Attributes clone() {
        Attributes clone;
        if (this.attributes == null) {
            return new Attributes();
        }
        try {
            clone = (Attributes)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        clone.attributes = new LinkedHashMap(this.attributes.size());
        for (Attribute attribute : this) {
            clone.attributes.put(attribute.getKey(), attribute.clone());
        }
        return clone;
    }

    private static String dataKey(String key) {
        return dataPrefix + key;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Dataset
    extends AbstractMap<String, String> {
        private Dataset() {
            if (Attributes.this.attributes == null) {
                Attributes.this.attributes = new LinkedHashMap(2);
            }
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            return new EntrySet();
        }

        @Override
        public String put(String key, String value) {
            String dataKey = Attributes.dataKey(key);
            String oldValue = Attributes.this.hasKey(dataKey) ? ((Attribute)Attributes.this.attributes.get(dataKey)).getValue() : null;
            Attribute attr = new Attribute(dataKey, value);
            Attributes.this.attributes.put(dataKey, attr);
            return oldValue;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class DatasetIterator
        implements Iterator<Map.Entry<String, String>> {
            private Iterator<Attribute> attrIter;
            private Attribute attr;

            private DatasetIterator() {
                this.attrIter = Attributes.this.attributes.values().iterator();
            }

            @Override
            public boolean hasNext() {
                while (this.attrIter.hasNext()) {
                    this.attr = this.attrIter.next();
                    if (!this.attr.isDataAttribute()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Map.Entry<String, String> next() {
                return new Attribute(this.attr.getKey().substring(Attributes.dataPrefix.length()), this.attr.getValue());
            }

            @Override
            public void remove() {
                Attributes.this.attributes.remove(this.attr.getKey());
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class EntrySet
        extends AbstractSet<Map.Entry<String, String>> {
            private EntrySet() {
            }

            @Override
            public Iterator<Map.Entry<String, String>> iterator() {
                return new DatasetIterator();
            }

            @Override
            public int size() {
                int count = 0;
                DatasetIterator iter = new DatasetIterator();
                while (iter.hasNext()) {
                    ++count;
                }
                return count;
            }
        }
    }
}

