/*
 * Decompiled with CFR 0.152.
 */
package org.jbibtex;

import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jbibtex.BibTeXComment;
import org.jbibtex.BibTeXDatabase;
import org.jbibtex.BibTeXEntry;
import org.jbibtex.BibTeXInclude;
import org.jbibtex.BibTeXObject;
import org.jbibtex.BibTeXParserConstants;
import org.jbibtex.BibTeXParserTokenManager;
import org.jbibtex.BibTeXPreamble;
import org.jbibtex.BibTeXString;
import org.jbibtex.ConcateValue;
import org.jbibtex.CrossReferenceValue;
import org.jbibtex.DigitStringValue;
import org.jbibtex.Key;
import org.jbibtex.KeyMap;
import org.jbibtex.KeyValue;
import org.jbibtex.ObjectResolutionException;
import org.jbibtex.ParseException;
import org.jbibtex.Provider;
import org.jbibtex.ReferenceValue;
import org.jbibtex.SimpleCharStream;
import org.jbibtex.StreamProvider;
import org.jbibtex.StringProvider;
import org.jbibtex.StringUtil;
import org.jbibtex.StringValue;
import org.jbibtex.Token;
import org.jbibtex.TokenMgrException;
import org.jbibtex.Value;

public class BibTeXParser
implements BibTeXParserConstants {
    private KeyMap<BibTeXString> macros = new KeyMap();
    private BibTeXDatabase database = null;
    private List<Exception> exceptions = new ArrayList<Exception>();
    private long id = 1L;
    public BibTeXParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[15];
    private static int[] jj_la1_0;
    private final JJCalls[] jj_2_rtns = new JJCalls[7];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public BibTeXParser() throws ParseException, TokenMgrException {
        this("");
        this.addMacro("jan", "January");
        this.addMacro("feb", "February");
        this.addMacro("mar", "March");
        this.addMacro("apr", "April");
        this.addMacro("may", "May");
        this.addMacro("jun", "June");
        this.addMacro("jul", "July");
        this.addMacro("aug", "August");
        this.addMacro("sep", "September");
        this.addMacro("oct", "October");
        this.addMacro("nov", "November");
        this.addMacro("dec", "December");
    }

    public BibTeXDatabase parse(Reader reader) throws ObjectResolutionException, ParseException, TokenMgrException {
        this.ReInit(new StreamProvider(reader));
        this.token_source.SwitchTo(0);
        return this.Database(false);
    }

    public BibTeXDatabase parseFully(Reader reader) throws ObjectResolutionException {
        this.ReInit(new StreamProvider(reader));
        this.token_source.SwitchTo(0);
        try {
            return this.Database(true);
        }
        catch (TokenMgrException tme) {
            throw new RuntimeException(tme);
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe);
        }
    }

    public void checkStringResolution(Key key, BibTeXString string) {
        if (string == null) {
            throw new ObjectResolutionException(key);
        }
    }

    private void resolveCrossReferences() {
        Map<Key, BibTeXEntry> entries = this.getDatabase().getEntries();
        for (BibTeXEntry entry : entries.values()) {
            Map<Key, Value> fields = entry.getFields();
            Value value = fields.get(BibTeXEntry.KEY_CROSSREF);
            if (value == null || value instanceof CrossReferenceValue) continue;
            Key key = new Key(value.toUserString());
            BibTeXEntry object = this.getDatabase().resolveEntry(key);
            this.checkCrossReferenceResolution(key, object);
            entry.addField(BibTeXEntry.KEY_CROSSREF, new CrossReferenceValue(value, object));
        }
    }

    public void checkCrossReferenceResolution(Key key, BibTeXEntry entry) {
        if (entry == null) {
            throw new ObjectResolutionException(key);
        }
    }

    public String nextKey() {
        return String.valueOf("jbibtex-" + this.id++);
    }

    public BibTeXDatabase getDatabase() {
        return this.database;
    }

    private void setDatabase(BibTeXDatabase database) {
        this.database = database;
    }

    public List<Exception> getExceptions() {
        return Collections.unmodifiableList(this.exceptions);
    }

    public KeyMap<BibTeXString> getMacros() {
        return this.macros;
    }

    public void addMacro(String key, String value) {
        this.addMacro(new BibTeXString(new Key(key), new StringValue(value, StringValue.Style.BRACED)));
    }

    public void addMacro(BibTeXString macro) {
        this.macros.put(macro.getKey(), macro);
    }

    public void removeMacro(String key) {
        this.macros.remove(new Key(key));
    }

    public void removeMacro(BibTeXString macro) {
        this.macros.remove(macro.getKey());
    }

    private static boolean isDigitString(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return string.length() > 0;
    }

    /*
     * Unable to fully structure code
     */
    private final BibTeXDatabase Database(boolean performErrorRecovery) throws ParseException {
        database = new BibTeXDatabase();
        object = null;
        this.setDatabase(database);
        this.exceptions.clear();
        while (true) lbl-1000:
        // 5 sources

        {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 11: 
                case 12: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    ** break;
                }
            }
            try {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 12: {
                        this.jj_consume_token(12);
                    }
                    case 11: {
                        object = this.Object();
                        database.addObject(object);
                    }
                }
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            catch (TokenMgrException tme) {
                if (!performErrorRecovery) {
                    throw tme;
                }
                this.exceptions.add(tme);
                this.SkipTo("@");
            }
            catch (ParseException pe) {
                if (!performErrorRecovery) {
                    throw pe;
                }
                this.exceptions.add(pe);
                this.SkipTo("@");
                continue;
            }
            break;
        }
        ** GOTO lbl-1000
lbl41:
        // 1 sources

        this.jj_consume_token(0);
        this.resolveCrossReferences();
        this.setDatabase(null);
        return database;
    }

    private final BibTeXObject Object() throws ParseException {
        BibTeXObject object;
        if (this.jj_2_1(Integer.MAX_VALUE)) {
            object = this.Comment();
        } else if (this.jj_2_2(Integer.MAX_VALUE)) {
            object = this.Include();
        } else if (this.jj_2_3(Integer.MAX_VALUE)) {
            object = this.Preamble();
        } else if (this.jj_2_4(Integer.MAX_VALUE)) {
            object = this.String();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 11: {
                    object = this.Entry();
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return object;
    }

    private final BibTeXComment Comment() throws ParseException {
        this.jj_consume_token(11);
        this.jj_consume_token(20);
        this.jj_consume_token(15);
        String string = this.Literal(1, "}");
        return new BibTeXComment(new StringValue(string, StringValue.Style.BRACED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final BibTeXInclude Include() throws ParseException {
        BibTeXDatabase database;
        this.jj_consume_token(11);
        this.jj_consume_token(21);
        this.jj_consume_token(15);
        String string = this.Literal(1, "}");
        try {
            FileReader reader = new FileReader(string);
            try {
                BibTeXParser parser = new BibTeXParser();
                database = parser.parse(reader);
            }
            finally {
                ((Reader)reader).close();
            }
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage());
        }
        return new BibTeXInclude(new StringValue(string, StringValue.Style.BRACED), database);
    }

    private final BibTeXPreamble Preamble() throws ParseException {
        Value value;
        this.jj_consume_token(11);
        this.jj_consume_token(22);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 16: {
                this.jj_consume_token(16);
                value = this.Value();
                this.jj_consume_token(19);
                break;
            }
            case 15: {
                this.jj_consume_token(15);
                value = this.Value();
                this.jj_consume_token(18);
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new BibTeXPreamble(value);
    }

    private final BibTeXString String() throws ParseException {
        Field field;
        this.jj_consume_token(11);
        this.jj_consume_token(23);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 16: {
                this.jj_consume_token(16);
                field = this.Assignment();
                this.jj_consume_token(19);
                break;
            }
            case 15: {
                this.jj_consume_token(15);
                field = this.Assignment();
                this.jj_consume_token(18);
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new BibTeXString(field.getKey(), field.getValue());
    }

    private final BibTeXEntry Entry() throws ParseException {
        List<Field> fields;
        Token key = null;
        this.jj_consume_token(11);
        Token type = this.jj_consume_token(24);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 16: {
                this.jj_consume_token(16);
                if (this.jj_2_5(Integer.MAX_VALUE)) {
                    key = this.Identifier();
                    this.jj_consume_token(12);
                    fields = this.AssignmentList();
                } else {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 12: 
                        case 20: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 12: {
                                    this.jj_consume_token(12);
                                    break;
                                }
                                default: {
                                    this.jj_la1[5] = this.jj_gen;
                                }
                            }
                            fields = this.AssignmentList();
                            break;
                        }
                        default: {
                            this.jj_la1[6] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 12: {
                        this.jj_consume_token(12);
                        break;
                    }
                    default: {
                        this.jj_la1[7] = this.jj_gen;
                    }
                }
                this.jj_consume_token(19);
                break;
            }
            case 15: {
                this.jj_consume_token(15);
                if (this.jj_2_6(Integer.MAX_VALUE)) {
                    key = this.Identifier();
                    this.jj_consume_token(12);
                    fields = this.AssignmentList();
                } else {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 12: 
                        case 20: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 12: {
                                    this.jj_consume_token(12);
                                    break;
                                }
                                default: {
                                    this.jj_la1[8] = this.jj_gen;
                                }
                            }
                            fields = this.AssignmentList();
                            break;
                        }
                        default: {
                            this.jj_la1[9] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 12: {
                        this.jj_consume_token(12);
                        break;
                    }
                    default: {
                        this.jj_la1[10] = this.jj_gen;
                    }
                }
                this.jj_consume_token(18);
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        BibTeXEntry entry = new BibTeXEntry(new Key(type.image), key != null ? new Key(key.image) : new Key(this.nextKey()));
        for (Field field : fields) {
            entry.addField(field.getKey(), field.getValue());
        }
        return entry;
    }

    private final Field Assignment() throws ParseException {
        Key key = this.Key();
        this.jj_consume_token(13);
        Value value = this.Value();
        return new Field(key, value);
    }

    private final List<Field> AssignmentList() throws ParseException {
        ArrayList<Field> fields = new ArrayList<Field>();
        Field field = this.Assignment();
        fields.add(field);
        while (this.jj_2_7(Integer.MAX_VALUE)) {
            this.jj_consume_token(12);
            field = this.Assignment();
            fields.add(field);
        }
        return fields;
    }

    private final Token Identifier() throws ParseException {
        Token token = this.Name();
        return token;
    }

    private final Token Name() throws ParseException {
        Token token;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 20: {
                token = this.jj_consume_token(20);
                break;
            }
            case 21: {
                token = this.jj_consume_token(21);
                break;
            }
            case 22: {
                token = this.jj_consume_token(22);
                break;
            }
            case 23: {
                token = this.jj_consume_token(23);
                break;
            }
            case 24: {
                token = this.jj_consume_token(24);
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return token;
    }

    private final Key Key() throws ParseException {
        Token token = this.Name();
        return new Key(token.image);
    }

    private final Value Value() throws ParseException {
        Value right = null;
        Value left = this.SimpleValue();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 14: {
                this.jj_consume_token(14);
                right = this.Value();
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
            }
        }
        if (right != null) {
            return new ConcateValue(left, right);
        }
        return left;
    }

    private final Value SimpleValue() throws ParseException {
        Value result;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 15: {
                this.jj_consume_token(15);
                String string = this.Literal(1, "}");
                result = new StringValue(string, StringValue.Style.BRACED);
                break;
            }
            case 17: {
                this.jj_consume_token(17);
                String string = this.Literal(0, "\"");
                result = new StringValue(string, StringValue.Style.QUOTED);
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                Token token = this.Name();
                boolean digits = BibTeXParser.isDigitString(token.image);
                if (!digits) {
                    KeyValue value = new KeyValue(token.image);
                    Key key = value.toKey();
                    BibTeXString object = this.getDatabase().resolveString(key);
                    if (object == null) {
                        KeyMap<BibTeXString> macros = this.getMacros();
                        object = (BibTeXString)macros.get(key);
                    }
                    this.checkStringResolution(key, object);
                    result = new ReferenceValue(value, object);
                    break;
                }
                result = new DigitStringValue(token.image);
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return result;
    }

    private void SkipTo(String symbol) throws ParseException, ParseException {
        if (symbol == null) {
            throw new IllegalArgumentException();
        }
        this.SetState(3);
        Token prevToken = null;
        Token token = this.getNextToken();
        while (true) {
            if (token.kind == 0) {
                throw new ParseException("Reached unexpected EOF token");
            }
            if (symbol.equals(token.image)) break;
            prevToken = token;
            token = this.getNextToken();
        }
        this.token_source.backup(symbol.length());
        this.SetState(1);
    }

    private String Literal(int braceLevel, String delimiter) throws ParseException, ParseException {
        StringBuilder sb = new StringBuilder(64);
        if (braceLevel < 0) {
            throw new IllegalArgumentException();
        }
        this.SetState(3);
        Token prevToken = null;
        Token token = this.getNextToken();
        while (true) {
            boolean escaped;
            if (token.kind == 0) {
                throw new ParseException("Reached unexpected EOF token");
            }
            boolean bl = escaped = prevToken != null && "\\".equals(prevToken.image);
            if (!escaped) {
                if ("{".equals(token.image)) {
                    ++braceLevel;
                } else if ("}".equals(token.image)) {
                    --braceLevel;
                }
            }
            if (delimiter.equals(token.image) && braceLevel == 0) break;
            sb.append(token.image);
            prevToken = token;
            token = this.getNextToken();
        }
        this.SetState(1);
        return StringUtil.removeIndent(sb.toString());
    }

    private void SetState(int state) throws ParseException {
        if (state != this.token_source.curLexState) {
            Token root;
            Token last = root = new Token();
            root.next = null;
            while (this.token.next != null) {
                Token t = this.token;
                while (t.next != null && t.next.next != null) {
                    t = t.next;
                }
                last.next = t.next;
                last = t.next;
                if (t.next.specialToken != null) {
                    Token tt = t.next.specialToken;
                    while (tt != null) {
                        last.next = tt;
                        last = tt;
                        tt.next = null;
                        tt = tt.specialToken;
                    }
                }
                t.next = null;
            }
            while (root.next != null) {
                this.token_source.backup(root.next.image.length());
                root.next = root.next.next;
            }
            this.jj_ntk = -1;
            this.token_source.SwitchTo(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    private boolean jj_3R_3() {
        return this.jj_3R_4();
    }

    private boolean jj_3_7() {
        if (this.jj_scan_token(12)) {
            return true;
        }
        return this.jj_3R_4();
    }

    private boolean jj_3_6() {
        if (this.jj_3R_3()) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private boolean jj_3_4() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_scan_token(23);
    }

    private boolean jj_3R_4() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(20)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(21)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(22)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(23)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(24)) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_3() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_scan_token(22);
    }

    private boolean jj_3_5() {
        if (this.jj_3R_3()) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private boolean jj_3_2() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_scan_token(21);
    }

    private boolean jj_3_1() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_scan_token(20);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{6144, 6144, 2048, 98304, 98304, 4096, 0x1F01000, 4096, 4096, 0x1F01000, 4096, 98304, 0x1F00000, 16384, 32669696};
    }

    public BibTeXParser(Provider stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new BibTeXParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 15; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public BibTeXParser(String dsl) throws ParseException, TokenMgrException {
        this(new StringProvider(dsl));
    }

    public void ReInit(String s) {
        this.ReInit(new StringProvider(s));
    }

    public void ReInit(Provider stream) {
        int i;
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new BibTeXParserTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 15; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public BibTeXParser(BibTeXParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 15; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(BibTeXParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 15; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[31];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 15; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 31; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage, this.token_source == null ? null : BibTeXParserTokenManager.lexStateNames[this.token_source.curLexState]);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 7; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        BibTeXParser.jj_la1_init_0();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends RuntimeException {
        private LookaheadSuccess() {
        }
    }

    private static class Field {
        private Key key = null;
        private Value value = null;

        private Field(Key key, Value value) {
            this.setKey(key);
            this.setValue(value);
        }

        public Key getKey() {
            return this.key;
        }

        private void setKey(Key key) {
            this.key = key;
        }

        public Value getValue() {
            return this.value;
        }

        private void setValue(Value value) {
            this.value = value;
        }
    }
}

