/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.shared.prefs;

import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.Optional;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import net.sf.jabref.JabRefMain;
import net.sf.jabref.shared.DBMSConnectionProperties;
import net.sf.jabref.shared.security.Password;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SharedDatabasePreferences {
    private static final Log LOGGER = LogFactory.getLog(SharedDatabasePreferences.class);
    private static final String DEFAULT_NODE = "default";
    private static final String PARENT_NODE = "jabref-shared";
    private static final String SHARED_DATABASE_TYPE = "sharedDatabaseType";
    private static final String SHARED_DATABASE_HOST = "sharedDatabaseHost";
    private static final String SHARED_DATABASE_PORT = "sharedDatabasePort";
    private static final String SHARED_DATABASE_NAME = "sharedDatabaseName";
    private static final String SHARED_DATABASE_USER = "sharedDatabaseUser";
    private static final String SHARED_DATABASE_PASSWORD = "sharedDatabasePassword";
    private static final String SHARED_DATABASE_REMEMBER_PASSWORD = "sharedDatabaseRememberPassword";
    private final Preferences internalPrefs;

    public SharedDatabasePreferences() {
        this(DEFAULT_NODE);
    }

    public SharedDatabasePreferences(String sharedDatabaseID) {
        this.internalPrefs = Preferences.userNodeForPackage(JabRefMain.class).parent().node(PARENT_NODE).node(sharedDatabaseID);
    }

    public Optional<String> getType() {
        return this.getOptionalValue(SHARED_DATABASE_TYPE);
    }

    public Optional<String> getHost() {
        return this.getOptionalValue(SHARED_DATABASE_HOST);
    }

    public Optional<String> getPort() {
        return this.getOptionalValue(SHARED_DATABASE_PORT);
    }

    public Optional<String> getName() {
        return this.getOptionalValue(SHARED_DATABASE_NAME);
    }

    public Optional<String> getUser() {
        return this.getOptionalValue(SHARED_DATABASE_USER);
    }

    public Optional<String> getPassword() {
        return this.getOptionalValue(SHARED_DATABASE_PASSWORD);
    }

    public boolean getRememberPassword() {
        return this.internalPrefs.getBoolean(SHARED_DATABASE_REMEMBER_PASSWORD, false);
    }

    public void setType(String type) {
        this.internalPrefs.put(SHARED_DATABASE_TYPE, type);
    }

    public void setHost(String host) {
        this.internalPrefs.put(SHARED_DATABASE_HOST, host);
    }

    public void setPort(String port) {
        this.internalPrefs.put(SHARED_DATABASE_PORT, port);
    }

    public void setName(String name) {
        this.internalPrefs.put(SHARED_DATABASE_NAME, name);
    }

    public void setUser(String user) {
        this.internalPrefs.put(SHARED_DATABASE_USER, user);
    }

    public void setPassword(String password) {
        this.internalPrefs.put(SHARED_DATABASE_PASSWORD, password);
    }

    public void setRememberPassword(boolean rememberPassword) {
        this.internalPrefs.putBoolean(SHARED_DATABASE_REMEMBER_PASSWORD, rememberPassword);
    }

    public void clearPassword() {
        this.internalPrefs.remove(SHARED_DATABASE_PASSWORD);
    }

    public void clear() throws BackingStoreException {
        this.internalPrefs.clear();
    }

    private Optional<String> getOptionalValue(String key) {
        return Optional.ofNullable(this.internalPrefs.get(key, null));
    }

    public static void clearAll() throws BackingStoreException {
        Preferences.userNodeForPackage(JabRefMain.class).parent().node(PARENT_NODE).clear();
    }

    public void putAllDBMSConnectionProperties(DBMSConnectionProperties properties) {
        assert (properties.isValid());
        this.setType(properties.getType().toString());
        this.setHost(properties.getHost());
        this.setPort(String.valueOf(properties.getPort()));
        this.setName(properties.getDatabase());
        this.setUser(properties.getUser());
        try {
            this.setPassword(new Password(properties.getPassword().toCharArray(), properties.getUser()).encrypt());
        }
        catch (UnsupportedEncodingException | GeneralSecurityException e) {
            LOGGER.error("Could not store the password due to encryption problems.", e);
        }
    }
}

