/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.shared;

import com.impossibl.postgres.api.jdbc.PGConnection;
import com.impossibl.postgres.jdbc.PGDataSource;
import com.impossibl.postgres.jdbc.ThreadedHousekeeper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.shared.DBMSConnection;
import net.sf.jabref.shared.DBMSProcessor;
import net.sf.jabref.shared.DBMSSynchronizer;
import net.sf.jabref.shared.listener.PostgresSQLNotificationListener;

public class PostgreSQLProcessor
extends DBMSProcessor {
    private PGConnection pgConnection;
    private PostgresSQLNotificationListener listener;

    public PostgreSQLProcessor(DBMSConnection connection) {
        super(connection);
    }

    @Override
    public void setUp() throws SQLException {
        this.connection.createStatement().executeUpdate("CREATE TABLE IF NOT EXISTS \"ENTRY\" (\"SHARED_ID\" SERIAL PRIMARY KEY, \"TYPE\" VARCHAR, \"VERSION\" INTEGER DEFAULT 1)");
        this.connection.createStatement().executeUpdate("CREATE TABLE IF NOT EXISTS \"FIELD\" (\"ENTRY_SHARED_ID\" INTEGER REFERENCES \"ENTRY\"(\"SHARED_ID\") ON DELETE CASCADE, \"NAME\" VARCHAR, \"VALUE\" TEXT)");
        this.connection.createStatement().executeUpdate("CREATE TABLE IF NOT EXISTS \"METADATA\" (\"KEY\" VARCHAR,\"VALUE\" TEXT)");
    }

    @Override
    protected void insertIntoEntryTable(BibEntry bibEntry) {
        StringBuilder insertIntoEntryQuery = new StringBuilder().append("INSERT INTO ").append(this.escape("ENTRY")).append("(").append(this.escape("TYPE")).append(") VALUES(?)");
        try (PreparedStatement preparedEntryStatement = this.connection.prepareStatement(insertIntoEntryQuery.toString(), 1);){
            preparedEntryStatement.setString(1, bibEntry.getType());
            preparedEntryStatement.executeUpdate();
            try (ResultSet generatedKeys = preparedEntryStatement.getGeneratedKeys();){
                if (generatedKeys.next()) {
                    bibEntry.getSharedBibEntryData().setSharedID(generatedKeys.getInt(1));
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("SQL Error: ", e);
        }
    }

    @Override
    String escape(String expression) {
        return "\"" + expression + "\"";
    }

    @Override
    public void startNotificationListener(DBMSSynchronizer dbmsSynchronizer) {
        Logger.getLogger(ThreadedHousekeeper.class.getName()).setLevel(Level.SEVERE);
        this.listener = new PostgresSQLNotificationListener(dbmsSynchronizer);
        PGDataSource dataSource = new PGDataSource();
        dataSource.setHost(this.connectionProperties.getHost());
        dataSource.setPort(this.connectionProperties.getPort());
        dataSource.setDatabase(this.connectionProperties.getDatabase());
        dataSource.setUser(this.connectionProperties.getUser());
        dataSource.setPassword(this.connectionProperties.getPassword());
        try {
            this.pgConnection = (PGConnection)dataSource.getConnection();
            this.pgConnection.createStatement().execute("LISTEN jabrefLiveUpdate");
            this.pgConnection.addNotificationListener(this.listener);
        }
        catch (SQLException e) {
            LOGGER.error("SQL Error: ", e);
        }
    }

    @Override
    public void stopNotificationListener() {
        try {
            this.pgConnection.close();
        }
        catch (SQLException e) {
            LOGGER.error("SQL Error: ", e);
        }
    }

    @Override
    public void notifyClients() {
        try {
            this.pgConnection.createStatement().execute("NOTIFY jabrefLiveUpdate, '" + PROCESSOR_ID + "';");
        }
        catch (SQLException e) {
            LOGGER.error("SQL Error: ", e);
        }
    }
}

