/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.shared;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import net.sf.jabref.shared.DBMSConnection;
import net.sf.jabref.shared.DBMSProcessor;
import net.sf.jabref.shared.DBMSSynchronizer;
import net.sf.jabref.shared.listener.OracleNotificationListener;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleStatement;
import oracle.jdbc.dcn.DatabaseChangeRegistration;

public class OracleProcessor
extends DBMSProcessor {
    private OracleConnection oracleConnection;
    private OracleNotificationListener listener;
    private DatabaseChangeRegistration databaseChangeRegistration;

    public OracleProcessor(DBMSConnection connection) {
        super(connection);
    }

    @Override
    public void setUp() throws SQLException {
        this.connection.createStatement().executeUpdate("CREATE TABLE \"ENTRY\" (\"SHARED_ID\" NUMBER NOT NULL, \"TYPE\" VARCHAR2(255) NULL, \"VERSION\" NUMBER DEFAULT 1, CONSTRAINT \"ENTRY_PK\" PRIMARY KEY (\"SHARED_ID\"))");
        this.connection.createStatement().executeUpdate("CREATE SEQUENCE \"ENTRY_SEQ\"");
        this.connection.createStatement().executeUpdate("CREATE TRIGGER \"ENTRY_T\" BEFORE INSERT ON \"ENTRY\" FOR EACH ROW BEGIN SELECT \"ENTRY_SEQ\".NEXTVAL INTO :NEW.shared_id FROM DUAL; END;");
        this.connection.createStatement().executeUpdate("CREATE TABLE \"FIELD\" (\"ENTRY_SHARED_ID\" NUMBER NOT NULL, \"NAME\" VARCHAR2(255) NOT NULL, \"VALUE\" CLOB NULL, CONSTRAINT \"ENTRY_SHARED_ID_FK\" FOREIGN KEY (\"ENTRY_SHARED_ID\") REFERENCES \"ENTRY\"(\"SHARED_ID\") ON DELETE CASCADE)");
        this.connection.createStatement().executeUpdate("CREATE TABLE \"METADATA\" (\"KEY\"  VARCHAR2(255) NULL,\"VALUE\"  CLOB NOT NULL)");
    }

    @Override
    String escape(String expression) {
        return "\"" + expression + "\"";
    }

    @Override
    public void startNotificationListener(DBMSSynchronizer dbmsSynchronizer) {
        this.listener = new OracleNotificationListener(dbmsSynchronizer);
        try {
            this.oracleConnection = (OracleConnection)this.connection;
            Properties properties = new Properties();
            properties.setProperty(OracleConnection.DCN_NOTIFY_ROWIDS, "true");
            properties.setProperty(OracleConnection.DCN_QUERY_CHANGE_NOTIFICATION, "true");
            this.databaseChangeRegistration = this.oracleConnection.registerDatabaseChangeNotification(properties);
            this.databaseChangeRegistration.addListener(this.listener);
            try (Statement statement = this.oracleConnection.createStatement();){
                ((OracleStatement)((Object)statement)).setDatabaseChangeRegistration(this.databaseChangeRegistration);
                StringBuilder selectQuery = new StringBuilder().append("SELECT 1 FROM ").append(this.escape("ENTRY")).append(", ").append(this.escape("METADATA"));
                statement.executeQuery(selectQuery.toString());
            }
        }
        catch (SQLException e) {
            LOGGER.error("SQL Error: ", e);
        }
    }

    @Override
    public void stopNotificationListener() {
        try {
            this.oracleConnection.unregisterDatabaseChangeNotification(this.databaseChangeRegistration);
            this.oracleConnection.close();
        }
        catch (SQLException e) {
            LOGGER.error("SQL Error: ", e);
        }
    }

    @Override
    public void notifyClients() {
    }
}

