/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.shared;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.event.EntryEventSource;
import net.sf.jabref.shared.DBMSConnection;
import net.sf.jabref.shared.DBMSConnectionProperties;
import net.sf.jabref.shared.DBMSSynchronizer;
import net.sf.jabref.shared.DBMSType;
import net.sf.jabref.shared.MySQLProcessor;
import net.sf.jabref.shared.OracleProcessor;
import net.sf.jabref.shared.PostgreSQLProcessor;
import net.sf.jabref.shared.exception.OfflineLockException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DBMSProcessor {
    protected static final Log LOGGER = LogFactory.getLog(DBMSProcessor.class);
    protected final Connection connection;
    protected DBMSConnectionProperties connectionProperties;
    public static final String PROCESSOR_ID = UUID.randomUUID().toString();

    protected DBMSProcessor(DBMSConnection dbmsConnection) {
        this.connection = dbmsConnection.getConnection();
        this.connectionProperties = dbmsConnection.getProperties();
    }

    public boolean checkBaseIntegrity() throws SQLException {
        return this.checkTableAvailibility("ENTRY", "FIELD", "METADATA");
    }

    public boolean checkForPre3Dot6Intergrity() throws SQLException {
        return this.checkTableAvailibility("ENTRIES", "ENTRY_GROUP", "ENTRY_TYPES", "GROUPS", "GROUP_TYPES", "JABREF_DATABASE", "STRINGS");
    }

    private boolean checkTableAvailibility(String ... tableNames) throws SQLException {
        ArrayList<String> requiredTables = new ArrayList<String>();
        for (String name : tableNames) {
            requiredTables.add(name.toUpperCase(Locale.ENGLISH));
        }
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        try (ResultSet databaseMetaDataResultSet = databaseMetaData.getTables(null, null, null, null);){
            while (databaseMetaDataResultSet.next()) {
                String tableName = databaseMetaDataResultSet.getString("TABLE_NAME").toUpperCase();
                requiredTables.remove(tableName);
            }
            boolean bl = requiredTables.isEmpty();
            return bl;
        }
    }

    public void setupSharedDatabase() throws SQLException {
        this.setUp();
        if (!this.checkBaseIntegrity()) {
            LOGGER.error("Corrupt_shared_database_structure.");
        }
    }

    protected abstract void setUp() throws SQLException;

    abstract String escape(String var1);

    public void insertEntry(BibEntry bibEntry) {
        if (!this.checkForBibEntryExistence(bibEntry)) {
            this.insertIntoEntryTable(bibEntry);
            this.insertIntoFieldTable(bibEntry);
        }
    }

    protected void insertIntoEntryTable(BibEntry bibEntry) {
        StringBuilder insertIntoEntryQuery = new StringBuilder().append("INSERT INTO ").append(this.escape("ENTRY")).append("(").append(this.escape("TYPE")).append(") VALUES(?)");
        try (PreparedStatement preparedEntryStatement = this.connection.prepareStatement(insertIntoEntryQuery.toString(), new String[]{"SHARED_ID"});){
            preparedEntryStatement.setString(1, bibEntry.getType());
            preparedEntryStatement.executeUpdate();
            try (ResultSet generatedKeys = preparedEntryStatement.getGeneratedKeys();){
                if (generatedKeys.next()) {
                    bibEntry.getSharedBibEntryData().setSharedID(generatedKeys.getInt(1));
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("SQL Error: ", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkForBibEntryExistence(BibEntry bibEntry) {
        try {
            int sharedID = bibEntry.getSharedBibEntryData().getSharedID();
            if (sharedID == -1) return false;
            StringBuilder selectQuery = new StringBuilder().append("SELECT * FROM ").append(this.escape("ENTRY")).append(" WHERE ").append(this.escape("SHARED_ID")).append(" = ?");
            try (PreparedStatement preparedSelectStatement = this.connection.prepareStatement(selectQuery.toString());){
                preparedSelectStatement.setInt(1, sharedID);
                try (ResultSet resultSet = preparedSelectStatement.executeQuery();){
                    if (!resultSet.next()) return false;
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("SQL Error: ", e);
        }
        return false;
    }

    private void insertIntoFieldTable(BibEntry bibEntry) {
        try {
            for (String fieldName : bibEntry.getFieldNames()) {
                StringBuilder insertFieldQuery = new StringBuilder().append("INSERT INTO ").append(this.escape("FIELD")).append("(").append(this.escape("ENTRY_SHARED_ID")).append(", ").append(this.escape("NAME")).append(", ").append(this.escape("VALUE")).append(") VALUES(?, ?, ?)");
                PreparedStatement preparedFieldStatement = this.connection.prepareStatement(insertFieldQuery.toString());
                Throwable throwable = null;
                try {
                    preparedFieldStatement.setInt(1, bibEntry.getSharedBibEntryData().getSharedID());
                    preparedFieldStatement.setString(2, fieldName);
                    preparedFieldStatement.setString(3, bibEntry.getField(fieldName).get());
                    preparedFieldStatement.executeUpdate();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (preparedFieldStatement == null) continue;
                    if (throwable != null) {
                        try {
                            preparedFieldStatement.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    preparedFieldStatement.close();
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("SQL Error: ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEntry(BibEntry localBibEntry) throws OfflineLockException, SQLException {
        block21: {
            this.connection.setAutoCommit(false);
            try {
                Optional<BibEntry> sharedEntryOptional = this.getSharedEntry(localBibEntry.getSharedBibEntryData().getSharedID());
                if (!sharedEntryOptional.isPresent()) {
                    return;
                }
                BibEntry sharedBibEntry = sharedEntryOptional.get();
                this.removeSharedFieldsByDifference(localBibEntry, sharedBibEntry);
                if (localBibEntry.getSharedBibEntryData().getVersion() >= sharedBibEntry.getSharedBibEntryData().getVersion() || localBibEntry.equals(sharedBibEntry)) {
                    this.insertOrUpdateFields(localBibEntry);
                    StringBuilder updateEntryTypeQuery = new StringBuilder().append("UPDATE ").append(this.escape("ENTRY")).append(" SET ").append(this.escape("TYPE")).append(" = ?, ").append(this.escape("VERSION")).append(" = ").append(this.escape("VERSION")).append(" + 1 WHERE ").append(this.escape("SHARED_ID")).append(" = ?");
                    try (PreparedStatement preparedUpdateEntryTypeStatement = this.connection.prepareStatement(updateEntryTypeQuery.toString());){
                        preparedUpdateEntryTypeStatement.setString(1, localBibEntry.getType());
                        preparedUpdateEntryTypeStatement.setInt(2, localBibEntry.getSharedBibEntryData().getSharedID());
                        preparedUpdateEntryTypeStatement.executeUpdate();
                    }
                    this.connection.commit();
                    break block21;
                }
                throw new OfflineLockException(localBibEntry, sharedBibEntry);
            }
            catch (SQLException e) {
                LOGGER.error("SQL Error: ", e);
                this.connection.rollback();
            }
            finally {
                this.connection.setAutoCommit(true);
            }
        }
    }

    private void removeSharedFieldsByDifference(BibEntry localBibEntry, BibEntry sharedBibEntry) throws SQLException {
        HashSet<String> nullFields = new HashSet<String>(sharedBibEntry.getFieldNames());
        nullFields.removeAll(localBibEntry.getFieldNames());
        for (String nullField : nullFields) {
            StringBuilder deleteFieldQuery = new StringBuilder().append("DELETE FROM ").append(this.escape("FIELD")).append(" WHERE ").append(this.escape("NAME")).append(" = ? AND ").append(this.escape("ENTRY_SHARED_ID")).append(" = ?");
            PreparedStatement preparedDeleteFieldStatement = this.connection.prepareStatement(deleteFieldQuery.toString());
            Throwable throwable = null;
            try {
                preparedDeleteFieldStatement.setString(1, nullField);
                preparedDeleteFieldStatement.setInt(2, localBibEntry.getSharedBibEntryData().getSharedID());
                preparedDeleteFieldStatement.executeUpdate();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (preparedDeleteFieldStatement == null) continue;
                if (throwable != null) {
                    try {
                        preparedDeleteFieldStatement.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                preparedDeleteFieldStatement.close();
            }
        }
    }

    private void insertOrUpdateFields(BibEntry localBibEntry) throws SQLException {
        for (String fieldName : localBibEntry.getFieldNames()) {
            Optional<String> valueOptional = localBibEntry.getField(fieldName);
            String value = null;
            if (valueOptional.isPresent()) {
                value = valueOptional.get();
            }
            StringBuilder selectFieldQuery = new StringBuilder().append("SELECT * FROM ").append(this.escape("FIELD")).append(" WHERE ").append(this.escape("NAME")).append(" = ? AND ").append(this.escape("ENTRY_SHARED_ID")).append(" = ?");
            PreparedStatement preparedSelectFieldStatement = this.connection.prepareStatement(selectFieldQuery.toString());
            Throwable throwable = null;
            try {
                preparedSelectFieldStatement.setString(1, fieldName);
                preparedSelectFieldStatement.setInt(2, localBibEntry.getSharedBibEntryData().getSharedID());
                ResultSet selectFieldResultSet = preparedSelectFieldStatement.executeQuery();
                Throwable throwable2 = null;
                try {
                    Throwable throwable3;
                    if (selectFieldResultSet.next()) {
                        StringBuilder updateFieldQuery = new StringBuilder().append("UPDATE ").append(this.escape("FIELD")).append(" SET ").append(this.escape("VALUE")).append(" = ? WHERE ").append(this.escape("NAME")).append(" = ? AND ").append(this.escape("ENTRY_SHARED_ID")).append(" = ?");
                        PreparedStatement preparedUpdateFieldStatement = this.connection.prepareStatement(updateFieldQuery.toString());
                        throwable3 = null;
                        try {
                            preparedUpdateFieldStatement.setString(1, value);
                            preparedUpdateFieldStatement.setString(2, fieldName);
                            preparedUpdateFieldStatement.setInt(3, localBibEntry.getSharedBibEntryData().getSharedID());
                            preparedUpdateFieldStatement.executeUpdate();
                            continue;
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (preparedUpdateFieldStatement == null) continue;
                            if (throwable3 != null) {
                                try {
                                    preparedUpdateFieldStatement.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable3.addSuppressed(throwable5);
                                }
                                continue;
                            }
                            preparedUpdateFieldStatement.close();
                            continue;
                        }
                    }
                    StringBuilder insertFieldQuery = new StringBuilder().append("INSERT INTO ").append(this.escape("FIELD")).append("(").append(this.escape("ENTRY_SHARED_ID")).append(", ").append(this.escape("NAME")).append(", ").append(this.escape("VALUE")).append(") VALUES(?, ?, ?)");
                    PreparedStatement preparedFieldStatement = this.connection.prepareStatement(insertFieldQuery.toString());
                    throwable3 = null;
                    try {
                        preparedFieldStatement.setInt(1, localBibEntry.getSharedBibEntryData().getSharedID());
                        preparedFieldStatement.setString(2, fieldName);
                        preparedFieldStatement.setString(3, value);
                        preparedFieldStatement.executeUpdate();
                    }
                    catch (Throwable throwable6) {
                        throwable3 = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (preparedFieldStatement == null) continue;
                        if (throwable3 != null) {
                            try {
                                preparedFieldStatement.close();
                            }
                            catch (Throwable throwable7) {
                                throwable3.addSuppressed(throwable7);
                            }
                            continue;
                        }
                        preparedFieldStatement.close();
                    }
                }
                catch (Throwable throwable8) {
                    throwable2 = throwable8;
                    throw throwable8;
                }
                finally {
                    if (selectFieldResultSet == null) continue;
                    if (throwable2 != null) {
                        try {
                            selectFieldResultSet.close();
                        }
                        catch (Throwable throwable9) {
                            throwable2.addSuppressed(throwable9);
                        }
                        continue;
                    }
                    selectFieldResultSet.close();
                }
            }
            catch (Throwable throwable10) {
                throwable = throwable10;
                throw throwable10;
            }
            finally {
                if (preparedSelectFieldStatement == null) continue;
                if (throwable != null) {
                    try {
                        preparedSelectFieldStatement.close();
                    }
                    catch (Throwable throwable11) {
                        throwable.addSuppressed(throwable11);
                    }
                    continue;
                }
                preparedSelectFieldStatement.close();
            }
        }
    }

    public void removeEntry(BibEntry bibEntry) {
        StringBuilder query = new StringBuilder().append("DELETE FROM ").append(this.escape("ENTRY")).append(" WHERE ").append(this.escape("SHARED_ID")).append(" = ?");
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(query.toString());){
            preparedStatement.setInt(1, bibEntry.getSharedBibEntryData().getSharedID());
            preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            LOGGER.error("SQL Error: ", e);
        }
    }

    public Optional<BibEntry> getSharedEntry(int sharedID) {
        List<BibEntry> sharedEntries = this.getSharedEntryList(sharedID);
        if (!sharedEntries.isEmpty()) {
            return Optional.of(sharedEntries.get(0));
        }
        return Optional.empty();
    }

    public List<BibEntry> getSharedEntries() {
        return this.getSharedEntryList(0);
    }

    private List<BibEntry> getSharedEntryList(int sharedID) {
        ArrayList<BibEntry> sharedEntries = new ArrayList<BibEntry>();
        StringBuilder selectEntryQuery = new StringBuilder();
        selectEntryQuery.append("SELECT * FROM ");
        selectEntryQuery.append(this.escape("ENTRY"));
        if (sharedID != 0) {
            selectEntryQuery.append(" WHERE ");
            selectEntryQuery.append(this.escape("SHARED_ID"));
            selectEntryQuery.append(" = ");
            selectEntryQuery.append(sharedID);
        }
        selectEntryQuery.append(" ORDER BY ");
        selectEntryQuery.append(this.escape("SHARED_ID"));
        try (ResultSet selectEntryResultSet = this.connection.createStatement().executeQuery(selectEntryQuery.toString());){
            while (selectEntryResultSet.next()) {
                BibEntry bibEntry = new BibEntry();
                bibEntry.getSharedBibEntryData().setSharedID(selectEntryResultSet.getInt("SHARED_ID"));
                bibEntry.setType(selectEntryResultSet.getString("TYPE"));
                bibEntry.getSharedBibEntryData().setVersion(selectEntryResultSet.getInt("VERSION"));
                StringBuilder selectFieldQuery = new StringBuilder().append("SELECT * FROM ").append(this.escape("FIELD")).append(" WHERE ").append(this.escape("ENTRY_SHARED_ID")).append(" = ?");
                try (PreparedStatement preparedSelectFieldStatement = this.connection.prepareStatement(selectFieldQuery.toString());){
                    preparedSelectFieldStatement.setInt(1, selectEntryResultSet.getInt("SHARED_ID"));
                    try (ResultSet selectFieldResultSet = preparedSelectFieldStatement.executeQuery();){
                        while (selectFieldResultSet.next()) {
                            bibEntry.setField(selectFieldResultSet.getString("NAME"), Optional.ofNullable(selectFieldResultSet.getString("VALUE")), EntryEventSource.SHARED);
                        }
                    }
                }
                sharedEntries.add(bibEntry);
            }
        }
        catch (SQLException e) {
            LOGGER.error("SQL Error", e);
        }
        return sharedEntries;
    }

    public Map<Integer, Integer> getSharedIDVersionMapping() {
        HashMap<Integer, Integer> sharedIDVersionMapping = new HashMap<Integer, Integer>();
        StringBuilder selectEntryQuery = new StringBuilder().append("SELECT * FROM ").append(this.escape("ENTRY")).append(" ORDER BY ").append(this.escape("SHARED_ID"));
        try (ResultSet selectEntryResultSet = this.connection.createStatement().executeQuery(selectEntryQuery.toString());){
            while (selectEntryResultSet.next()) {
                sharedIDVersionMapping.put(selectEntryResultSet.getInt("SHARED_ID"), selectEntryResultSet.getInt("VERSION"));
            }
        }
        catch (SQLException e) {
            LOGGER.error("SQL Error", e);
        }
        return sharedIDVersionMapping;
    }

    public Map<String, String> getSharedMetaData() {
        HashMap<String, String> data = new HashMap<String, String>();
        try (ResultSet resultSet = this.connection.createStatement().executeQuery("SELECT * FROM " + this.escape("METADATA"));){
            while (resultSet.next()) {
                data.put(resultSet.getString("KEY"), resultSet.getString("VALUE"));
            }
        }
        catch (SQLException e) {
            LOGGER.error("SQL Error", e);
        }
        return data;
    }

    public void setSharedMetaData(Map<String, String> data) throws SQLException {
        this.connection.createStatement().executeUpdate("TRUNCATE TABLE " + this.escape("METADATA"));
        for (Map.Entry<String, String> metaEntry : data.entrySet()) {
            StringBuilder query = new StringBuilder().append("INSERT INTO ").append(this.escape("METADATA")).append("(").append(this.escape("KEY")).append(", ").append(this.escape("VALUE")).append(") VALUES(?, ?)");
            try {
                PreparedStatement preparedStatement = this.connection.prepareStatement(query.toString());
                Throwable throwable = null;
                try {
                    preparedStatement.setString(1, metaEntry.getKey());
                    preparedStatement.setString(2, metaEntry.getValue());
                    preparedStatement.executeUpdate();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (preparedStatement == null) continue;
                    if (throwable != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    preparedStatement.close();
                }
            }
            catch (SQLException e) {
                LOGGER.error("SQL Error: ", e);
            }
        }
    }

    public static DBMSProcessor getProcessorInstance(DBMSConnection connection) {
        DBMSType type = connection.getProperties().getType();
        if (type == DBMSType.MYSQL) {
            return new MySQLProcessor(connection);
        }
        if (type == DBMSType.POSTGRESQL) {
            return new PostgreSQLProcessor(connection);
        }
        if (type == DBMSType.ORACLE) {
            return new OracleProcessor(connection);
        }
        return null;
    }

    public DBMSConnectionProperties getDBMSConnectionProperties() {
        return this.connectionProperties;
    }

    public void startNotificationListener(DBMSSynchronizer dbmsSynchronizer) {
    }

    public void stopNotificationListener() {
    }

    public void notifyClients() {
    }
}

