/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.shared;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.shared.DBMSConnectionProperties;
import net.sf.jabref.shared.DBMSType;
import net.sf.jabref.shared.exception.InvalidDBMSConnectionPropertiesException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DBMSConnection {
    private static final Log LOGGER = LogFactory.getLog(DBMSConnection.class);
    private final Connection connection;
    private final DBMSConnectionProperties properties;

    public DBMSConnection(DBMSConnectionProperties properties) throws SQLException, InvalidDBMSConnectionPropertiesException {
        if (!properties.isValid()) {
            throw new InvalidDBMSConnectionPropertiesException();
        }
        this.properties = properties;
        try {
            DriverManager.setLoginTimeout(3);
            this.connection = DriverManager.getConnection(properties.getType().getUrl(properties.getHost(), properties.getPort(), properties.getDatabase()), properties.getUser(), properties.getPassword());
        }
        catch (SQLException e) {
            LOGGER.error("Could not connect to database: " + e.getMessage() + " - Error code: " + e.getErrorCode());
            throw e;
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public DBMSConnectionProperties getProperties() {
        return this.properties;
    }

    public static Set<DBMSType> getAvailableDBMSTypes() {
        HashSet<DBMSType> dbmsTypes = new HashSet<DBMSType>();
        for (DBMSType dbms : DBMSType.values()) {
            try {
                Class.forName(dbms.getDriverClassPath());
                dbmsTypes.add(dbms);
            }
            catch (ClassNotFoundException e) {
                LOGGER.info(Localization.lang("%0 driver not available.", dbms.toString()));
            }
        }
        return dbmsTypes;
    }
}

