/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.preferences;

import java.util.List;

public class PreviewPreferences {
    private final List<String> previewCycle;
    private final int previewCyclePosition;
    private final int previewPanelHeight;
    private final boolean previewPanelEnabled;
    private final String previewStyle;
    private final String previewStyleDefault;

    public PreviewPreferences(List<String> previewCycle, int previeCyclePosition, int previewPanelHeight, boolean previewPanelEnabled, String previewStyle, String previewStyleDefault) {
        this.previewCycle = previewCycle;
        this.previewCyclePosition = previeCyclePosition;
        this.previewPanelHeight = previewPanelHeight;
        this.previewPanelEnabled = previewPanelEnabled;
        this.previewStyle = previewStyle;
        this.previewStyleDefault = previewStyleDefault;
    }

    public List<String> getPreviewCycle() {
        return this.previewCycle;
    }

    public int getPreviewCyclePosition() {
        return this.previewCyclePosition;
    }

    public int getPreviewPanelHeight() {
        return this.previewPanelHeight;
    }

    public boolean isPreviewPanelEnabled() {
        return this.previewPanelEnabled;
    }

    public String getPreviewStyle() {
        return this.previewStyle;
    }

    public String getPreviewStyleDefault() {
        return this.previewStyleDefault;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private List<String> previewCycle;
        private int previeCyclePosition;
        private int previewPanelHeight;
        private boolean previewPanelEnabled;
        private String previewStyle;
        private final String previewStyleDefault;

        public Builder(PreviewPreferences previewPreferences) {
            this.previewCycle = previewPreferences.getPreviewCycle();
            this.previeCyclePosition = previewPreferences.getPreviewCyclePosition();
            this.previewPanelHeight = previewPreferences.getPreviewPanelHeight();
            this.previewPanelEnabled = previewPreferences.isPreviewPanelEnabled();
            this.previewStyle = previewPreferences.getPreviewStyle();
            this.previewStyleDefault = previewPreferences.getPreviewStyleDefault();
        }

        public Builder withPreviewCycle(List<String> previewCycle) {
            this.previewCycle = previewCycle;
            return this.withPreviewCyclePosition(this.previeCyclePosition);
        }

        public Builder withPreviewCyclePosition(int position) {
            this.previeCyclePosition = position;
            while (this.previeCyclePosition < 0) {
                this.previeCyclePosition += this.previewCycle.size();
            }
            this.previeCyclePosition %= this.previewCycle.size();
            return this;
        }

        public Builder withPreviewPanelHeight(int previewPanelHeight) {
            this.previewPanelHeight = previewPanelHeight;
            return this;
        }

        public Builder withPreviewPanelEnabled(boolean previewPanelEnabled) {
            this.previewPanelEnabled = previewPanelEnabled;
            return this;
        }

        public Builder withPreviewStyle(String previewStyle) {
            this.previewStyle = previewStyle;
            return this;
        }

        public PreviewPreferences build() {
            return new PreviewPreferences(this.previewCycle, this.previeCyclePosition, this.previewPanelHeight, this.previewPanelEnabled, this.previewStyle, this.previewStyleDefault);
        }
    }
}

