/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.preferences;

import java.io.File;
import java.util.Objects;
import net.sf.jabref.preferences.JabRefPreferences;

public class LastFocusedTabPreferences {
    private final JabRefPreferences preferences;

    public LastFocusedTabPreferences(JabRefPreferences preferences) {
        this.preferences = Objects.requireNonNull(preferences);
    }

    public void setLastFocusedTab(File file) {
        if (file == null) {
            return;
        }
        String filePath = file.getAbsolutePath();
        this.preferences.put("lastFocused", filePath);
    }

    public boolean hadLastFocus(File file) {
        if (file == null) {
            return false;
        }
        String lastFocusedDatabase = this.preferences.get("lastFocused");
        return file.getAbsolutePath().equals(lastFocusedDatabase);
    }
}

