/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.preferences;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.sf.jabref.preferences.JabRefPreferences;

public class JabRefPreferencesFilter {
    private final JabRefPreferences preferences;

    public JabRefPreferencesFilter(JabRefPreferences preferences) {
        this.preferences = preferences;
    }

    public List<PreferenceOption> getPreferenceOptions() {
        HashMap<String, Object> defaults = new HashMap<String, Object>(this.preferences.defaults);
        Map<String, Object> prefs = this.preferences.getPreferences();
        return prefs.entrySet().stream().map(entry -> new PreferenceOption((String)entry.getKey(), entry.getValue(), defaults.get(entry.getKey()))).collect(Collectors.toList());
    }

    public List<PreferenceOption> getDeviatingPreferences() {
        return this.getPreferenceOptions().stream().filter(PreferenceOption::isChanged).sorted().collect(Collectors.toList());
    }

    public static class PreferenceOption
    implements Comparable<PreferenceOption> {
        private final String key;
        private final Object value;
        private final Optional<Object> defaultValue;
        private final PreferenceType type;

        public PreferenceOption(String key, Object value, Object defaultValue) {
            this.key = Objects.requireNonNull(key);
            this.value = Objects.requireNonNull(value);
            this.defaultValue = Optional.ofNullable(defaultValue);
            this.type = Objects.requireNonNull(this.getType(value));
            if (defaultValue != null && !Objects.equals((Object)this.type, (Object)this.getType(defaultValue))) {
                throw new IllegalStateException("types must match between default value and value");
            }
        }

        private PreferenceType getType(Object value) {
            if (value instanceof Boolean) {
                return PreferenceType.BOOLEAN;
            }
            if (value instanceof Integer) {
                return PreferenceType.INTEGER;
            }
            return PreferenceType.STRING;
        }

        public boolean isUnchanged() {
            return Objects.equals(this.value, this.defaultValue.orElse(null));
        }

        public boolean isChanged() {
            return !this.isUnchanged();
        }

        public String toString() {
            return String.format("%s: %s=%s (%s)", new Object[]{this.type, this.key, this.value, this.defaultValue.orElse("NULL")});
        }

        public String getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Optional<Object> getDefaultValue() {
            return this.defaultValue;
        }

        public PreferenceType getType() {
            return this.type;
        }

        @Override
        public int compareTo(PreferenceOption o) {
            return Objects.compare(this.key, o.key, String::compareTo);
        }
    }

    public static enum PreferenceType {
        BOOLEAN,
        INTEGER,
        STRING;

    }
}

