/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.preferences;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javax.swing.UIManager;
import net.sf.jabref.JabRefException;
import net.sf.jabref.JabRefMain;
import net.sf.jabref.gui.desktop.JabRefDesktop;
import net.sf.jabref.gui.entryeditor.EntryEditorTabList;
import net.sf.jabref.gui.preftabs.ImportSettingsTab;
import net.sf.jabref.logic.autocompleter.AutoCompletePreferences;
import net.sf.jabref.logic.bibtex.FieldContentParserPreferences;
import net.sf.jabref.logic.bibtex.LatexFieldFormatterPreferences;
import net.sf.jabref.logic.bibtexkeypattern.BibtexKeyPatternPreferences;
import net.sf.jabref.logic.cleanup.CleanupPreferences;
import net.sf.jabref.logic.cleanup.CleanupPreset;
import net.sf.jabref.logic.cleanup.Cleanups;
import net.sf.jabref.logic.exporter.CustomExportList;
import net.sf.jabref.logic.exporter.ExportComparator;
import net.sf.jabref.logic.importer.ImportFormatPreferences;
import net.sf.jabref.logic.journals.JournalAbbreviationLoader;
import net.sf.jabref.logic.journals.JournalAbbreviationPreferences;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.layout.LayoutFormatterPreferences;
import net.sf.jabref.logic.layout.format.FileLinkPreferences;
import net.sf.jabref.logic.layout.format.NameFormatterPreferences;
import net.sf.jabref.logic.net.ProxyPreferences;
import net.sf.jabref.logic.protectedterms.ProtectedTermsList;
import net.sf.jabref.logic.protectedterms.ProtectedTermsLoader;
import net.sf.jabref.logic.protectedterms.ProtectedTermsPreferences;
import net.sf.jabref.logic.remote.RemotePreferences;
import net.sf.jabref.logic.util.OS;
import net.sf.jabref.logic.util.UpdateFieldPreferences;
import net.sf.jabref.logic.util.Version;
import net.sf.jabref.logic.util.io.FileHistory;
import net.sf.jabref.logic.xmp.XMPPreferences;
import net.sf.jabref.model.bibtexkeypattern.AbstractBibtexKeyPattern;
import net.sf.jabref.model.bibtexkeypattern.GlobalBibtexKeyPattern;
import net.sf.jabref.model.database.BibDatabaseMode;
import net.sf.jabref.model.entry.CustomEntryType;
import net.sf.jabref.model.metadata.FileDirectoryPreferences;
import net.sf.jabref.model.metadata.SaveOrderConfig;
import net.sf.jabref.model.strings.StringUtil;
import net.sf.jabref.preferences.CustomImportList;
import net.sf.jabref.preferences.PreviewPreferences;
import net.sf.jabref.preferences.SearchPreferences;
import net.sf.jabref.preferences.VersionPreferences;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JabRefPreferences {
    private static final Log LOGGER = LogFactory.getLog(JabRefPreferences.class);
    public final Map<String, Object> defaults = new HashMap<String, Object>();
    public static final String EMACS_PATH = "emacsPath";
    public static final String EMACS_ADDITIONAL_PARAMETERS = "emacsParameters";
    public static final String EMACS_23 = "emacsUseV23InsertString";
    public static final String LATEX_EDITOR_PATH = "latexEditorPath";
    public static final String TEXSTUDIO_PATH = "TeXstudioPath";
    public static final String WIN_EDT_PATH = "winEdtPath";
    public static final String TEXMAKER_PATH = "texmakerPath";
    public static final String VIM_SERVER = "vimServer";
    public static final String VIM = "vim";
    public static final String LYXPIPE = "lyxpipe";
    public static final String EXTERNAL_FILE_TYPES = "externalFileTypes";
    public static final String FONT_FAMILY = "fontFamily";
    public static final String WIN_LOOK_AND_FEEL = "lookAndFeel";
    public static final String LANGUAGE = "language";
    public static final String NAMES_LAST_ONLY = "namesLastOnly";
    public static final String ABBR_AUTHOR_NAMES = "abbrAuthorNames";
    public static final String NAMES_NATBIB = "namesNatbib";
    public static final String NAMES_FIRST_LAST = "namesFf";
    public static final String BIBLATEX_DEFAULT_MODE = "biblatexMode";
    public static final String NAMES_AS_IS = "namesAsIs";
    public static final String ENTRY_EDITOR_HEIGHT = "entryEditorHeight";
    public static final String AUTO_RESIZE_MODE = "autoResizeMode";
    public static final String WINDOW_MAXIMISED = "windowMaximised";
    public static final String USE_DEFAULT_LOOK_AND_FEEL = "useDefaultLookAndFeel";
    public static final String PROXY_PORT = "proxyPort";
    public static final String PROXY_HOSTNAME = "proxyHostname";
    public static final String PROXY_USE = "useProxy";
    public static final String PROXY_USERNAME = "proxyUsername";
    public static final String PROXY_PASSWORD = "proxyPassword";
    public static final String PROXY_USE_AUTHENTICATION = "useProxyAuthentication";
    public static final String TABLE_PRIMARY_SORT_FIELD = "priSort";
    public static final String TABLE_PRIMARY_SORT_DESCENDING = "priDescending";
    public static final String TABLE_SECONDARY_SORT_FIELD = "secSort";
    public static final String TABLE_SECONDARY_SORT_DESCENDING = "secDescending";
    public static final String TABLE_TERTIARY_SORT_FIELD = "terSort";
    public static final String TABLE_TERTIARY_SORT_DESCENDING = "terDescending";
    public static final String REFORMAT_FILE_ON_SAVE_AND_EXPORT = "reformatFileOnSaveAndExport";
    public static final String EXPORT_IN_ORIGINAL_ORDER = "exportInOriginalOrder";
    public static final String EXPORT_IN_SPECIFIED_ORDER = "exportInSpecifiedOrder";
    public static final String EXPORT_PRIMARY_SORT_FIELD = "exportPriSort";
    public static final String EXPORT_PRIMARY_SORT_DESCENDING = "exportPriDescending";
    public static final String EXPORT_SECONDARY_SORT_FIELD = "exportSecSort";
    public static final String EXPORT_SECONDARY_SORT_DESCENDING = "exportSecDescending";
    public static final String EXPORT_TERTIARY_SORT_FIELD = "exportTerSort";
    public static final String EXPORT_TERTIARY_SORT_DESCENDING = "exportTerDescending";
    public static final String NEWLINE = "newline";
    public static final String COLUMN_WIDTHS = "columnWidths";
    public static final String COLUMN_NAMES = "columnNames";
    public static final String SIDE_PANE_COMPONENT_PREFERRED_POSITIONS = "sidePaneComponentPreferredPositions";
    public static final String SIDE_PANE_COMPONENT_NAMES = "sidePaneComponentNames";
    public static final String XMP_PRIVACY_FILTERS = "xmpPrivacyFilters";
    public static final String USE_XMP_PRIVACY_FILTER = "useXmpPrivacyFilter";
    public static final String DEFAULT_AUTO_SORT = "defaultAutoSort";
    public static final String DEFAULT_SHOW_SOURCE = "defaultShowSource";
    public static final String SIZE_Y = "mainWindowSizeY";
    public static final String SIZE_X = "mainWindowSizeX";
    public static final String POS_Y = "mainWindowPosY";
    public static final String POS_X = "mainWindowPosX";
    public static final String STRINGS_SIZE_Y = "stringsSizeY";
    public static final String STRINGS_SIZE_X = "stringsSizeX";
    public static final String STRINGS_POS_Y = "stringsPosY";
    public static final String STRINGS_POS_X = "stringsPosX";
    public static final String DUPLICATES_SIZE_Y = "duplicatesSizeY";
    public static final String DUPLICATES_SIZE_X = "duplicatesSizeX";
    public static final String DUPLICATES_POS_Y = "duplicatesPosY";
    public static final String DUPLICATES_POS_X = "duplicatesPosX";
    public static final String MERGEENTRIES_SIZE_Y = "mergeEntriesSizeY";
    public static final String MERGEENTRIES_SIZE_X = "mergeEntriesSizeX";
    public static final String MERGEENTRIES_POS_Y = "mergeEntriesPosY";
    public static final String MERGEENTRIES_POS_X = "mergeEntriesPosX";
    public static final String PREAMBLE_SIZE_Y = "preambleSizeY";
    public static final String PREAMBLE_SIZE_X = "preambleSizeX";
    public static final String PREAMBLE_POS_Y = "preamblePosY";
    public static final String PREAMBLE_POS_X = "preamblePosX";
    public static final String TERMS_SIZE_Y = "termsSizeY";
    public static final String TERMS_SIZE_X = "termsSizeX";
    public static final String TERMS_POS_Y = "termsPosY";
    public static final String TERMS_POS_X = "termsPosX";
    public static final String SEARCH_DIALOG_HEIGHT = "searchDialogHeight";
    public static final String SEARCH_DIALOG_WIDTH = "searchDialogWidth";
    public static final String IMPORT_INSPECTION_DIALOG_HEIGHT = "importInspectionDialogHeight";
    public static final String IMPORT_INSPECTION_DIALOG_WIDTH = "importInspectionDialogWidth";
    public static final String LAST_EDITED = "lastEdited";
    public static final String OPEN_LAST_EDITED = "openLastEdited";
    public static final String LAST_FOCUSED = "lastFocused";
    public static final String BACKUP = "backup";
    public static final String AUTO_OPEN_FORM = "autoOpenForm";
    public static final String IMPORT_WORKING_DIRECTORY = "importWorkingDirectory";
    public static final String EXPORT_WORKING_DIRECTORY = "exportWorkingDirectory";
    public static final String PREFS_EXPORT_PATH = "prefsExportPath";
    public static final String WORKING_DIRECTORY = "workingDirectory";
    public static final String NUMBER_COL_WIDTH = "numberColWidth";
    public static final String AUTO_COMPLETE = "autoComplete";
    public static final String EDITOR_EMACS_KEYBINDINGS = "editorEMACSkeyBindings";
    public static final String EDITOR_EMACS_KEYBINDINGS_REBIND_CA = "editorEMACSkeyBindingsRebindCA";
    public static final String EDITOR_EMACS_KEYBINDINGS_REBIND_CF = "editorEMACSkeyBindingsRebindCF";
    public static final String GROUP_SHOW_NUMBER_OF_ELEMENTS = "groupShowNumberOfElements";
    public static final String GROUP_EXPAND_TREE = "groupExpandTree";
    public static final String GROUP_SHOW_DYNAMIC = "groupShowDynamic";
    public static final String GROUP_SHOW_ICONS = "groupShowIcons";
    public static final String GROUPS_DEFAULT_FIELD = "groupsDefaultField";
    public static final String GROUP_SHOW_OVERLAPPING = "groupShowOverlapping";
    public static final String GROUP_INVERT_SELECTIONS = "groupInvertSelections";
    public static final String GROUP_INTERSECT_SELECTIONS = "groupIntersectSelections";
    public static final String GROUP_FLOAT_SELECTIONS = "groupFloatSelections";
    public static final String EDIT_GROUP_MEMBERSHIP_MODE = "groupEditGroupMembershipMode";
    public static final String KEYWORD_SEPARATOR = "groupKeywordSeparator";
    public static final String AUTO_ASSIGN_GROUP = "autoAssignGroup";
    public static final String LIST_OF_FILE_COLUMNS = "listOfFileColumns";
    public static final String EXTRA_FILE_COLUMNS = "extraFileColumns";
    public static final String ARXIV_COLUMN = "arxivColumn";
    public static final String FILE_COLUMN = "fileColumn";
    public static final String PREFER_URL_DOI = "preferUrlDoi";
    public static final String URL_COLUMN = "urlColumn";
    public static final String TABLE_COLOR_CODES_ON = "tableColorCodesOn";
    public static final String TABLE_RESOLVED_COLOR_CODES_ON = "tableResolvedColorCodesOn";
    public static final String INCOMPLETE_ENTRY_BACKGROUND = "incompleteEntryBackground";
    public static final String FIELD_EDITOR_TEXT_COLOR = "fieldEditorTextColor";
    public static final String ACTIVE_FIELD_EDITOR_BACKGROUND_COLOR = "activeFieldEditorBackgroundColor";
    public static final String INVALID_FIELD_BACKGROUND_COLOR = "invalidFieldBackgroundColor";
    public static final String VALID_FIELD_BACKGROUND_COLOR = "validFieldBackgroundColor";
    public static final String MARKED_ENTRY_BACKGROUND5 = "markedEntryBackground5";
    public static final String MARKED_ENTRY_BACKGROUND4 = "markedEntryBackground4";
    public static final String MARKED_ENTRY_BACKGROUND3 = "markedEntryBackground3";
    public static final String MARKED_ENTRY_BACKGROUND2 = "markedEntryBackground2";
    public static final String MARKED_ENTRY_BACKGROUND1 = "markedEntryBackground1";
    public static final String MARKED_ENTRY_BACKGROUND0 = "markedEntryBackground0";
    public static final String VERY_GRAYED_OUT_TEXT = "veryGrayedOutText";
    public static final String VERY_GRAYED_OUT_BACKGROUND = "veryGrayedOutBackground";
    public static final String GRAYED_OUT_TEXT = "grayedOutText";
    public static final String GRAYED_OUT_BACKGROUND = "grayedOutBackground";
    public static final String GRID_COLOR = "gridColor";
    public static final String TABLE_TEXT = "tableText";
    public static final String TABLE_OPT_FIELD_BACKGROUND = "tableOptFieldBackground";
    public static final String TABLE_REQ_FIELD_BACKGROUND = "tableReqFieldBackground";
    public static final String MARKED_ENTRY_BACKGROUND = "markedEntryBackground";
    public static final String TABLE_RESOLVED_FIELD_BACKGROUND = "tableResolvedFieldBackground";
    public static final String TABLE_BACKGROUND = "tableBackground";
    public static final String TABLE_SHOW_GRID = "tableShowGrid";
    public static final String TABLE_ROW_PADDING = "tableRowPadding";
    public static final String MENU_FONT_SIZE = "menuFontSize";
    public static final String OVERRIDE_DEFAULT_FONTS = "overrideDefaultFonts";
    public static final String FONT_SIZE = "fontSize";
    public static final String FONT_STYLE = "fontStyle";
    public static final String RECENT_DATABASES = "recentDatabases";
    public static final String RENAME_ON_MOVE_FILE_TO_FILE_DIR = "renameOnMoveFileToFileDir";
    public static final String MEMORY_STICK_MODE = "memoryStickMode";
    public static final String DEFAULT_OWNER = "defaultOwner";
    public static final String DEFAULT_ENCODING = "defaultEncoding";
    public static final String TOOLBAR_VISIBLE = "toolbarVisible";
    public static final String HIGHLIGHT_GROUPS_MATCHING = "highlightGroupsMatching";
    public static final String UPDATE_TIMESTAMP = "updateTimestamp";
    public static final String TIME_STAMP_FIELD = "timeStampField";
    public static final String TIME_STAMP_FORMAT = "timeStampFormat";
    public static final String OVERWRITE_TIME_STAMP = "overwriteTimeStamp";
    public static final String USE_TIME_STAMP = "useTimeStamp";
    public static final String WARN_ABOUT_DUPLICATES_IN_INSPECTION = "warnAboutDuplicatesInInspection";
    public static final String UNMARK_ALL_ENTRIES_BEFORE_IMPORTING = "unmarkAllEntriesBeforeImporting";
    public static final String MARK_IMPORTED_ENTRIES = "markImportedEntries";
    public static final String GENERATE_KEYS_AFTER_INSPECTION = "generateKeysAfterInspection";
    public static final String NON_WRAPPABLE_FIELDS = "nonWrappableFields";
    public static final String RESOLVE_STRINGS_ALL_FIELDS = "resolveStringsAllFields";
    public static final String DO_NOT_RESOLVE_STRINGS_FOR = "doNotResolveStringsFor";
    public static final String MERGE_ENTRIES_DIFF_MODE = "mergeEntriesDiffMode";
    public static final String CUSTOM_EXPORT_FORMAT = "customExportFormat";
    public static final String CUSTOM_IMPORT_FORMAT = "customImportFormat";
    public static final String BINDINGS = "bindings";
    public static final String BIND_NAMES = "bindNames";
    public static final String KEY_PATTERN_REGEX = "KeyPatternRegex";
    public static final String KEY_PATTERN_REPLACEMENT = "KeyPatternReplacement";
    public static final String CONSOLE_COMMAND = "consoleCommand";
    public static final String USE_DEFAULT_CONSOLE_APPLICATION = "useDefaultConsoleApplication";
    public static final String DEFAULT_BIBTEX_KEY_PATTERN = "defaultBibtexKeyPattern";
    public static final String GRAY_OUT_NON_HITS = "grayOutNonHits";
    public static final String CONFIRM_DELETE = "confirmDelete";
    public static final String WARN_BEFORE_OVERWRITING_KEY = "warnBeforeOverwritingKey";
    public static final String AVOID_OVERWRITING_KEY = "avoidOverwritingKey";
    public static final String OVERWRITE_OWNER = "overwriteOwner";
    public static final String USE_OWNER = "useOwner";
    public static final String AUTOLINK_EXACT_KEY_ONLY = "autolinkExactKeyOnly";
    public static final String SHOW_FILE_LINKS_UPGRADE_WARNING = "showFileLinksUpgradeWarning";
    public static final String SIDE_PANE_WIDTH = "sidePaneWidth";
    public static final String LAST_USED_EXPORT = "lastUsedExport";
    public static final String FLOAT_MARKED_ENTRIES = "floatMarkedEntries";
    public static final String CITE_COMMAND = "citeCommand";
    public static final String EXTERNAL_JOURNAL_LISTS = "externalJournalLists";
    public static final String PERSONAL_JOURNAL_LIST = "personalJournalList";
    public static final String GENERATE_KEYS_BEFORE_SAVING = "generateKeysBeforeSaving";
    public static final String EMAIL_SUBJECT = "emailSubject";
    public static final String OPEN_FOLDERS_OF_ATTACHED_FILES = "openFoldersOfAttachedFiles";
    public static final String KEY_GEN_ALWAYS_ADD_LETTER = "keyGenAlwaysAddLetter";
    public static final String KEY_GEN_FIRST_LETTER_A = "keyGenFirstLetterA";
    public static final String ENFORCE_LEGAL_BIBTEX_KEY = "enforceLegalBibtexKey";
    public static final String LOCAL_AUTO_SAVE = "localAutoSave";
    public static final String RUN_AUTOMATIC_FILE_SEARCH = "runAutomaticFileSearch";
    public static final String NUMERIC_FIELDS = "numericFields";
    public static final String REG_EXP_SEARCH_EXPRESSION_KEY = "regExpSearchExpression";
    public static final String AUTOLINK_USE_REG_EXP_SEARCH_KEY = "useRegExpSearch";
    private static final String DB_CONNECT_USERNAME = "dbConnectUsername";
    private static final String DB_CONNECT_DATABASE = "dbConnectDatabase";
    private static final String DB_CONNECT_HOSTNAME = "dbConnectHostname";
    private static final String DB_CONNECT_SERVER_TYPE = "dbConnectServerType";
    public static final String BIB_LOC_AS_PRIMARY_DIR = "bibLocAsPrimaryDir";
    public static final String SELECTED_FETCHER_INDEX = "selectedFetcherIndex";
    public static final String WEB_SEARCH_VISIBLE = "webSearchVisible";
    public static final String GROUP_SIDEPANE_VISIBLE = "groupSidepaneVisible";
    public static final String ALLOW_FILE_AUTO_OPEN_BROWSE = "allowFileAutoOpenBrowse";
    public static final String CUSTOM_TAB_NAME = "customTabName_";
    public static final String CUSTOM_TAB_FIELDS = "customTabFields_";
    public static final String USE_UNIT_FORMATTER_ON_SEARCH = "useUnitFormatterOnSearch";
    public static final String USE_CASE_KEEPER_ON_SEARCH = "useCaseKeeperOnSearch";
    public static final String USE_IEEE_ABRV = "useIEEEAbrv";
    private static final String PROTECTED_TERMS_ENABLED_EXTERNAL = "protectedTermsEnabledExternal";
    private static final String PROTECTED_TERMS_DISABLED_EXTERNAL = "protectedTermsDisabledExternal";
    private static final String PROTECTED_TERMS_ENABLED_INTERNAL = "protectedTermsEnabledInternal";
    private static final String PROTECTED_TERMS_DISABLED_INTERNAL = "protectedTermsDisabledInternal";
    public static final String ASK_AUTO_NAMING_PDFS_AGAIN = "AskAutoNamingPDFsAgain";
    public static final String CLEANUP_DOI = "CleanUpDOI";
    public static final String CLEANUP_ISSN = "CleanUpISSN";
    public static final String CLEANUP_MOVE_PDF = "CleanUpMovePDF";
    public static final String CLEANUP_MAKE_PATHS_RELATIVE = "CleanUpMakePathsRelative";
    public static final String CLEANUP_RENAME_PDF = "CleanUpRenamePDF";
    public static final String CLEANUP_RENAME_PDF_ONLY_RELATIVE_PATHS = "CleanUpRenamePDFonlyRelativePaths";
    public static final String CLEANUP_UPGRADE_EXTERNAL_LINKS = "CleanUpUpgradeExternalLinks";
    public static final String CLEANUP_CONVERT_TO_BIBLATEX = "CleanUpConvertToBiblatex";
    public static final String CLEANUP_FIX_FILE_LINKS = "CleanUpFixFileLinks";
    public static final String CLEANUP_FORMATTERS = "CleanUpFormatters";
    public static final String IMPORT_DEFAULT_PDF_IMPORT_STYLE = "importDefaultPDFimportStyle";
    public static final String IMPORT_ALWAYSUSE = "importAlwaysUsePDFImportStyle";
    public static final String IMPORT_FILENAMEPATTERN = "importFileNamePattern";
    public static final String NAME_FORMATTER_VALUE = "nameFormatterFormats";
    public static final String NAME_FORMATER_KEY = "nameFormatterNames";
    public static final String PUSH_TO_APPLICATION = "pushToApplication";
    public static final String OO_EXECUTABLE_PATH = "ooExecutablePath";
    public static final String OO_PATH = "ooPath";
    public static final String OO_JARS_PATH = "ooJarsPath";
    public static final String OO_SHOW_PANEL = "showOOPanel";
    public static final String OO_SYNC_WHEN_CITING = "syncOOWhenCiting";
    public static final String OO_USE_ALL_OPEN_BASES = "useAllOpenBases";
    public static final String OO_BIBLIOGRAPHY_STYLE_FILE = "ooBibliographyStyleFile";
    public static final String OO_EXTERNAL_STYLE_FILES = "ooExternalStyleFiles";
    public static final String STYLES_SIZE_Y = "stylesSizeY";
    public static final String STYLES_SIZE_X = "stylesSizeX";
    public static final String STYLES_POS_Y = "stylesPosY";
    public static final String STYLES_POS_X = "stylesPosX";
    public static final String SHOWCOLUMN_RELEVANCE = "showRelevanceColumn";
    public static final String SHOWCOLUMN_READ = "showReadColumn";
    public static final String SHOWCOLUMN_RANKING = "showRankingColumn";
    public static final String SHOWCOLUMN_QUALITY = "showQualityColumn";
    public static final String SHOWCOLUMN_PRIORITY = "showPriorityColumn";
    public static final String SHOWCOLUMN_PRINTED = "showPrintedColumn";
    public static final String SPECIALFIELDSENABLED = "specialFieldsEnabled";
    public static final String SERIALIZESPECIALFIELDS = "serializeSpecialFields";
    public static final String AUTOSYNCSPECIALFIELDSTOKEYWORDS = "autoSyncSpecialFieldsToKeywords";
    private static final String CUSTOM_TYPE_NAME = "customTypeName_";
    private static final String CUSTOM_TYPE_REQ = "customTypeReq_";
    private static final String CUSTOM_TYPE_OPT = "customTypeOpt_";
    private static final String CUSTOM_TYPE_PRIOPT = "customTypePriOpt_";
    public static final String BIBTEX_KEY_PATTERNS_NODE = "bibtexkeypatterns";
    public static final String VERSION_IGNORED_UPDATE = "versionIgnoreUpdate";
    public static final String DROPPEDFILEHANDLER_RENAME = "DroppedFileHandler_RenameFile";
    public static final String DROPPEDFILEHANDLER_MOVE = "DroppedFileHandler_MoveFile";
    public static final String DROPPEDFILEHANDLER_COPY = "DroppedFileHandler_CopyFile";
    public static final String DROPPEDFILEHANDLER_LEAVE = "DroppedFileHandler_LeaveFileInDir";
    public static final String USE_REMOTE_SERVER = "useRemoteServer";
    public static final String REMOTE_SERVER_PORT = "remoteServerPort";
    private static final String CYCLE_PREVIEW_POS = "cyclePreviewPos";
    private static final String CYCLE_PREVIEW = "cyclePreview";
    private static final String PREVIEW_PANEL_HEIGHT = "previewPanelHeight";
    private static final String PREVIEW_STYLE = "previewStyle";
    private static final String PREVIEW_ENABLED = "previewEnabled";
    public final String MARKING_WITH_NUMBER_PATTERN;
    private final Preferences prefs;
    private GlobalBibtexKeyPattern keyPattern;
    public final CustomExportList customExports;
    private static final String USER_HOME = System.getProperty("user.home");
    public final CustomImportList customImports;
    private EntryEditorTabList tabList;
    public List<String> fileDirForDatabase;
    private static JabRefPreferences singleton;

    public static JabRefPreferences getInstance() {
        if (singleton == null) {
            singleton = new JabRefPreferences();
        }
        return singleton;
    }

    private JabRefPreferences() {
        try {
            if (new File("jabref.xml").exists()) {
                this.importPreferences("jabref.xml");
            }
        }
        catch (JabRefException e) {
            LOGGER.warn("Could not import preferences from jabref.xml: " + e.getMessage(), e);
        }
        this.prefs = Preferences.userNodeForPackage(JabRefMain.class);
        SearchPreferences.putDefaults(this.defaults);
        this.defaults.put(TEXMAKER_PATH, JabRefDesktop.getNativeDesktop().detectProgramPath("texmaker", "Texmaker"));
        this.defaults.put(WIN_EDT_PATH, JabRefDesktop.getNativeDesktop().detectProgramPath("WinEdt", "WinEdt Team\\WinEdt"));
        this.defaults.put(LATEX_EDITOR_PATH, JabRefDesktop.getNativeDesktop().detectProgramPath("LEd", "LEd"));
        this.defaults.put(TEXSTUDIO_PATH, JabRefDesktop.getNativeDesktop().detectProgramPath("texstudio", "TeXstudio"));
        this.defaults.put(BIBLATEX_DEFAULT_MODE, Boolean.FALSE);
        if (OS.OS_X) {
            this.defaults.put(EMACS_PATH, "emacsclient");
            this.defaults.put(EMACS_23, true);
            this.defaults.put(EMACS_ADDITIONAL_PARAMETERS, "-n -e");
            this.defaults.put(FONT_FAMILY, "SansSerif");
            this.defaults.put(WIN_LOOK_AND_FEEL, UIManager.getSystemLookAndFeelClassName());
        } else if (OS.WINDOWS) {
            this.defaults.put(WIN_LOOK_AND_FEEL, "com.jgoodies.looks.windows.WindowsLookAndFeel");
            this.defaults.put(EMACS_PATH, "emacsclient.exe");
            this.defaults.put(EMACS_23, Boolean.TRUE);
            this.defaults.put(EMACS_ADDITIONAL_PARAMETERS, "-n -e");
            this.defaults.put(FONT_FAMILY, "Arial");
        } else {
            this.defaults.put(WIN_LOOK_AND_FEEL, "com.jgoodies.plaf.plastic.Plastic3DLookAndFeel");
            this.defaults.put(FONT_FAMILY, "SansSerif");
            this.defaults.put(EMACS_PATH, "gnuclient");
            this.defaults.put(EMACS_23, Boolean.FALSE);
            this.defaults.put(EMACS_ADDITIONAL_PARAMETERS, "-batch -eval");
        }
        this.defaults.put(PUSH_TO_APPLICATION, "TeXstudio");
        this.defaults.put(RECENT_DATABASES, "");
        this.defaults.put(EXTERNAL_FILE_TYPES, "");
        this.defaults.put(KEY_PATTERN_REGEX, "");
        this.defaults.put(KEY_PATTERN_REPLACEMENT, "");
        this.defaults.put(PROXY_USE, Boolean.FALSE);
        this.defaults.put(PROXY_HOSTNAME, "");
        this.defaults.put(PROXY_PORT, "80");
        this.defaults.put(PROXY_USE_AUTHENTICATION, Boolean.FALSE);
        this.defaults.put(PROXY_USERNAME, "");
        this.defaults.put(PROXY_PASSWORD, "");
        this.defaults.put(USE_DEFAULT_LOOK_AND_FEEL, Boolean.TRUE);
        this.defaults.put(LYXPIPE, USER_HOME + File.separator + ".lyx/lyxpipe");
        this.defaults.put(VIM, VIM);
        this.defaults.put(VIM_SERVER, VIM);
        this.defaults.put(POS_X, 0);
        this.defaults.put(POS_Y, 0);
        this.defaults.put(SIZE_X, 1024);
        this.defaults.put(SIZE_Y, 768);
        this.defaults.put(WINDOW_MAXIMISED, Boolean.FALSE);
        this.defaults.put(AUTO_RESIZE_MODE, 4);
        this.defaults.put(ENTRY_EDITOR_HEIGHT, 400);
        this.defaults.put(TABLE_COLOR_CODES_ON, Boolean.FALSE);
        this.defaults.put(TABLE_RESOLVED_COLOR_CODES_ON, Boolean.FALSE);
        this.defaults.put(NAMES_AS_IS, Boolean.FALSE);
        this.defaults.put(NAMES_FIRST_LAST, Boolean.FALSE);
        this.defaults.put(NAMES_NATBIB, Boolean.TRUE);
        this.defaults.put(ABBR_AUTHOR_NAMES, Boolean.TRUE);
        this.defaults.put(NAMES_LAST_ONLY, Boolean.TRUE);
        this.defaults.put(LANGUAGE, Locale.getDefault().getLanguage());
        this.defaults.put(TABLE_PRIMARY_SORT_FIELD, "author");
        this.defaults.put(TABLE_PRIMARY_SORT_DESCENDING, Boolean.FALSE);
        this.defaults.put(TABLE_SECONDARY_SORT_FIELD, "year");
        this.defaults.put(TABLE_SECONDARY_SORT_DESCENDING, Boolean.TRUE);
        this.defaults.put(TABLE_TERTIARY_SORT_FIELD, "title");
        this.defaults.put(TABLE_TERTIARY_SORT_DESCENDING, Boolean.FALSE);
        this.defaults.put(REFORMAT_FILE_ON_SAVE_AND_EXPORT, Boolean.FALSE);
        this.defaults.put(EXPORT_IN_ORIGINAL_ORDER, Boolean.FALSE);
        this.defaults.put(EXPORT_IN_SPECIFIED_ORDER, Boolean.FALSE);
        this.defaults.put(EXPORT_PRIMARY_SORT_FIELD, "bibtexkey");
        this.defaults.put(EXPORT_PRIMARY_SORT_DESCENDING, Boolean.FALSE);
        this.defaults.put(EXPORT_SECONDARY_SORT_FIELD, "author");
        this.defaults.put(EXPORT_SECONDARY_SORT_DESCENDING, Boolean.FALSE);
        this.defaults.put(EXPORT_TERTIARY_SORT_FIELD, "title");
        this.defaults.put(EXPORT_TERTIARY_SORT_DESCENDING, Boolean.TRUE);
        this.defaults.put(NEWLINE, System.lineSeparator());
        this.defaults.put(SIDE_PANE_COMPONENT_NAMES, "");
        this.defaults.put(SIDE_PANE_COMPONENT_PREFERRED_POSITIONS, "");
        this.defaults.put(COLUMN_NAMES, "entrytype;author/editor;title;year;journal/booktitle;bibtexkey");
        this.defaults.put(COLUMN_WIDTHS, "75;300;470;60;130;100");
        this.defaults.put(XMP_PRIVACY_FILTERS, "pdf;timestamp;keywords;owner;note;review");
        this.defaults.put(USE_XMP_PRIVACY_FILTER, Boolean.FALSE);
        this.defaults.put(NUMBER_COL_WIDTH, 32);
        this.defaults.put(WORKING_DIRECTORY, USER_HOME);
        this.defaults.put(EXPORT_WORKING_DIRECTORY, USER_HOME);
        this.defaults.put(IMPORT_WORKING_DIRECTORY, USER_HOME);
        this.defaults.put(PREFS_EXPORT_PATH, WORKING_DIRECTORY);
        this.defaults.put(AUTO_OPEN_FORM, Boolean.TRUE);
        this.defaults.put(BACKUP, Boolean.TRUE);
        this.defaults.put(OPEN_LAST_EDITED, Boolean.TRUE);
        this.defaults.put(LAST_EDITED, "");
        this.defaults.put(LAST_FOCUSED, "");
        this.defaults.put(STRINGS_POS_X, 0);
        this.defaults.put(STRINGS_POS_Y, 0);
        this.defaults.put(STRINGS_SIZE_X, 600);
        this.defaults.put(STRINGS_SIZE_Y, 400);
        this.defaults.put(DUPLICATES_POS_X, 0);
        this.defaults.put(DUPLICATES_POS_Y, 0);
        this.defaults.put(DUPLICATES_SIZE_X, 800);
        this.defaults.put(DUPLICATES_SIZE_Y, 600);
        this.defaults.put(MERGEENTRIES_POS_X, 0);
        this.defaults.put(MERGEENTRIES_POS_Y, 0);
        this.defaults.put(MERGEENTRIES_SIZE_X, 800);
        this.defaults.put(MERGEENTRIES_SIZE_Y, 600);
        this.defaults.put(PREAMBLE_POS_X, 0);
        this.defaults.put(PREAMBLE_POS_Y, 0);
        this.defaults.put(PREAMBLE_SIZE_X, 600);
        this.defaults.put(PREAMBLE_SIZE_Y, 400);
        this.defaults.put(TERMS_POS_X, 0);
        this.defaults.put(TERMS_POS_Y, 0);
        this.defaults.put(TERMS_SIZE_X, 500);
        this.defaults.put(TERMS_SIZE_Y, 500);
        this.defaults.put(DEFAULT_SHOW_SOURCE, Boolean.FALSE);
        this.defaults.put(DEFAULT_AUTO_SORT, Boolean.FALSE);
        this.defaults.put(MERGE_ENTRIES_DIFF_MODE, 2);
        this.defaults.put(EDITOR_EMACS_KEYBINDINGS, Boolean.FALSE);
        this.defaults.put(EDITOR_EMACS_KEYBINDINGS_REBIND_CA, Boolean.TRUE);
        this.defaults.put(EDITOR_EMACS_KEYBINDINGS_REBIND_CF, Boolean.TRUE);
        this.defaults.put(AUTO_COMPLETE, Boolean.TRUE);
        AutoCompletePreferences.putDefaults(this.defaults);
        this.defaults.put(GROUP_FLOAT_SELECTIONS, Boolean.TRUE);
        this.defaults.put(GROUP_INTERSECT_SELECTIONS, Boolean.TRUE);
        this.defaults.put(GROUP_INVERT_SELECTIONS, Boolean.FALSE);
        this.defaults.put(GROUP_SHOW_OVERLAPPING, Boolean.FALSE);
        this.defaults.put(GROUPS_DEFAULT_FIELD, "keywords");
        this.defaults.put(GROUP_SHOW_ICONS, Boolean.TRUE);
        this.defaults.put(GROUP_SHOW_DYNAMIC, Boolean.TRUE);
        this.defaults.put(GROUP_EXPAND_TREE, Boolean.TRUE);
        this.defaults.put(GROUP_SHOW_NUMBER_OF_ELEMENTS, Boolean.FALSE);
        this.defaults.put(AUTO_ASSIGN_GROUP, Boolean.TRUE);
        this.defaults.put(KEYWORD_SEPARATOR, ", ");
        this.defaults.put(EDIT_GROUP_MEMBERSHIP_MODE, Boolean.FALSE);
        this.defaults.put(HIGHLIGHT_GROUPS_MATCHING, "all");
        this.defaults.put(TOOLBAR_VISIBLE, Boolean.TRUE);
        this.defaults.put(DEFAULT_ENCODING, StandardCharsets.UTF_8.name());
        this.defaults.put(DEFAULT_OWNER, System.getProperty("user.name"));
        this.defaults.put(MEMORY_STICK_MODE, Boolean.FALSE);
        this.defaults.put(RENAME_ON_MOVE_FILE_TO_FILE_DIR, Boolean.TRUE);
        this.defaults.put(FONT_STYLE, 0);
        this.defaults.put(FONT_SIZE, 12);
        this.defaults.put(OVERRIDE_DEFAULT_FONTS, Boolean.FALSE);
        this.defaults.put(MENU_FONT_SIZE, 11);
        this.defaults.put(TABLE_ROW_PADDING, 9);
        this.defaults.put(TABLE_SHOW_GRID, Boolean.FALSE);
        this.defaults.put(TABLE_BACKGROUND, "255:255:255");
        this.defaults.put(TABLE_REQ_FIELD_BACKGROUND, "230:235:255");
        this.defaults.put(TABLE_OPT_FIELD_BACKGROUND, "230:255:230");
        this.defaults.put(TABLE_RESOLVED_FIELD_BACKGROUND, "240:240:240");
        this.defaults.put(TABLE_TEXT, "0:0:0");
        this.defaults.put(GRID_COLOR, "210:210:210");
        this.defaults.put(GRAYED_OUT_BACKGROUND, "210:210:210");
        this.defaults.put(GRAYED_OUT_TEXT, "40:40:40");
        this.defaults.put(VERY_GRAYED_OUT_BACKGROUND, "180:180:180");
        this.defaults.put(VERY_GRAYED_OUT_TEXT, "40:40:40");
        this.defaults.put(MARKED_ENTRY_BACKGROUND0, "255:255:180");
        this.defaults.put(MARKED_ENTRY_BACKGROUND1, "255:220:180");
        this.defaults.put(MARKED_ENTRY_BACKGROUND2, "255:180:160");
        this.defaults.put(MARKED_ENTRY_BACKGROUND3, "255:120:120");
        this.defaults.put(MARKED_ENTRY_BACKGROUND4, "255:75:75");
        this.defaults.put(MARKED_ENTRY_BACKGROUND5, "220:255:220");
        this.defaults.put(VALID_FIELD_BACKGROUND_COLOR, "255:255:255");
        this.defaults.put(INVALID_FIELD_BACKGROUND_COLOR, "255:0:0");
        this.defaults.put(ACTIVE_FIELD_EDITOR_BACKGROUND_COLOR, "220:220:255");
        this.defaults.put(FIELD_EDITOR_TEXT_COLOR, "0:0:0");
        this.defaults.put(INCOMPLETE_ENTRY_BACKGROUND, "250:175:175");
        this.defaults.put(URL_COLUMN, Boolean.TRUE);
        this.defaults.put(PREFER_URL_DOI, Boolean.FALSE);
        this.defaults.put(FILE_COLUMN, Boolean.TRUE);
        this.defaults.put(ARXIV_COLUMN, Boolean.FALSE);
        this.defaults.put(EXTRA_FILE_COLUMNS, Boolean.FALSE);
        this.defaults.put(LIST_OF_FILE_COLUMNS, "");
        this.defaults.put(PROTECTED_TERMS_ENABLED_INTERNAL, JabRefPreferences.convertListToString(ProtectedTermsLoader.getInternalLists()));
        this.defaults.put(PROTECTED_TERMS_DISABLED_INTERNAL, "");
        this.defaults.put(PROTECTED_TERMS_ENABLED_EXTERNAL, "");
        this.defaults.put(PROTECTED_TERMS_DISABLED_EXTERNAL, "");
        if (OS.WINDOWS) {
            this.defaults.put(OO_PATH, "C:\\Program Files\\OpenOffice.org 4");
            this.defaults.put(OO_EXECUTABLE_PATH, "C:\\Program Files\\OpenOffice.org 4\\program\\soffice.exe");
            this.defaults.put(OO_JARS_PATH, "C:\\Program Files\\OpenOffice.org 4\\program\\classes");
        } else if (OS.OS_X) {
            this.defaults.put(OO_PATH, "/Applications/OpenOffice.org.app");
            this.defaults.put(OO_EXECUTABLE_PATH, "/Applications/OpenOffice.org.app/Contents/MacOS/soffice.bin");
            this.defaults.put(OO_JARS_PATH, "/Applications/OpenOffice.org.app/Contents/Resources/java");
        } else {
            this.defaults.put(OO_PATH, "/opt/openoffice.org3");
            this.defaults.put(OO_EXECUTABLE_PATH, "/usr/lib/openoffice/program/soffice");
            this.defaults.put(OO_JARS_PATH, "/opt/openoffice.org/basis3.0");
        }
        this.defaults.put(OO_SYNC_WHEN_CITING, Boolean.FALSE);
        this.defaults.put(OO_SHOW_PANEL, Boolean.FALSE);
        this.defaults.put(OO_USE_ALL_OPEN_BASES, Boolean.TRUE);
        this.defaults.put(OO_BIBLIOGRAPHY_STYLE_FILE, "/resource/openoffice/default_authoryear.jstyle");
        this.defaults.put(OO_EXTERNAL_STYLE_FILES, "");
        this.defaults.put(STYLES_POS_X, 0);
        this.defaults.put(STYLES_POS_Y, 0);
        this.defaults.put(STYLES_SIZE_X, 600);
        this.defaults.put(STYLES_SIZE_Y, 400);
        this.defaults.put(SPECIALFIELDSENABLED, Boolean.TRUE);
        this.defaults.put(SHOWCOLUMN_PRIORITY, Boolean.FALSE);
        this.defaults.put(SHOWCOLUMN_QUALITY, Boolean.FALSE);
        this.defaults.put(SHOWCOLUMN_RANKING, Boolean.TRUE);
        this.defaults.put(SHOWCOLUMN_RELEVANCE, Boolean.FALSE);
        this.defaults.put(SHOWCOLUMN_PRINTED, Boolean.FALSE);
        this.defaults.put(SHOWCOLUMN_READ, Boolean.FALSE);
        this.defaults.put(AUTOSYNCSPECIALFIELDSTOKEYWORDS, Boolean.TRUE);
        this.defaults.put(SERIALIZESPECIALFIELDS, Boolean.FALSE);
        this.defaults.put(USE_OWNER, Boolean.FALSE);
        this.defaults.put(OVERWRITE_OWNER, Boolean.FALSE);
        this.defaults.put(AVOID_OVERWRITING_KEY, Boolean.FALSE);
        this.defaults.put(WARN_BEFORE_OVERWRITING_KEY, Boolean.TRUE);
        this.defaults.put(CONFIRM_DELETE, Boolean.TRUE);
        this.defaults.put(GRAY_OUT_NON_HITS, Boolean.TRUE);
        this.defaults.put(DEFAULT_BIBTEX_KEY_PATTERN, "[auth][year]");
        this.defaults.put(DO_NOT_RESOLVE_STRINGS_FOR, "url");
        this.defaults.put(RESOLVE_STRINGS_ALL_FIELDS, Boolean.FALSE);
        this.defaults.put(NON_WRAPPABLE_FIELDS, "pdf;ps;url;doi;file;isbn;issn");
        this.defaults.put(GENERATE_KEYS_AFTER_INSPECTION, Boolean.TRUE);
        this.defaults.put(MARK_IMPORTED_ENTRIES, Boolean.TRUE);
        this.defaults.put(UNMARK_ALL_ENTRIES_BEFORE_IMPORTING, Boolean.TRUE);
        this.defaults.put(WARN_ABOUT_DUPLICATES_IN_INSPECTION, Boolean.TRUE);
        this.defaults.put(USE_TIME_STAMP, Boolean.FALSE);
        this.defaults.put(OVERWRITE_TIME_STAMP, Boolean.FALSE);
        this.defaults.put(TIME_STAMP_FORMAT, "yyyy-MM-dd");
        this.defaults.put(TIME_STAMP_FIELD, "timestamp");
        this.defaults.put(UPDATE_TIMESTAMP, Boolean.FALSE);
        this.defaults.put(GENERATE_KEYS_BEFORE_SAVING, Boolean.FALSE);
        this.defaults.put(USE_REMOTE_SERVER, Boolean.TRUE);
        this.defaults.put(REMOTE_SERVER_PORT, 6050);
        this.defaults.put(PERSONAL_JOURNAL_LIST, "");
        this.defaults.put(EXTERNAL_JOURNAL_LISTS, "");
        this.defaults.put(CITE_COMMAND, "\\cite");
        this.defaults.put(FLOAT_MARKED_ENTRIES, Boolean.TRUE);
        this.defaults.put(LAST_USED_EXPORT, "");
        this.defaults.put(SIDE_PANE_WIDTH, -1);
        this.defaults.put(IMPORT_INSPECTION_DIALOG_WIDTH, 650);
        this.defaults.put(IMPORT_INSPECTION_DIALOG_HEIGHT, 650);
        this.defaults.put(SHOW_FILE_LINKS_UPGRADE_WARNING, Boolean.TRUE);
        this.defaults.put(AUTOLINK_EXACT_KEY_ONLY, Boolean.FALSE);
        this.defaults.put(NUMERIC_FIELDS, "mittnum;author");
        this.defaults.put(RUN_AUTOMATIC_FILE_SEARCH, Boolean.FALSE);
        this.defaults.put(LOCAL_AUTO_SAVE, Boolean.FALSE);
        this.defaults.put(ENFORCE_LEGAL_BIBTEX_KEY, Boolean.TRUE);
        this.defaults.put(KEY_GEN_FIRST_LETTER_A, Boolean.TRUE);
        this.defaults.put(KEY_GEN_ALWAYS_ADD_LETTER, Boolean.FALSE);
        this.defaults.put(EMAIL_SUBJECT, Localization.lang("References", new String[0]));
        this.defaults.put(OPEN_FOLDERS_OF_ATTACHED_FILES, Boolean.FALSE);
        this.defaults.put(ALLOW_FILE_AUTO_OPEN_BROWSE, Boolean.TRUE);
        this.defaults.put(WEB_SEARCH_VISIBLE, Boolean.FALSE);
        this.defaults.put(GROUP_SIDEPANE_VISIBLE, Boolean.FALSE);
        this.defaults.put(SELECTED_FETCHER_INDEX, 0);
        this.defaults.put(BIB_LOC_AS_PRIMARY_DIR, Boolean.FALSE);
        this.defaults.put(DB_CONNECT_SERVER_TYPE, "MySQL");
        this.defaults.put(DB_CONNECT_HOSTNAME, "localhost");
        this.defaults.put(DB_CONNECT_DATABASE, "jabref");
        this.defaults.put(DB_CONNECT_USERNAME, "root");
        this.defaults.put(ASK_AUTO_NAMING_PDFS_AGAIN, Boolean.TRUE);
        JabRefPreferences.insertDefaultCleanupPreset(this.defaults);
        this.defaults.put(DROPPEDFILEHANDLER_LEAVE, Boolean.FALSE);
        this.defaults.put(DROPPEDFILEHANDLER_COPY, Boolean.TRUE);
        this.defaults.put(DROPPEDFILEHANDLER_MOVE, Boolean.FALSE);
        this.defaults.put(DROPPEDFILEHANDLER_RENAME, Boolean.FALSE);
        this.defaults.put(IMPORT_ALWAYSUSE, Boolean.FALSE);
        this.defaults.put(IMPORT_DEFAULT_PDF_IMPORT_STYLE, 2);
        this.defaults.put(IMPORT_FILENAMEPATTERN, ImportSettingsTab.DEFAULT_FILENAMEPATTERNS[1]);
        this.customExports = new CustomExportList(new ExportComparator());
        this.customImports = new CustomImportList(this);
        this.MARKING_WITH_NUMBER_PATTERN = "\\[" + this.get(DEFAULT_OWNER).replaceAll("\\\\", "\\\\\\\\") + ":(\\d+)\\]";
        String defaultExpression = "**/.*[bibtexkey].*\\\\.[extension]";
        this.defaults.put(REG_EXP_SEARCH_EXPRESSION_KEY, defaultExpression);
        this.defaults.put(AUTOLINK_USE_REG_EXP_SEARCH_KEY, Boolean.FALSE);
        this.defaults.put(USE_IEEE_ABRV, Boolean.FALSE);
        this.defaults.put(USE_CASE_KEEPER_ON_SEARCH, Boolean.TRUE);
        this.defaults.put(USE_UNIT_FORMATTER_ON_SEARCH, Boolean.TRUE);
        this.defaults.put(USE_DEFAULT_CONSOLE_APPLICATION, Boolean.TRUE);
        if (OS.WINDOWS) {
            this.defaults.put(CONSOLE_COMMAND, "C:\\Program Files\\ConEmu\\ConEmu64.exe /single /dir \"%DIR\"");
        } else {
            this.defaults.put(CONSOLE_COMMAND, "");
        }
        this.defaults.put(VERSION_IGNORED_UPDATE, "");
        this.defaults.put(CYCLE_PREVIEW, "Preview;/ieee.csl");
        this.defaults.put(CYCLE_PREVIEW_POS, 0);
        this.defaults.put(PREVIEW_PANEL_HEIGHT, 200);
        this.defaults.put(PREVIEW_ENABLED, Boolean.TRUE);
        this.defaults.put(PREVIEW_STYLE, "<font face=\"sans-serif\"><b><i>\\bibtextype</i><a name=\"\\bibtexkey\">\\begin{bibtexkey} (\\bibtexkey)</a>\\end{bibtexkey}</b><br>__NEWLINE__\\begin{author} \\format[Authors(LastFirst,Initials,Semicolon,Amp),HTMLChars]{\\author}<BR>\\end{author}__NEWLINE__\\begin{editor} \\format[Authors(LastFirst,Initials,Semicolon,Amp),HTMLChars]{\\editor} <i>(\\format[IfPlural(Eds.,Ed.)]{\\editor})</i><BR>\\end{editor}__NEWLINE__\\begin{title} \\format[HTMLChars]{\\title} \\end{title}<BR>__NEWLINE__\\begin{chapter} \\format[HTMLChars]{\\chapter}<BR>\\end{chapter}__NEWLINE__\\begin{journal} <em>\\format[HTMLChars]{\\journal}, </em>\\end{journal}__NEWLINE__\\begin{booktitle} <em>\\format[HTMLChars]{\\booktitle}, </em>\\end{booktitle}__NEWLINE__\\begin{school} <em>\\format[HTMLChars]{\\school}, </em>\\end{school}__NEWLINE__\\begin{institution} <em>\\format[HTMLChars]{\\institution}, </em>\\end{institution}__NEWLINE__\\begin{publisher} <em>\\format[HTMLChars]{\\publisher}, </em>\\end{publisher}__NEWLINE__\\begin{year}<b>\\year</b>\\end{year}\\begin{volume}<i>, \\volume</i>\\end{volume}\\begin{pages}, \\format[FormatPagesForHTML]{\\pages} \\end{pages}__NEWLINE__\\begin{abstract}<BR><BR><b>Abstract: </b> \\format[HTMLChars]{\\abstract} \\end{abstract}__NEWLINE__\\begin{review}<BR><BR><b>Review: </b> \\format[HTMLChars]{\\review} \\end{review}</dd>__NEWLINE__<p></p></font>");
    }

    public String getUser() {
        try {
            return this.get(DEFAULT_OWNER) + '-' + InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            LOGGER.debug("Hostname not found.", ex);
            return this.get(DEFAULT_OWNER);
        }
    }

    public List<String> getCustomTabFieldNames() {
        String fields;
        ArrayList<String> customFields = new ArrayList<String>();
        int defNumber = 0;
        while ((fields = (String)this.defaults.get("customTabFields__def" + defNumber)) != null && !fields.isEmpty()) {
            customFields.addAll(Arrays.asList(fields.split(";")));
            ++defNumber;
        }
        return customFields;
    }

    public void setLanguageDependentDefaultValues() {
        this.defaults.put("customTabName__def0", Localization.lang("General", new String[0]));
        this.defaults.put("customTabFields__def0", "crossref;keywords;file;doi;url;comment;owner;timestamp");
        this.defaults.put("customTabFields__def1", "abstract");
        this.defaults.put("customTabName__def1", Localization.lang("Abstract", new String[0]));
        this.defaults.put("customTabFields__def2", "review");
        this.defaults.put("customTabName__def2", Localization.lang("Review", new String[0]));
        this.defaults.put(EMAIL_SUBJECT, Localization.lang("References", new String[0]));
    }

    public boolean hasKey(String key) {
        return this.prefs.get(key, null) != null;
    }

    public String get(String key) {
        return this.prefs.get(key, (String)this.defaults.get(key));
    }

    public Optional<String> getAsOptional(String key) {
        return Optional.ofNullable(this.prefs.get(key, (String)this.defaults.get(key)));
    }

    public String get(String key, String def) {
        return this.prefs.get(key, def);
    }

    public boolean getBoolean(String key) {
        return this.prefs.getBoolean(key, this.getBooleanDefault(key));
    }

    public boolean getBoolean(String key, boolean def) {
        return this.prefs.getBoolean(key, def);
    }

    private boolean getBooleanDefault(String key) {
        return (Boolean)this.defaults.get(key);
    }

    public int getInt(String key) {
        return this.prefs.getInt(key, this.getIntDefault(key));
    }

    public int getIntDefault(String key) {
        return (Integer)this.defaults.get(key);
    }

    public void put(String key, String value) {
        this.prefs.put(key, value);
    }

    public void putBoolean(String key, boolean value) {
        this.prefs.putBoolean(key, value);
    }

    public void putInt(String key, int value) {
        this.prefs.putInt(key, value);
    }

    public void remove(String key) {
        this.prefs.remove(key);
    }

    public void putStringList(String key, List<String> value) {
        if (value == null) {
            this.remove(key);
            return;
        }
        this.put(key, JabRefPreferences.convertListToString(value));
    }

    private static String convertListToString(List<String> value) {
        return value.stream().map(val -> StringUtil.quote(val, ";", '\\')).collect(Collectors.joining(";"));
    }

    public List<String> getStringList(String key) {
        String names = this.get(key);
        if (names == null) {
            return new ArrayList<String>();
        }
        StringReader rd = new StringReader(names);
        ArrayList<String> res = new ArrayList<String>();
        try {
            Optional<String> rs;
            while ((rs = JabRefPreferences.getNextUnit(rd)).isPresent()) {
                res.add(rs.get());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return res;
    }

    public Color getColor(String key) {
        String value = this.get(key);
        int[] rgb = JabRefPreferences.getRgb(value);
        return new Color(rgb[0], rgb[1], rgb[2]);
    }

    public Color getDefaultColor(String key) {
        String value = (String)this.defaults.get(key);
        int[] rgb = JabRefPreferences.getRgb(value);
        return new Color(rgb[0], rgb[1], rgb[2]);
    }

    public BibDatabaseMode getDefaultBibDatabaseMode() {
        if (this.getBoolean(BIBLATEX_DEFAULT_MODE)) {
            return BibDatabaseMode.BIBLATEX;
        }
        return BibDatabaseMode.BIBTEX;
    }

    public void putDefaultValue(String key, Object value) {
        this.defaults.put(key, value);
    }

    public void putColor(String key, Color color) {
        String rgb = String.valueOf(color.getRed()) + ':' + color.getGreen() + ':' + color.getBlue();
        this.put(key, rgb);
    }

    private static int[] getRgb(String value) {
        int[] values = new int[3];
        if (value != null && !value.isEmpty()) {
            String[] elements = value.split(":");
            values[0] = Integer.parseInt(elements[0]);
            values[1] = Integer.parseInt(elements[1]);
            values[2] = Integer.parseInt(elements[2]);
        } else {
            values[0] = 0;
            values[1] = 0;
            values[2] = 0;
        }
        return values;
    }

    public void clear() throws BackingStoreException {
        this.prefs.clear();
    }

    public void clear(String key) {
        this.prefs.remove(key);
    }

    public void flush() {
        if (this.getBoolean(MEMORY_STICK_MODE)) {
            try {
                this.exportPreferences("jabref.xml");
            }
            catch (JabRefException e) {
                LOGGER.warn("Could not export preferences for memory stick mode: " + e.getMessage(), e);
            }
        }
        try {
            this.prefs.flush();
        }
        catch (BackingStoreException ex) {
            LOGGER.warn("Can not communicate with backing store", ex);
        }
    }

    public GlobalBibtexKeyPattern getKeyPattern() {
        this.keyPattern = new GlobalBibtexKeyPattern(AbstractBibtexKeyPattern.split(this.get(DEFAULT_BIBTEX_KEY_PATTERN)));
        Preferences pre = Preferences.userNodeForPackage(JabRefMain.class).node(BIBTEX_KEY_PATTERNS_NODE);
        try {
            String[] keys = pre.keys();
            if (keys.length > 0) {
                for (String key : keys) {
                    this.keyPattern.addBibtexKeyPattern(key, pre.get(key, null));
                }
            }
        }
        catch (BackingStoreException ex) {
            LOGGER.info("BackingStoreException in JabRefPreferences.getKeyPattern", ex);
        }
        return this.keyPattern;
    }

    public void putKeyPattern(GlobalBibtexKeyPattern pattern) {
        this.keyPattern = pattern;
        Preferences pre = Preferences.userNodeForPackage(JabRefMain.class).node(BIBTEX_KEY_PATTERNS_NODE);
        try {
            pre.clear();
        }
        catch (BackingStoreException ex) {
            LOGGER.info("BackingStoreException in JabRefPreferences.putKeyPattern", ex);
        }
        Set<String> allKeys = pattern.getAllKeys();
        for (String key : allKeys) {
            if (pattern.isDefaultValue(key)) continue;
            pre.put(key, pattern.getValue(key).get(0));
        }
    }

    public Map<String, Object> getPreferences() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            for (String key : this.prefs.keys()) {
                Object value = this.getObject(key);
                result.put(key, value);
            }
        }
        catch (BackingStoreException e) {
            LOGGER.info("could not retrieve preference keys", e);
        }
        return result;
    }

    private Object getObject(String key) {
        try {
            return this.get(key);
        }
        catch (ClassCastException e) {
            try {
                return this.getBoolean(key);
            }
            catch (ClassCastException e2) {
                return this.getInt(key);
            }
        }
    }

    private static Optional<String> getNextUnit(Reader data) throws IOException {
        int c = -1;
        boolean escape = false;
        boolean done = false;
        StringBuilder res = new StringBuilder();
        while (!done && (c = data.read()) != -1) {
            if (c == 92) {
                if (escape) {
                    escape = false;
                    res.append('\\');
                    continue;
                }
                escape = true;
                continue;
            }
            if (c == 59) {
                if (escape) {
                    res.append(';');
                } else {
                    done = true;
                }
            } else {
                res.append((char)c);
            }
            escape = false;
        }
        if (res.length() > 0) {
            return Optional.of(res.toString());
        }
        if (c == -1) {
            return Optional.empty();
        }
        return Optional.of("");
    }

    public void storeCustomEntryType(CustomEntryType tp, int number) {
        String nr = String.valueOf(number);
        this.put(CUSTOM_TYPE_NAME + nr, tp.getName());
        this.put(CUSTOM_TYPE_REQ + nr, tp.getRequiredFieldsString());
        List<String> optionalFields = tp.getOptionalFields();
        this.putStringList(CUSTOM_TYPE_OPT + nr, optionalFields);
        List<String> primaryOptionalFields = tp.getPrimaryOptionalFields();
        this.putStringList(CUSTOM_TYPE_PRIOPT + nr, primaryOptionalFields);
    }

    public Optional<CustomEntryType> getCustomEntryType(int number) {
        String nr = String.valueOf(number);
        String name = this.get(CUSTOM_TYPE_NAME + nr);
        if (name == null) {
            return Optional.empty();
        }
        List<String> req = this.getStringList(CUSTOM_TYPE_REQ + nr);
        List<String> opt = this.getStringList(CUSTOM_TYPE_OPT + nr);
        List<String> priOpt = this.getStringList(CUSTOM_TYPE_PRIOPT + nr);
        if (priOpt.isEmpty()) {
            return Optional.of(new CustomEntryType(StringUtil.capitalizeFirst(name), req, opt));
        }
        ArrayList<String> secondary = new ArrayList<String>(opt);
        secondary.removeAll(priOpt);
        return Optional.of(new CustomEntryType(StringUtil.capitalizeFirst(name), req, priOpt, secondary));
    }

    public void purgeCustomEntryTypes(int number) {
        this.purgeSeries(CUSTOM_TYPE_NAME, number);
        this.purgeSeries(CUSTOM_TYPE_REQ, number);
        this.purgeSeries(CUSTOM_TYPE_OPT, number);
        this.purgeSeries(CUSTOM_TYPE_PRIOPT, number);
    }

    public void purgeSeries(String prefix, int number) {
        int n = number;
        while (this.get(prefix + n) != null) {
            this.remove(prefix + n);
            ++n;
        }
    }

    public EntryEditorTabList getEntryEditorTabList() {
        if (this.tabList == null) {
            this.updateEntryEditorTabList();
        }
        return this.tabList;
    }

    public void updateEntryEditorTabList() {
        this.tabList = new EntryEditorTabList();
    }

    public void exportPreferences(String filename) throws JabRefException {
        File f = new File(filename);
        try (FileOutputStream os = new FileOutputStream(f);){
            this.prefs.exportSubtree(os);
        }
        catch (IOException | BackingStoreException ex) {
            throw new JabRefException("Could not export preferences", Localization.lang("Could not export preferences", new String[0]), ex);
        }
    }

    public void importPreferences(String filename) throws JabRefException {
        File f = new File(filename);
        try (FileInputStream is = new FileInputStream(f);){
            Preferences.importPreferences(is);
        }
        catch (IOException | InvalidPreferencesFormatException ex) {
            throw new JabRefException("Could not import preferences", Localization.lang("Could not import preferences", new String[0]), ex);
        }
    }

    public void overwritePreferences(JabRefPreferences owPrefs) {
        singleton = owPrefs;
    }

    public String getWrappedUsername() {
        return '[' + this.get(DEFAULT_OWNER) + ']';
    }

    public Charset getDefaultEncoding() {
        return Charset.forName(this.get(DEFAULT_ENCODING));
    }

    public void setDefaultEncoding(Charset encoding) {
        this.put(DEFAULT_ENCODING, encoding.name());
    }

    private static void insertDefaultCleanupPreset(Map<String, Object> storage) {
        EnumSet<CleanupPreset.CleanupStep> deactivedJobs = EnumSet.of(CleanupPreset.CleanupStep.CLEAN_UP_UPGRADE_EXTERNAL_LINKS, CleanupPreset.CleanupStep.RENAME_PDF_ONLY_RELATIVE_PATHS, CleanupPreset.CleanupStep.CONVERT_TO_BIBLATEX);
        CleanupPreset preset = new CleanupPreset(EnumSet.complementOf(deactivedJobs), Cleanups.DEFAULT_SAVE_ACTIONS);
        storage.put(CLEANUP_DOI, preset.isCleanUpDOI());
        storage.put(CLEANUP_ISSN, preset.isCleanUpISSN());
        storage.put(CLEANUP_MOVE_PDF, preset.isMovePDF());
        storage.put(CLEANUP_MAKE_PATHS_RELATIVE, preset.isMakePathsRelative());
        storage.put(CLEANUP_RENAME_PDF, preset.isRenamePDF());
        storage.put(CLEANUP_RENAME_PDF_ONLY_RELATIVE_PATHS, preset.isRenamePdfOnlyRelativePaths());
        storage.put(CLEANUP_UPGRADE_EXTERNAL_LINKS, preset.isCleanUpUpgradeExternalLinks());
        storage.put(CLEANUP_CONVERT_TO_BIBLATEX, preset.isConvertToBiblatex());
        storage.put(CLEANUP_FIX_FILE_LINKS, preset.isFixFileLinks());
        storage.put(CLEANUP_FORMATTERS, JabRefPreferences.convertListToString(preset.getFormatterCleanups().getAsStringList(OS.NEWLINE)));
    }

    public FileHistory getFileHistory() {
        return new FileHistory(this.getStringList(RECENT_DATABASES));
    }

    public void storeFileHistory(FileHistory history) {
        if (!history.isEmpty()) {
            this.putStringList(RECENT_DATABASES, history.getHistory());
        }
    }

    public FileDirectoryPreferences getFileDirectoryPreferences() {
        List<String> fields = Arrays.asList("file", "pdf", "ps");
        HashMap<String, String> fieldDirectories = new HashMap<String, String>();
        fields.stream().forEach(fieldName -> fieldDirectories.put((String)fieldName, this.get(fieldName + "Directory")));
        return new FileDirectoryPreferences(this.getUser(), fieldDirectories, this.getBoolean(BIB_LOC_AS_PRIMARY_DIR));
    }

    public UpdateFieldPreferences getUpdateFieldPreferences() {
        return new UpdateFieldPreferences(this.getBoolean(USE_OWNER), this.getBoolean(OVERWRITE_OWNER), this.get(DEFAULT_OWNER), this.getBoolean(USE_TIME_STAMP), this.getBoolean(OVERWRITE_TIME_STAMP), this.get(TIME_STAMP_FIELD), this.get(TIME_STAMP_FORMAT));
    }

    public LatexFieldFormatterPreferences getLatexFieldFormatterPreferences() {
        return new LatexFieldFormatterPreferences(this.getBoolean(RESOLVE_STRINGS_ALL_FIELDS), this.getStringList(DO_NOT_RESOLVE_STRINGS_FOR), this.getFieldContentParserPreferences());
    }

    public FieldContentParserPreferences getFieldContentParserPreferences() {
        return new FieldContentParserPreferences(this.getStringList(NON_WRAPPABLE_FIELDS));
    }

    public boolean isKeywordSyncEnabled() {
        return this.getBoolean(SPECIALFIELDSENABLED) && this.getBoolean(AUTOSYNCSPECIALFIELDSTOKEYWORDS);
    }

    public ImportFormatPreferences getImportFormatPreferences() {
        return new ImportFormatPreferences(this.customImports, this.getDefaultEncoding(), this.getKeywordDelimiter(), this.getBibtexKeyPatternPreferences(), this.getFieldContentParserPreferences(), this.isKeywordSyncEnabled());
    }

    public BibtexKeyPatternPreferences getBibtexKeyPatternPreferences() {
        return new BibtexKeyPatternPreferences(this.get(KEY_PATTERN_REGEX), this.get(KEY_PATTERN_REPLACEMENT), this.getBoolean(KEY_GEN_ALWAYS_ADD_LETTER), this.getBoolean(KEY_GEN_FIRST_LETTER_A), this.getBoolean(ENFORCE_LEGAL_BIBTEX_KEY), this.getKeyPattern(), this.getKeywordDelimiter());
    }

    public LayoutFormatterPreferences getLayoutFormatterPreferences(JournalAbbreviationLoader journalAbbreviationLoader) {
        Objects.requireNonNull(journalAbbreviationLoader);
        return new LayoutFormatterPreferences(this.getNameFormatterPreferences(), this.getJournalAbbreviationPreferences(), this.getFileLinkPreferences(), journalAbbreviationLoader);
    }

    public XMPPreferences getXMPPreferences() {
        return new XMPPreferences(this.getBoolean(USE_XMP_PRIVACY_FILTER), this.getStringList(XMP_PRIVACY_FILTERS), this.getKeywordDelimiter());
    }

    private NameFormatterPreferences getNameFormatterPreferences() {
        return new NameFormatterPreferences(this.getStringList(NAME_FORMATER_KEY), this.getStringList(NAME_FORMATTER_VALUE));
    }

    public FileLinkPreferences getFileLinkPreferences() {
        return new FileLinkPreferences(Collections.singletonList(this.get("fileDirectory")), this.fileDirForDatabase);
    }

    public JabRefPreferences storeVersionPreferences(VersionPreferences versionPreferences) {
        this.put(VERSION_IGNORED_UPDATE, versionPreferences.getIgnoredVersion().toString());
        return this;
    }

    public VersionPreferences getVersionPreferences() {
        Version ignoredVersion = Version.parse(this.get(VERSION_IGNORED_UPDATE));
        return new VersionPreferences(ignoredVersion);
    }

    public JabRefPreferences storePreviewPreferences(PreviewPreferences previewPreferences) {
        this.putInt(CYCLE_PREVIEW_POS, previewPreferences.getPreviewCyclePosition());
        this.putStringList(CYCLE_PREVIEW, previewPreferences.getPreviewCycle());
        this.putInt(PREVIEW_PANEL_HEIGHT, previewPreferences.getPreviewPanelHeight());
        this.put(PREVIEW_STYLE, previewPreferences.getPreviewStyle());
        this.putBoolean(PREVIEW_ENABLED, previewPreferences.isPreviewPanelEnabled());
        return this;
    }

    public PreviewPreferences getPreviewPreferences() {
        int cyclePos = this.getInt(CYCLE_PREVIEW_POS);
        List<String> cycle = this.getStringList(CYCLE_PREVIEW);
        int panelHeight = this.getInt(PREVIEW_PANEL_HEIGHT);
        String style = this.get(PREVIEW_STYLE);
        String styleDefault = (String)this.defaults.get(PREVIEW_STYLE);
        boolean enabled = this.getBoolean(PREVIEW_ENABLED);
        return new PreviewPreferences(cycle, cyclePos, panelHeight, enabled, style, styleDefault);
    }

    public void storeProxyPreferences(ProxyPreferences proxyPreferences) {
        this.putBoolean(PROXY_USE, proxyPreferences.isUseProxy());
        this.put(PROXY_HOSTNAME, proxyPreferences.getHostname());
        this.put(PROXY_PORT, proxyPreferences.getPort());
        this.putBoolean(PROXY_USE_AUTHENTICATION, proxyPreferences.isUseAuthentication());
        this.put(PROXY_USERNAME, proxyPreferences.getUsername());
        this.put(PROXY_PASSWORD, proxyPreferences.getPassword());
    }

    public ProxyPreferences getProxyPreferences() {
        Boolean useProxy = this.getBoolean(PROXY_USE);
        String hostname = this.get(PROXY_HOSTNAME);
        String port = this.get(PROXY_PORT);
        Boolean useAuthentication = this.getBoolean(PROXY_USE_AUTHENTICATION);
        String username = this.get(PROXY_USERNAME);
        String password = this.get(PROXY_PASSWORD);
        return new ProxyPreferences(useProxy, hostname, port, useAuthentication, username, password);
    }

    public ProtectedTermsPreferences getProtectedTermsPreferences() {
        return new ProtectedTermsPreferences(this.getStringList(PROTECTED_TERMS_ENABLED_INTERNAL), this.getStringList(PROTECTED_TERMS_ENABLED_EXTERNAL), this.getStringList(PROTECTED_TERMS_DISABLED_INTERNAL), this.getStringList(PROTECTED_TERMS_DISABLED_EXTERNAL));
    }

    public JournalAbbreviationPreferences getJournalAbbreviationPreferences() {
        return new JournalAbbreviationPreferences(this.getStringList(EXTERNAL_JOURNAL_LISTS), this.get(PERSONAL_JOURNAL_LIST), this.getBoolean(USE_IEEE_ABRV), this.getDefaultEncoding());
    }

    public void setProtectedTermsPreferences(ProtectedTermsLoader loader) {
        ArrayList<String> enabledExternalList = new ArrayList<String>();
        ArrayList<String> disabledExternalList = new ArrayList<String>();
        ArrayList<String> enabledInternalList = new ArrayList<String>();
        ArrayList<String> disabledInternalList = new ArrayList<String>();
        for (ProtectedTermsList list : loader.getProtectedTermsLists()) {
            if (list.isInternalList()) {
                if (list.isEnabled()) {
                    enabledInternalList.add(list.getLocation());
                    continue;
                }
                disabledInternalList.add(list.getLocation());
                continue;
            }
            if (list.isEnabled()) {
                enabledExternalList.add(list.getLocation());
                continue;
            }
            disabledExternalList.add(list.getLocation());
        }
        this.putStringList(PROTECTED_TERMS_ENABLED_EXTERNAL, enabledExternalList);
        this.putStringList(PROTECTED_TERMS_DISABLED_EXTERNAL, disabledExternalList);
        this.putStringList(PROTECTED_TERMS_ENABLED_INTERNAL, enabledInternalList);
        this.putStringList(PROTECTED_TERMS_DISABLED_INTERNAL, disabledInternalList);
    }

    public CleanupPreferences getCleanupPreferences(JournalAbbreviationLoader journalAbbreviationLoader) {
        return new CleanupPreferences(this.get(IMPORT_FILENAMEPATTERN), this.getLayoutFormatterPreferences(journalAbbreviationLoader), this.getFileDirectoryPreferences());
    }

    public RemotePreferences getRemotePreferences() {
        return new RemotePreferences(this.getInt(REMOTE_SERVER_PORT), this.getBoolean(USE_REMOTE_SERVER));
    }

    public void setRemotePreferences(RemotePreferences remotePreferences) {
        this.putInt(REMOTE_SERVER_PORT, remotePreferences.getPort());
        this.putBoolean(USE_REMOTE_SERVER, remotePreferences.useRemoteServer());
    }

    public void storeExportSaveOrder(SaveOrderConfig config) {
        this.putBoolean(EXPORT_PRIMARY_SORT_DESCENDING, config.sortCriteria[0].descending);
        this.putBoolean(EXPORT_SECONDARY_SORT_DESCENDING, config.sortCriteria[1].descending);
        this.putBoolean(EXPORT_TERTIARY_SORT_DESCENDING, config.sortCriteria[2].descending);
        this.put(EXPORT_PRIMARY_SORT_FIELD, config.sortCriteria[0].field);
        this.put(EXPORT_SECONDARY_SORT_FIELD, config.sortCriteria[1].field);
        this.put(EXPORT_TERTIARY_SORT_FIELD, config.sortCriteria[2].field);
    }

    public SaveOrderConfig loadTableSaveOrder() {
        SaveOrderConfig config = new SaveOrderConfig();
        config.sortCriteria[0].field = this.get(TABLE_PRIMARY_SORT_FIELD);
        config.sortCriteria[0].descending = this.getBoolean(TABLE_PRIMARY_SORT_DESCENDING);
        config.sortCriteria[1].field = this.get(TABLE_SECONDARY_SORT_FIELD);
        config.sortCriteria[1].descending = this.getBoolean(TABLE_SECONDARY_SORT_DESCENDING);
        config.sortCriteria[2].field = this.get(TABLE_TERTIARY_SORT_FIELD);
        config.sortCriteria[2].descending = this.getBoolean(TABLE_TERTIARY_SORT_DESCENDING);
        return config;
    }

    public SaveOrderConfig loadExportSaveOrder() {
        SaveOrderConfig config = new SaveOrderConfig();
        config.sortCriteria[0].field = this.get(EXPORT_PRIMARY_SORT_FIELD);
        config.sortCriteria[0].descending = this.getBoolean(EXPORT_PRIMARY_SORT_DESCENDING);
        config.sortCriteria[1].field = this.get(EXPORT_SECONDARY_SORT_FIELD);
        config.sortCriteria[1].descending = this.getBoolean(EXPORT_SECONDARY_SORT_DESCENDING);
        config.sortCriteria[2].field = this.get(EXPORT_TERTIARY_SORT_FIELD);
        config.sortCriteria[2].descending = this.getBoolean(EXPORT_TERTIARY_SORT_DESCENDING);
        return config;
    }

    public Character getKeywordDelimiter() {
        return Character.valueOf(this.get(KEYWORD_SEPARATOR).charAt(0));
    }
}

