/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.preferences;

import java.util.List;
import java.util.TreeSet;
import net.sf.jabref.Globals;
import net.sf.jabref.logic.importer.fileformat.CustomImporter;
import net.sf.jabref.preferences.JabRefPreferences;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CustomImportList
extends TreeSet<CustomImporter> {
    private final JabRefPreferences prefs;
    private static final Log LOGGER = LogFactory.getLog(CustomImportList.class);

    public CustomImportList(JabRefPreferences prefs) {
        this.prefs = prefs;
        this.readPrefs();
    }

    private void readPrefs() {
        List<String> s;
        int i = 0;
        while (!(s = this.prefs.getStringList("customImportFormat" + i)).isEmpty()) {
            try {
                if (s.size() == 2) {
                    super.add(new CustomImporter(s.get(0), s.get(1)));
                } else {
                    super.add(new CustomImporter(s.get(3), s.get(2)));
                }
            }
            catch (Exception e) {
                LOGGER.warn("Could not load " + s.get(0) + " from preferences. Will ignore.", e);
            }
            ++i;
        }
    }

    private void addImporter(CustomImporter customImporter) {
        super.add(customImporter);
    }

    public boolean replaceImporter(CustomImporter customImporter) {
        boolean wasContained = this.remove(customImporter);
        this.addImporter(customImporter);
        return wasContained;
    }

    public void store() {
        this.purgeAll();
        CustomImporter[] importers = this.toArray(new CustomImporter[this.size()]);
        for (int i = 0; i < importers.length; ++i) {
            Globals.prefs.putStringList("customImportFormat" + i, importers[i].getAsStringList());
        }
    }

    private void purgeAll() {
        int i = 0;
        while (!Globals.prefs.getStringList("customImportFormat" + i).isEmpty()) {
            Globals.prefs.remove("customImportFormat" + i);
            ++i;
        }
    }
}

