/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.pdfimport;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.swing.SwingUtilities;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.BasePanelMode;
import net.sf.jabref.gui.EntryTypeDialog;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.entryeditor.EntryEditor;
import net.sf.jabref.gui.externalfiles.DroppedFileHandler;
import net.sf.jabref.gui.externalfiletype.ExternalFileTypes;
import net.sf.jabref.gui.filelist.FileListEntry;
import net.sf.jabref.gui.filelist.FileListTableModel;
import net.sf.jabref.gui.maintable.MainTable;
import net.sf.jabref.gui.undo.UndoableInsertEntry;
import net.sf.jabref.logic.bibtexkeypattern.BibtexKeyPatternUtil;
import net.sf.jabref.logic.importer.ParserResult;
import net.sf.jabref.logic.importer.fileformat.PdfContentImporter;
import net.sf.jabref.logic.importer.fileformat.PdfXmpImporter;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.util.UpdateField;
import net.sf.jabref.logic.util.io.FileUtil;
import net.sf.jabref.logic.xmp.XMPUtil;
import net.sf.jabref.model.database.KeyCollisionException;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.EntryType;
import net.sf.jabref.model.entry.IdGenerator;
import net.sf.jabref.pdfimport.ImportDialog;
import net.sf.jabref.pdfimport.PdfFileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PdfImporter {
    private final JabRefFrame frame;
    private final BasePanel panel;
    private final MainTable entryTable;
    private final int dropRow;
    private static final Log LOGGER = LogFactory.getLog(PdfImporter.class);

    public PdfImporter(JabRefFrame frame, BasePanel panel, MainTable entryTable, int dropRow) {
        this.frame = frame;
        this.panel = panel;
        this.entryTable = entryTable;
        this.dropRow = dropRow;
    }

    public ImportPdfFilesResult importPdfFiles(List<String> fileNames) {
        ArrayList<String> files = new ArrayList<String>(fileNames);
        ArrayList<String> noPdfFiles = new ArrayList<String>();
        for (String file : files) {
            if (PdfFileFilter.accept(file)) continue;
            noPdfFiles.add(file);
        }
        files.removeAll(noPdfFiles);
        List<BibEntry> entries = this.importPdfFilesInternal(files);
        return new ImportPdfFilesResult(noPdfFiles, entries);
    }

    private List<BibEntry> importPdfFilesInternal(List<String> fileNames) {
        if (this.panel == null) {
            return Collections.emptyList();
        }
        ImportDialog importDialog = null;
        boolean doNotShowAgain = false;
        boolean neverShow = Globals.prefs.getBoolean("importAlwaysUsePDFImportStyle");
        int globalChoice = Globals.prefs.getInt("importDefaultPDFimportStyle");
        ArrayList<BibEntry> res = new ArrayList<BibEntry>();
        for (String fileName : fileNames) {
            if (!neverShow && !doNotShowAgain) {
                importDialog = new ImportDialog(this.dropRow >= 0, fileName);
                if (!XMPUtil.hasMetadata(Paths.get(fileName, new String[0]), Globals.prefs.getXMPPreferences())) {
                    importDialog.disableXMPChoice();
                }
                importDialog.setLocationRelativeTo(this.frame);
                importDialog.showDialog();
                doNotShowAgain = importDialog.isDoNotShowAgain();
            }
            if (!neverShow && importDialog.getResult() != 0) continue;
            int choice = neverShow ? globalChoice : importDialog.getChoice();
            switch (choice) {
                case 1: {
                    this.doXMPImport(fileName, res);
                    break;
                }
                case 2: {
                    this.doContentImport(fileName, res);
                    break;
                }
                case 0: {
                    this.createNewBlankEntry(fileName).ifPresent(res::add);
                    break;
                }
                case 4: {
                    DroppedFileHandler dfh = new DroppedFileHandler(this.frame, this.panel);
                    dfh.linkPdfToEntry(fileName, this.entryTable, this.dropRow);
                    break;
                }
            }
        }
        return res;
    }

    private void doXMPImport(String fileName, List<BibEntry> res) {
        Path filePath;
        ArrayList<BibEntry> localRes = new ArrayList<BibEntry>();
        PdfXmpImporter importer = new PdfXmpImporter(Globals.prefs.getXMPPreferences());
        ParserResult result = importer.importDatabase(filePath = Paths.get(fileName, new String[0]), Globals.prefs.getDefaultEncoding());
        if (result.hasWarnings()) {
            this.frame.showMessage(result.getErrorMessage());
        }
        localRes.addAll(result.getDatabase().getEntries());
        if (localRes.isEmpty()) {
            LOGGER.info("Import failed");
            this.createNewBlankEntry(fileName).ifPresent(res::add);
            return;
        }
        BibEntry entry = (BibEntry)localRes.get(0);
        this.panel.getDatabase().insertEntry(entry);
        this.panel.markBaseChanged();
        FileListTableModel tm = new FileListTableModel();
        File toLink = new File(fileName);
        List<String> dirsS = this.panel.getBibDatabaseContext().getFileDirectory(Globals.prefs.getFileDirectoryPreferences());
        tm.addEntry(0, new FileListEntry(toLink.getName(), FileUtil.shortenFileName(toLink, dirsS).getPath(), ExternalFileTypes.getInstance().getExternalFileTypeByName("PDF")));
        entry.setField("file", tm.getStringRepresentation());
        res.add(entry);
    }

    private Optional<BibEntry> createNewBlankEntry(String fileName) {
        Optional<BibEntry> newEntry = this.createNewEntry();
        newEntry.ifPresent(bibEntry -> {
            DroppedFileHandler dfh = new DroppedFileHandler(this.frame, this.panel);
            dfh.linkPdfToEntry(fileName, (BibEntry)bibEntry);
        });
        return newEntry;
    }

    private void doContentImport(String fileName, List<BibEntry> res) {
        Path filePath;
        PdfContentImporter contentImporter = new PdfContentImporter(Globals.prefs.getImportFormatPreferences());
        ParserResult result = contentImporter.importDatabase(filePath = Paths.get(fileName, new String[0]), Globals.prefs.getDefaultEncoding());
        if (result.hasWarnings()) {
            this.frame.showMessage(result.getErrorMessage());
        }
        if (!result.getDatabase().hasEntries()) {
            this.createNewBlankEntry(fileName).ifPresent(res::add);
            return;
        }
        BibEntry entry = result.getDatabase().getEntries().get(0);
        this.panel.getDatabase().insertEntry(entry);
        this.panel.markBaseChanged();
        BibtexKeyPatternUtil.makeLabel(this.panel.getBibDatabaseContext().getMetaData().getCiteKeyPattern(Globals.prefs.getBibtexKeyPatternPreferences().getKeyPattern()), this.panel.getDatabase(), entry, Globals.prefs.getBibtexKeyPatternPreferences());
        DroppedFileHandler dfh = new DroppedFileHandler(this.frame, this.panel);
        dfh.linkPdfToEntry(fileName, entry);
        this.panel.highlightEntry(entry);
        if (Globals.prefs.getBoolean("autoOpenForm")) {
            EntryEditor editor = this.panel.getEntryEditor(entry);
            this.panel.showEntryEditor(editor);
        }
        res.add(entry);
    }

    private Optional<BibEntry> createNewEntry() {
        EntryTypeDialog etd = new EntryTypeDialog(this.frame);
        etd.setLocationRelativeTo(this.frame);
        etd.setVisible(true);
        EntryType type = etd.getChoice();
        if (type != null) {
            String id = IdGenerator.next();
            BibEntry bibEntry = new BibEntry(id, type.getName());
            try {
                this.panel.getDatabase().insertEntry(bibEntry);
                ArrayList<BibEntry> list = new ArrayList<BibEntry>();
                list.add(bibEntry);
                UpdateField.setAutomaticFields(list, true, true, Globals.prefs.getUpdateFieldPreferences());
                this.panel.getUndoManager().addEdit(new UndoableInsertEntry(this.panel.getDatabase(), bibEntry, this.panel));
                this.panel.output(Localization.lang("Added new", new String[0]) + " '" + type.getName().toLowerCase() + "' " + Localization.lang("entry", new String[0]) + ".");
                if (this.panel.getMode() != BasePanelMode.SHOWING_EDITOR) {
                    this.panel.setMode(BasePanelMode.WILL_SHOW_EDITOR);
                }
                SwingUtilities.invokeLater(() -> this.panel.showEntry(bibEntry));
                this.panel.markBaseChanged();
                return Optional.of(bibEntry);
            }
            catch (KeyCollisionException ex) {
                LOGGER.info("Key collision occurred", ex);
            }
        }
        return Optional.empty();
    }

    public class ImportPdfFilesResult {
        private final List<String> noPdfFiles;
        private final List<BibEntry> entries;

        public ImportPdfFilesResult(List<String> noPdfFiles, List<BibEntry> entries) {
            this.noPdfFiles = noPdfFiles;
            this.entries = entries;
        }

        public List<String> getNoPdfFiles() {
            return this.noPdfFiles;
        }

        public List<BibEntry> getEntries() {
            return this.entries;
        }
    }
}

