/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.model.strings;

import com.google.common.base.CharMatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.model.strings.UnicodeToReadableCharMap;
import org.apache.commons.lang3.StringUtils;

public class StringUtil {
    public static final String SPECIAL_COMMAND_CHARS = "\"`^~'=.|";
    private static final Pattern LINE_BREAKS = Pattern.compile("\\r\\n|\\r|\\n");
    private static final Pattern BRACED_TITLE_CAPITAL_PATTERN = Pattern.compile("\\{[A-Z]+\\}");
    private static final UnicodeToReadableCharMap UNICODE_CHAR_MAP = new UnicodeToReadableCharMap();

    public static String booleanToBinaryString(boolean expression) {
        return expression ? "1" : "0";
    }

    public static String quote(String toQuote, String specials, char quoteChar) {
        if (toQuote == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < toQuote.length(); ++i) {
            char c = toQuote.charAt(i);
            boolean isSpecial = c == quoteChar;
            if (isSpecial |= specials != null && specials.indexOf(c) >= 0) {
                result.append(quoteChar);
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String getPart(String text, int startIndex, boolean terminateOnEndBraceOnly) {
        int index;
        int count = 0;
        StringBuilder part = new StringBuilder();
        for (index = startIndex + 1; index < text.length() && Character.isWhitespace(text.charAt(index)); ++index) {
        }
        while (index < text.length()) {
            char c = text.charAt(index);
            if (!terminateOnEndBraceOnly && count == 0 && Character.isWhitespace(c) || c == '}' && --count < 0) break;
            if (c == '{') {
                ++count;
            }
            part.append(c);
            ++index;
        }
        return part.toString();
    }

    public static String shaveString(String toShave) {
        if (toShave == null || toShave.isEmpty()) {
            return "";
        }
        String shaved = toShave.trim();
        if (StringUtil.isInCurlyBrackets(shaved) || StringUtil.isInCitationMarks(shaved)) {
            return shaved.substring(1, shaved.length() - 1);
        }
        return shaved;
    }

    public static String join(String[] strings, String separator, int from, int to) {
        if (strings.length == 0 || from >= to) {
            return "";
        }
        int updatedFrom = Math.max(from, 0);
        int updatedTo = Math.min(strings.length, to);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = updatedFrom; i < updatedTo - 1; ++i) {
            stringBuilder.append(strings[i]).append(separator);
        }
        return stringBuilder.append(strings[updatedTo - 1]).toString();
    }

    public static String stripBrackets(String toStrip) {
        if (StringUtil.isInSquareBrackets(toStrip)) {
            return toStrip.substring(1, toStrip.length() - 1);
        }
        return toStrip;
    }

    public static String getCorrectFileName(String orgName, String defaultExtension) {
        if (orgName == null) {
            return "";
        }
        if (orgName.toLowerCase().endsWith("." + defaultExtension.toLowerCase())) {
            return orgName;
        }
        int hiddenChar = orgName.indexOf(46, 1);
        if (hiddenChar < 1) {
            return orgName + "." + defaultExtension;
        }
        return orgName;
    }

    public static String wrap(String in, int wrapAmount, String newline) {
        String[] lines = in.split("\n");
        StringBuilder result = new StringBuilder();
        StringUtil.addWrappedLine(result, CharMatcher.WHITESPACE.trimTrailingFrom(lines[0]), wrapAmount, newline);
        for (int i = 1; i < lines.length; ++i) {
            if (lines[i].trim().isEmpty()) {
                result.append(newline);
                result.append('\t');
                continue;
            }
            result.append(newline);
            result.append('\t');
            result.append(newline);
            result.append('\t');
            String line = CharMatcher.WHITESPACE.trimTrailingFrom(lines[i]);
            StringUtil.addWrappedLine(result, line, wrapAmount, newline);
        }
        return result.toString();
    }

    private static void addWrappedLine(StringBuilder result, String line, int wrapAmount, String newline) {
        int current;
        int length = result.length();
        result.append(line);
        while (length < result.length() && (current = result.indexOf(" ", length + wrapAmount)) >= 0 && current < result.length()) {
            result.deleteCharAt(current);
            result.insert(current, newline + "\t");
            length = current + newline.length();
        }
    }

    public static String quoteForHTML(String toQuote) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < toQuote.length(); ++i) {
            result.append("&#").append((int)toQuote.charAt(i)).append(';');
        }
        return result.toString();
    }

    public static String[][] decodeStringDoubleArray(String value) {
        ArrayList newList = new ArrayList();
        StringBuilder sb = new StringBuilder();
        ArrayList<String> thisEntry = new ArrayList<String>();
        boolean escaped = false;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (!escaped && c == '\\') {
                escaped = true;
                continue;
            }
            if (!escaped && c == ':') {
                thisEntry.add(sb.toString());
                sb = new StringBuilder();
            } else if (!escaped && c == ';') {
                thisEntry.add(sb.toString());
                sb = new StringBuilder();
                newList.add(thisEntry);
                thisEntry = new ArrayList();
            } else {
                sb.append(c);
            }
            escaped = false;
        }
        if (sb.length() > 0) {
            thisEntry.add(sb.toString());
        }
        if (!thisEntry.isEmpty()) {
            newList.add(thisEntry);
        }
        String[][] res = new String[newList.size()][];
        for (int i = 0; i < res.length; ++i) {
            res[i] = new String[((List)newList.get(i)).size()];
            for (int j = 0; j < res[i].length; ++j) {
                res[i][j] = (String)((List)newList.get(i)).get(j);
            }
        }
        return res;
    }

    public static String putBracesAroundCapitals(String s) {
        boolean inString = false;
        boolean isBracing = false;
        boolean escaped = false;
        int inBrace = 0;
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '{') {
                ++inBrace;
            } else if (c == '}') {
                --inBrace;
            } else if (!escaped && c == '#') {
                boolean bl = inString = !inString;
            }
            if (inBrace == 0 && !isBracing && !inString && Character.isLetter(c) && Character.isUpperCase(c)) {
                buf.append('{');
                isBracing = true;
            }
            if (!(!isBracing || Character.isLetter(c) && Character.isUpperCase(c))) {
                buf.append('}');
                isBracing = false;
            }
            buf.append(c);
            escaped = c == '\\' && !escaped;
        }
        if (isBracing) {
            buf.append('}');
        }
        return buf.toString();
    }

    public static String removeBracesAroundCapitals(String s) {
        String current = s;
        String previous = s;
        while ((current = StringUtil.removeSingleBracesAroundCapitals(current)).length() < previous.length()) {
            previous = current;
        }
        return current;
    }

    private static String removeSingleBracesAroundCapitals(String s) {
        Matcher mcr = BRACED_TITLE_CAPITAL_PATTERN.matcher(s);
        StringBuffer buf = new StringBuffer();
        while (mcr.find()) {
            String replaceStr = mcr.group();
            mcr.appendReplacement(buf, replaceStr.substring(1, replaceStr.length() - 1));
        }
        mcr.appendTail(buf);
        return buf.toString();
    }

    public static String unifyLineBreaks(String s, String newline) {
        return LINE_BREAKS.matcher(s).replaceAll(newline);
    }

    public static boolean isInCurlyBrackets(String toCheck) {
        int count = 0;
        int brackets = 0;
        if (toCheck == null || toCheck.isEmpty()) {
            return false;
        }
        if (toCheck.charAt(0) == '{' && toCheck.charAt(toCheck.length() - 1) == '}') {
            for (char c : toCheck.toCharArray()) {
                if (c == '{') {
                    if (brackets == 0) {
                        ++count;
                    }
                    ++brackets;
                    continue;
                }
                if (c != '}') continue;
                --brackets;
            }
            return count == 1;
        }
        return false;
    }

    public static boolean isInSquareBrackets(String toCheck) {
        if (toCheck == null || toCheck.isEmpty()) {
            return false;
        }
        return toCheck.charAt(0) == '[' && toCheck.charAt(toCheck.length() - 1) == ']';
    }

    public static boolean isInCitationMarks(String toCheck) {
        if (toCheck == null || toCheck.length() <= 1) {
            return false;
        }
        return toCheck.charAt(0) == '\"' && toCheck.charAt(toCheck.length() - 1) == '\"';
    }

    public static int intValueOf(String str) {
        char ch;
        int end;
        boolean sign;
        int idx;
        block7: {
            block6: {
                idx = 0;
                sign = false;
                if (str == null || (end = str.length()) == 0) break block6;
                ch = str.charAt(0);
                if (ch >= '0' && ch <= '9') break block7;
                boolean bl = sign = ch == '-';
                if (bl && ++idx != end && (ch = str.charAt(idx)) >= '0' && ch <= '9') break block7;
            }
            throw new NumberFormatException(str);
        }
        int ival = 0;
        while (true) {
            ival += 48 - ch;
            if (++idx == end) {
                return sign ? ival : -ival;
            }
            ch = str.charAt(idx);
            if (ch < '0' || ch > '9') {
                throw new NumberFormatException(str);
            }
            ival *= 10;
        }
    }

    public static Optional<Integer> intValueOfOptional(String str) {
        char ch;
        int end;
        boolean sign;
        int idx;
        block7: {
            block6: {
                idx = 0;
                sign = false;
                if (str == null || (end = str.length()) == 0) break block6;
                ch = str.charAt(0);
                if (ch >= '0' && ch <= '9') break block7;
                boolean bl = sign = ch == '-';
                if (bl && ++idx != end && (ch = str.charAt(idx)) >= '0' && ch <= '9') break block7;
            }
            return Optional.empty();
        }
        int ival = 0;
        while (true) {
            ival += 48 - ch;
            if (++idx == end) {
                return Optional.of(sign ? ival : -ival);
            }
            ch = str.charAt(idx);
            if (ch < '0' || ch > '9') {
                return Optional.empty();
            }
            ival *= 10;
        }
    }

    public static String stripNonValidXMLCharacters(String in) {
        if (in == null || in.isEmpty()) {
            return "";
        }
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < in.length(); ++i) {
            char current = in.charAt(i);
            if (current != '\t' && current != '\n' && current != '\r' && (current < ' ' || current > '\ud7ff') && (current < '\ue000' || current > '\ufffd')) continue;
            out.append(current);
        }
        return out.toString();
    }

    public static List<String> tokenizeToList(String buf, String delimstr) {
        ArrayList<String> list = new ArrayList<String>();
        String buffer = buf + '\n';
        StringTokenizer st = new StringTokenizer(buffer, delimstr);
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return list;
    }

    public static String limitStringLength(String s, int maxLength) {
        if (s == null) {
            return "";
        }
        if (s.length() <= maxLength) {
            return s;
        }
        return s.substring(0, maxLength - 3) + "...";
    }

    public static String replaceSpecialCharacters(String s) {
        String result = s;
        for (Map.Entry chrAndReplace : UNICODE_CHAR_MAP.entrySet()) {
            result = result.replace((CharSequence)chrAndReplace.getKey(), (CharSequence)chrAndReplace.getValue());
        }
        return result;
    }

    public static String repeatSpaces(int n) {
        return StringUtil.repeat(n, ' ');
    }

    public static String repeat(int n, char c) {
        StringBuilder resultSB = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            resultSB.append(c);
        }
        return resultSB.toString();
    }

    public static boolean isNullOrEmpty(String toTest) {
        return toTest == null || toTest.isEmpty();
    }

    public static boolean isBlank(String string) {
        return !StringUtil.isNotBlank(string);
    }

    public static boolean isBlank(Optional<String> string) {
        return !StringUtil.isNotBlank(string);
    }

    public static boolean isNotBlank(String string) {
        return StringUtils.isNotBlank(string);
    }

    public static boolean isNotBlank(Optional<String> string) {
        return string.isPresent() && StringUtil.isNotBlank(string.get());
    }

    public static String boldHTML(String input) {
        return "<b>" + input + "</b>";
    }

    public static String boldHTML(String input, String alternative) {
        if (input == null) {
            return "<b>" + alternative + "</b>";
        }
        return "<b>" + input + "</b>";
    }

    public static String unquote(String toUnquote, char quoteChar) {
        StringBuilder result = new StringBuilder();
        boolean quoted = false;
        for (int i = 0; i < toUnquote.length(); ++i) {
            char c = toUnquote.charAt(i);
            if (quoted) {
                if (c != '\n') {
                    result.append(c);
                }
                quoted = false;
                continue;
            }
            if (c == quoteChar) {
                quoted = true;
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String stripAccents(String searchQuery) {
        return StringUtils.stripAccents(searchQuery);
    }

    public static String capitalizeFirst(String toCapitalize) {
        if (toCapitalize.length() > 1) {
            return toCapitalize.substring(0, 1).toUpperCase() + toCapitalize.substring(1, toCapitalize.length()).toLowerCase();
        }
        return toCapitalize.toUpperCase();
    }

    public static List<String> getStringAsWords(String text) {
        return Arrays.asList(text.split("[\\s,;]+"));
    }
}

