/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.model.strings;

import java.util.Map;
import java.util.regex.Pattern;
import net.sf.jabref.model.strings.HTMLUnicodeConversionMaps;
import net.sf.jabref.model.strings.StringUtil;

public class LatexToUnicode {
    private static final Map<String, String> CHARS = HTMLUnicodeConversionMaps.LATEX_UNICODE_CONVERSION_MAP;
    private static final Map<String, String> ACCENTS = HTMLUnicodeConversionMaps.UNICODE_ESCAPED_ACCENTS;
    private static final Pattern AMP_LATEX = Pattern.compile("&|\\\\&");
    private static final Pattern P_LATEX = Pattern.compile("[\\n]{1,}");
    private static final Pattern DOLLAR_LATEX = Pattern.compile("\\\\\\$");
    private static final Pattern DOLLARS_LATEX = Pattern.compile("\\$([^\\$]*)\\$");
    private static final Pattern AMP = Pattern.compile("\\&amp;");
    private static final Pattern P = Pattern.compile("<p>");
    private static final Pattern DOLLAR = Pattern.compile("\\&dollar;");
    private static final Pattern TILDE = Pattern.compile("~");

    public String format(String inField) {
        if (inField.isEmpty()) {
            return "";
        }
        String field = AMP_LATEX.matcher(inField).replaceAll("&amp;");
        field = P_LATEX.matcher(field).replaceAll("<p>");
        field = DOLLAR_LATEX.matcher(field).replaceAll("&dollar;");
        field = DOLLARS_LATEX.matcher(field).replaceAll("\\{$1\\}");
        StringBuilder sb = new StringBuilder();
        StringBuilder currentCommand = null;
        boolean escaped = false;
        boolean incommand = false;
        for (int i = 0; i < field.length(); ++i) {
            String accent;
            String result;
            String result2;
            String command;
            char c = field.charAt(i);
            if (escaped && c == '\\') {
                sb.append('\\');
                escaped = false;
                continue;
            }
            if (c == '\\') {
                if (incommand) {
                    command = currentCommand.toString();
                    result2 = CHARS.get(command);
                    if (result2 == null) {
                        sb.append(command);
                    } else {
                        sb.append(result2);
                    }
                }
                escaped = true;
                incommand = true;
                currentCommand = new StringBuilder();
                continue;
            }
            if (!incommand && (c == '{' || c == '}')) continue;
            if (Character.isLetter(c) || c == '%' || "\"`^~'=.|".contains(String.valueOf(c))) {
                escaped = false;
                if (!incommand) {
                    sb.append(c);
                    continue;
                }
                currentCommand.append(c);
                if (currentCommand.length() == 1 && "\"`^~'=.|".contains(currentCommand.toString()) && i < field.length() - 1) {
                    String commandBody;
                    command = currentCommand.toString();
                    if ((c = field.charAt(++i)) == '{') {
                        String part = StringUtil.getPart(field, i, false);
                        i += part.length();
                        commandBody = part;
                    } else {
                        commandBody = field.substring(i, i + 1);
                    }
                    result = CHARS.get(command + commandBody);
                    if (result == null) {
                        if (commandBody.length() <= 1) {
                            accent = ACCENTS.get(command);
                            if (accent == null) {
                                sb.append(commandBody);
                            } else {
                                sb.append(commandBody).append(accent);
                            }
                        }
                    } else {
                        sb.append(result);
                    }
                    incommand = false;
                    escaped = false;
                    continue;
                }
                if (i + 1 != field.length()) continue;
                command = currentCommand.toString();
                result2 = CHARS.get(command);
                if (result2 == null) {
                    sb.append(command);
                    continue;
                }
                sb.append(result2);
                continue;
            }
            if (!incommand) {
                sb.append(c);
            } else if (Character.isWhitespace(c) || c == '{' || c == '}') {
                command = currentCommand.toString();
                if (c == '{') {
                    String argument = StringUtil.getPart(field, i, true);
                    i += argument.length();
                    result = CHARS.get(command + argument);
                    if (result == null) {
                        if (argument.length() <= 1) {
                            accent = ACCENTS.get(command);
                            if (accent == null) {
                                if (argument.isEmpty()) {
                                    sb.append(command);
                                } else {
                                    sb.append(argument);
                                }
                            } else {
                                sb.append(argument).append(accent);
                            }
                        } else {
                            sb.append(argument);
                        }
                    } else {
                        sb.append(result);
                    }
                } else if (c == '}') {
                    result2 = CHARS.get(command);
                    if (result2 == null) {
                        sb.append(command);
                    } else {
                        sb.append(result2);
                    }
                } else {
                    result2 = CHARS.get(command);
                    if (result2 == null) {
                        sb.append(command);
                    } else {
                        sb.append(result2);
                    }
                    sb.append(' ');
                }
            }
            incommand = false;
            escaped = false;
        }
        String result = AMP.matcher(sb.toString()).replaceAll("&");
        result = P.matcher(result).replaceAll("\n");
        result = DOLLAR.matcher(result).replaceAll("\\$");
        result = TILDE.matcher(result).replaceAll("\u00a0");
        return result;
    }
}

