/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.model.search.rules;

import net.sf.jabref.model.search.rules.ContainBasedSearchRule;
import net.sf.jabref.model.search.rules.GrammarBasedSearchRule;
import net.sf.jabref.model.search.rules.RegexBasedSearchRule;
import net.sf.jabref.model.search.rules.SearchRule;
import net.sf.jabref.model.strings.StringUtil;

public class SearchRules {
    public static SearchRule getSearchRuleByQuery(String query, boolean caseSensitive, boolean regex) {
        if (StringUtil.isBlank(query)) {
            return new ContainBasedSearchRule(caseSensitive);
        }
        GrammarBasedSearchRule searchExpression = new GrammarBasedSearchRule(caseSensitive, regex);
        if (searchExpression.validateSearchStrings(query)) {
            return searchExpression;
        }
        return SearchRules.getSearchRule(caseSensitive, regex);
    }

    private static SearchRule getSearchRule(boolean caseSensitive, boolean regex) {
        if (regex) {
            return new RegexBasedSearchRule(caseSensitive);
        }
        return new ContainBasedSearchRule(caseSensitive);
    }
}

