/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.model.search.rules;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.search.rules.SearchRule;

public class RegexBasedSearchRule
implements SearchRule {
    private final boolean caseSensitive;

    public RegexBasedSearchRule(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    @Override
    public boolean validateSearchStrings(String query) {
        String searchString = query;
        if (!this.caseSensitive) {
            searchString = searchString.toLowerCase();
        }
        try {
            Pattern.compile(searchString, this.caseSensitive ? 0 : 2);
        }
        catch (PatternSyntaxException ex) {
            return false;
        }
        return true;
    }

    @Override
    public boolean applyRule(String query, BibEntry bibEntry) {
        Pattern pattern;
        try {
            pattern = Pattern.compile(query, this.caseSensitive ? 0 : 2);
        }
        catch (PatternSyntaxException ex) {
            return false;
        }
        for (String field : bibEntry.getFieldNames()) {
            String fieldContentNoBrackets;
            Matcher m;
            Optional<String> fieldOptional = bibEntry.getField(field);
            if (!fieldOptional.isPresent() || !(m = pattern.matcher(fieldContentNoBrackets = bibEntry.getLatexFreeField(field).get())).find()) continue;
            return true;
        }
        return false;
    }
}

