/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.model.search.rules;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.Keyword;
import net.sf.jabref.model.search.rules.ContainBasedSearchRule;
import net.sf.jabref.model.search.rules.SearchRule;
import net.sf.jabref.search.SearchBaseVisitor;
import net.sf.jabref.search.SearchLexer;
import net.sf.jabref.search.SearchParser;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GrammarBasedSearchRule
implements SearchRule {
    private static final Log LOGGER = LogFactory.getLog(GrammarBasedSearchRule.class);
    private final boolean caseSensitiveSearch;
    private final boolean regExpSearch;
    private ParseTree tree;
    private String query;

    public GrammarBasedSearchRule(boolean caseSensitiveSearch, boolean regExpSearch) throws RecognitionException {
        this.caseSensitiveSearch = caseSensitiveSearch;
        this.regExpSearch = regExpSearch;
    }

    public static boolean isValid(boolean caseSensitive, boolean regExp, String query) {
        return new GrammarBasedSearchRule(caseSensitive, regExp).validateSearchStrings(query);
    }

    public boolean isCaseSensitiveSearch() {
        return this.caseSensitiveSearch;
    }

    public boolean isRegExpSearch() {
        return this.regExpSearch;
    }

    public ParseTree getTree() {
        return this.tree;
    }

    public String getQuery() {
        return this.query;
    }

    private void init(String query) throws ParseCancellationException {
        if (Objects.equals(this.query, query)) {
            return;
        }
        SearchLexer lexer = new SearchLexer(new ANTLRInputStream(query));
        lexer.removeErrorListeners();
        lexer.addErrorListener(ThrowingErrorListener.INSTANCE);
        SearchParser parser = new SearchParser(new CommonTokenStream(lexer));
        parser.removeErrorListeners();
        parser.addErrorListener(ThrowingErrorListener.INSTANCE);
        parser.setErrorHandler(new BailErrorStrategy());
        this.tree = parser.start();
        this.query = query;
    }

    @Override
    public boolean applyRule(String query, BibEntry bibEntry) {
        try {
            return (Boolean)new BibtexSearchVisitor(this.caseSensitiveSearch, this.regExpSearch, bibEntry).visit(this.tree);
        }
        catch (Exception e) {
            LOGGER.debug("Search failed", e);
            return false;
        }
    }

    @Override
    public boolean validateSearchStrings(String query) {
        try {
            this.init(query);
            return true;
        }
        catch (ParseCancellationException e) {
            LOGGER.debug("Search query invalid", e);
            return false;
        }
    }

    static class BibtexSearchVisitor
    extends SearchBaseVisitor<Boolean> {
        private final boolean caseSensitive;
        private final boolean regex;
        private final BibEntry entry;

        public BibtexSearchVisitor(boolean caseSensitive, boolean regex, BibEntry bibEntry) {
            this.caseSensitive = caseSensitive;
            this.regex = regex;
            this.entry = bibEntry;
        }

        public boolean comparison(String field, ComparisonOperator operator, String value) {
            return new Comparator(field, value, operator, this.caseSensitive, this.regex).compare(this.entry);
        }

        @Override
        public Boolean visitStart(SearchParser.StartContext ctx) {
            return (Boolean)this.visit(ctx.expression());
        }

        @Override
        public Boolean visitComparison(SearchParser.ComparisonContext context) {
            Optional<SearchParser.NameContext> fieldDescriptor;
            String right = context.right.getText();
            if (right.startsWith("\"") && right.endsWith("\"")) {
                right = right.substring(1, right.length() - 1);
            }
            if ((fieldDescriptor = Optional.ofNullable(context.left)).isPresent()) {
                return this.comparison(fieldDescriptor.get().getText(), ComparisonOperator.build(context.operator.getText()), right);
            }
            return new ContainBasedSearchRule(this.caseSensitive).applyRule(right, this.entry);
        }

        @Override
        public Boolean visitUnaryExpression(SearchParser.UnaryExpressionContext ctx) {
            return (Boolean)this.visit(ctx.expression()) == false;
        }

        @Override
        public Boolean visitParenExpression(SearchParser.ParenExpressionContext ctx) {
            return (Boolean)this.visit(ctx.expression());
        }

        @Override
        public Boolean visitBinaryExpression(SearchParser.BinaryExpressionContext ctx) {
            if ("AND".equalsIgnoreCase(ctx.operator.getText())) {
                return (Boolean)this.visit(ctx.left) != false && (Boolean)this.visit(ctx.right) != false;
            }
            return (Boolean)this.visit(ctx.left) != false || (Boolean)this.visit(ctx.right) != false;
        }
    }

    public static class Comparator {
        private final ComparisonOperator operator;
        private final Pattern fieldPattern;
        private final Pattern valuePattern;

        public Comparator(String field, String value, ComparisonOperator operator, boolean caseSensitive, boolean regex) {
            this.operator = operator;
            int option = caseSensitive ? 0 : 2;
            this.fieldPattern = Pattern.compile(regex ? field : "\\Q" + field + "\\E", option);
            this.valuePattern = Pattern.compile(regex ? value : "\\Q" + value + "\\E", option);
        }

        public boolean compare(BibEntry entry) {
            if (this.fieldPattern.matcher("entrytype").matches()) {
                return this.matchFieldValue(entry.getType());
            }
            if (this.fieldPattern.matcher("anykeyword").matches()) {
                return entry.getKeywords(Character.valueOf(',')).stream().map(Keyword::toString).anyMatch(this::matchFieldValue);
            }
            Set<String> fieldsKeys = entry.getFieldNames();
            if (!this.fieldPattern.matcher("anyfield").matches()) {
                fieldsKeys = fieldsKeys.stream().filter(this.matchFieldKey()).collect(Collectors.toSet());
            }
            for (String field : fieldsKeys) {
                Optional<String> fieldValue = entry.getLatexFreeField(field);
                if (!fieldValue.isPresent() || !this.matchFieldValue(fieldValue.get())) continue;
                return true;
            }
            return fieldsKeys.isEmpty() && this.operator == ComparisonOperator.DOES_NOT_CONTAIN;
        }

        private Predicate<String> matchFieldKey() {
            return s -> this.fieldPattern.matcher((CharSequence)s).matches();
        }

        public boolean matchFieldValue(String content) {
            Matcher matcher = this.valuePattern.matcher(content);
            if (this.operator == ComparisonOperator.CONTAINS) {
                return matcher.find();
            }
            if (this.operator == ComparisonOperator.EXACT) {
                return matcher.matches();
            }
            if (this.operator == ComparisonOperator.DOES_NOT_CONTAIN) {
                return !matcher.find();
            }
            throw new IllegalStateException("MUST NOT HAPPEN");
        }
    }

    public static enum ComparisonOperator {
        EXACT,
        CONTAINS,
        DOES_NOT_CONTAIN;


        public static ComparisonOperator build(String value) {
            if ("CONTAINS".equalsIgnoreCase(value) || "=".equals(value)) {
                return CONTAINS;
            }
            if ("MATCHES".equalsIgnoreCase(value) || "==".equals(value)) {
                return EXACT;
            }
            return DOES_NOT_CONTAIN;
        }
    }

    public static class ThrowingErrorListener
    extends BaseErrorListener {
        public static final ThrowingErrorListener INSTANCE = new ThrowingErrorListener();

        @Override
        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) throws ParseCancellationException {
            throw new ParseCancellationException("line " + line + ":" + charPositionInLine + " " + msg);
        }
    }
}

