/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.model.groups;

import java.util.List;
import java.util.Optional;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.groups.AbstractGroup;
import net.sf.jabref.model.groups.EntriesGroupChange;
import net.sf.jabref.model.groups.GroupHierarchyType;
import net.sf.jabref.model.search.GroupSearchQuery;
import net.sf.jabref.model.search.rules.SearchRule;
import net.sf.jabref.model.strings.StringUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SearchGroup
extends AbstractGroup {
    public static final String ID = "SearchGroup:";
    private final GroupSearchQuery query;
    private static final Log LOGGER = LogFactory.getLog(SearchGroup.class);
    private final String searchExpression;
    private final boolean caseSensitive;
    private final boolean regExp;

    public SearchGroup(String name, String searchExpression, boolean caseSensitive, boolean regExp, GroupHierarchyType context) {
        super(name, context);
        this.searchExpression = searchExpression;
        this.caseSensitive = caseSensitive;
        this.regExp = regExp;
        this.query = new GroupSearchQuery(searchExpression, caseSensitive, regExp);
    }

    @Override
    public String getTypeId() {
        return ID;
    }

    public String toString() {
        return ID + StringUtil.quote(this.getName(), ";", '\\') + ";" + this.getContext().ordinal() + ";" + StringUtil.quote(this.getSearchExpression(), ";", '\\') + ";" + StringUtil.booleanToBinaryString(this.isCaseSensitive()) + ";" + StringUtil.booleanToBinaryString(this.isRegExp()) + ";";
    }

    public String getSearchExpression() {
        return this.searchExpression;
    }

    @Override
    public boolean supportsAdd() {
        return false;
    }

    @Override
    public boolean supportsRemove() {
        return false;
    }

    @Override
    public Optional<EntriesGroupChange> add(List<BibEntry> entriesToAdd) {
        throw new UnsupportedOperationException("Search group does not support adding entries.");
    }

    @Override
    public Optional<EntriesGroupChange> remove(List<BibEntry> entriesToRemove) {
        throw new UnsupportedOperationException("Search group does not support removing entries.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SearchGroup)) {
            return false;
        }
        SearchGroup other = (SearchGroup)o;
        return this.getName().equals(other.getName()) && this.getSearchExpression().equals(other.getSearchExpression()) && this.isCaseSensitive() == other.isCaseSensitive() && this.isRegExp() == other.isRegExp() && this.getHierarchicalContext() == other.getHierarchicalContext();
    }

    @Override
    public boolean contains(BibEntry entry) {
        return this.query.isMatch(entry);
    }

    @Override
    public AbstractGroup deepCopy() {
        try {
            return new SearchGroup(this.getName(), this.getSearchExpression(), this.isCaseSensitive(), this.isRegExp(), this.getHierarchicalContext());
        }
        catch (Throwable t) {
            LOGGER.error("Internal error in SearchGroup.deepCopy(). Please report this on https://github.com/JabRef/jabref/issues", t);
            return null;
        }
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isRegExp() {
        return this.regExp;
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public SearchRule getSearchRule() {
        return this.query.getRule();
    }
}

