/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.model.groups;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.jabref.model.FieldChange;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.KeywordList;
import net.sf.jabref.model.groups.AbstractGroup;
import net.sf.jabref.model.groups.EntriesGroupChange;
import net.sf.jabref.model.groups.GroupHierarchyType;
import net.sf.jabref.model.strings.StringUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KeywordGroup
extends AbstractGroup {
    public static final String ID = "KeywordGroup:";
    private final String searchField;
    private final String searchExpression;
    private final boolean caseSensitive;
    private final boolean regExp;
    private Pattern pattern;
    private final List<String> searchWords;
    protected final Character keywordSeparator;
    private static final Log LOGGER = LogFactory.getLog(KeywordGroup.class);

    public KeywordGroup(String name, String searchField, String searchExpression, boolean caseSensitive, boolean regExp, GroupHierarchyType context, Character keywordSeparator) {
        super(name, context);
        this.searchField = searchField;
        this.searchExpression = searchExpression;
        this.caseSensitive = caseSensitive;
        this.regExp = regExp;
        if (this.regExp) {
            this.compilePattern();
        }
        this.keywordSeparator = keywordSeparator;
        this.searchWords = StringUtil.getStringAsWords(searchExpression);
    }

    private void compilePattern() throws IllegalArgumentException {
        try {
            this.pattern = this.caseSensitive ? Pattern.compile("\\b" + this.searchExpression + "\\b") : Pattern.compile("\\b" + this.searchExpression + "\\b", 2);
        }
        catch (PatternSyntaxException exception) {
            throw new IllegalArgumentException("Syntax error in regular-expression pattern: " + this.searchExpression);
        }
    }

    public String toString() {
        return ID + StringUtil.quote(this.getName(), ";", '\\') + ";" + this.getContext().ordinal() + ";" + StringUtil.quote(this.searchField, ";", '\\') + ";" + StringUtil.quote(this.searchExpression, ";", '\\') + ";" + StringUtil.booleanToBinaryString(this.caseSensitive) + ";" + StringUtil.booleanToBinaryString(this.regExp) + ";";
    }

    @Override
    public boolean supportsAdd() {
        return !this.regExp;
    }

    @Override
    public boolean supportsRemove() {
        return !this.regExp;
    }

    @Override
    public Optional<EntriesGroupChange> add(List<BibEntry> entriesToAdd) {
        if (!this.supportsAdd()) {
            return Optional.empty();
        }
        if (entriesToAdd != null && !entriesToAdd.isEmpty()) {
            ArrayList<FieldChange> changes = new ArrayList<FieldChange>();
            boolean modified = false;
            for (BibEntry entry : entriesToAdd) {
                if (this.contains(entry)) continue;
                String oldContent = entry.getField(this.searchField).orElse(null);
                KeywordList wordlist = KeywordList.parse(oldContent, this.keywordSeparator);
                wordlist.add(this.searchExpression);
                String newContent = wordlist.getAsString(this.keywordSeparator);
                entry.setField(this.searchField, newContent);
                changes.add(new FieldChange(entry, this.searchField, oldContent, newContent));
                modified = true;
            }
            return modified ? Optional.of(new EntriesGroupChange(changes)) : Optional.empty();
        }
        return Optional.empty();
    }

    @Override
    public Optional<EntriesGroupChange> remove(List<BibEntry> entriesToRemove) {
        if (!this.supportsRemove()) {
            return Optional.empty();
        }
        if (entriesToRemove != null && !entriesToRemove.isEmpty()) {
            ArrayList<FieldChange> changes = new ArrayList<FieldChange>();
            boolean modified = false;
            for (BibEntry entry : entriesToRemove) {
                if (!this.contains(entry)) continue;
                String oldContent = entry.getField(this.searchField).orElse(null);
                this.removeMatches(entry);
                changes.add(new FieldChange(entry, this.searchField, oldContent, entry.getField(this.searchField).orElse(null)));
                modified = true;
            }
            return modified ? Optional.of(new EntriesGroupChange(changes)) : Optional.empty();
        }
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeywordGroup)) {
            return false;
        }
        KeywordGroup other = (KeywordGroup)o;
        return this.getName().equals(other.getName()) && this.searchField.equals(other.searchField) && this.searchExpression.equals(other.searchExpression) && this.caseSensitive == other.caseSensitive && this.regExp == other.regExp && this.getHierarchicalContext() == other.getHierarchicalContext();
    }

    @Override
    public boolean contains(BibEntry entry) {
        if (this.regExp) {
            Optional<String> content = entry.getField(this.searchField);
            return content.map(value -> this.pattern.matcher((CharSequence)value).find()).orElse(false);
        }
        Set<String> words = entry.getFieldAsWords(this.searchField);
        if (words.isEmpty()) {
            return false;
        }
        if (this.caseSensitive) {
            return words.containsAll(this.searchWords);
        }
        return this.containsCaseInsensitive(this.searchWords, words);
    }

    private boolean containsCaseInsensitive(List<String> searchText, Set<String> words) {
        for (String searchWord : searchText) {
            if (this.containsCaseInsensitive(searchWord, words)) continue;
            return false;
        }
        return true;
    }

    private boolean containsCaseInsensitive(String text, Set<String> words) {
        for (String word : words) {
            if (!word.equalsIgnoreCase(text)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsWord(String word, String text) {
        int piv = 0;
        while (piv < text.length()) {
            int index = text.indexOf(word, piv);
            if (index < 0) {
                return false;
            }
            if (!(index != 0 && Character.isLetterOrDigit(text.charAt(index - 1)) || index + word.length() != text.length() && Character.isLetterOrDigit(text.charAt(index + word.length())))) {
                return true;
            }
            piv = index + 1;
        }
        return false;
    }

    private void removeMatches(BibEntry entry) {
        entry.getField(this.searchField).ifPresent(content -> {
            int i;
            String needle;
            StringBuffer sbOrig = new StringBuffer((String)content);
            StringBuffer sbLower = new StringBuffer(content.toLowerCase());
            StringBuffer haystack = this.caseSensitive ? sbOrig : sbLower;
            String string = needle = this.caseSensitive ? this.searchExpression : this.searchExpression.toLowerCase();
            while ((i = haystack.indexOf(needle)) >= 0) {
                sbOrig.replace(i, i + needle.length(), "");
                sbLower.replace(i, i + needle.length(), "");
                int j = i;
                int k = i;
                while (j - 1 >= 0 && this.keywordSeparator.toString().indexOf(haystack.charAt(j - 1)) >= 0) {
                    --j;
                }
                while (k < haystack.length() && this.keywordSeparator.toString().indexOf(haystack.charAt(k)) >= 0) {
                    ++k;
                }
                sbOrig.replace(j, k, j >= 0 && k < sbOrig.length() ? this.keywordSeparator.toString() : "");
                sbLower.replace(j, k, j >= 0 && k < sbOrig.length() ? this.keywordSeparator.toString() : "");
            }
            String result = sbOrig.toString().trim();
            if (result.isEmpty()) {
                entry.clearField(this.searchField);
            } else {
                entry.setField(this.searchField, result);
            }
        });
    }

    @Override
    public AbstractGroup deepCopy() {
        return new KeywordGroup(this.getName(), this.searchField, this.searchExpression, this.caseSensitive, this.regExp, this.getContext(), this.keywordSeparator);
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isRegExp() {
        return this.regExp;
    }

    public String getSearchExpression() {
        return this.searchExpression;
    }

    public String getSearchField() {
        return this.searchField;
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public String getTypeId() {
        return ID;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

