/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.model.groups;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.stream.Collectors;
import net.sf.jabref.model.database.BibDatabase;
import net.sf.jabref.model.entry.Author;
import net.sf.jabref.model.entry.AuthorList;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.strings.StringUtil;

public class GroupsUtil {
    public static Set<String> findDeliminatedWordsInField(BibDatabase db, String field, String deliminator) {
        TreeSet<String> res = new TreeSet<String>();
        for (BibEntry be : db.getEntries()) {
            be.getField(field).ifPresent(fieldValue -> {
                StringTokenizer tok = new StringTokenizer(fieldValue.trim(), deliminator);
                while (tok.hasMoreTokens()) {
                    res.add(StringUtil.capitalizeFirst(tok.nextToken().trim()));
                }
            });
        }
        return res;
    }

    public static Set<String> findAllWordsInField(BibDatabase db, String field, String remove) {
        TreeSet<String> res = new TreeSet<String>();
        for (BibEntry be : db.getEntries()) {
            be.getField(field).ifPresent(o -> {
                StringTokenizer tok = new StringTokenizer((String)o, remove, false);
                while (tok.hasMoreTokens()) {
                    res.add(StringUtil.capitalizeFirst(tok.nextToken().trim()));
                }
            });
        }
        return res;
    }

    public static Set<String> findAuthorLastNames(BibDatabase db, List<String> fields) {
        TreeSet<String> res = new TreeSet<String>();
        for (BibEntry be : db.getEntries()) {
            for (String field : fields) {
                be.getField(field).ifPresent(val -> {
                    if (!val.isEmpty()) {
                        AuthorList al = AuthorList.parse(val);
                        res.addAll(al.getAuthors().stream().map(Author::getLast).filter(Optional::isPresent).map(Optional::get).filter(lastName -> !lastName.isEmpty()).collect(Collectors.toList()));
                    }
                });
            }
        }
        return res;
    }
}

