/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.model.groups;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.sf.jabref.model.database.BibDatabase;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.groups.AbstractGroup;
import net.sf.jabref.model.groups.EntriesGroupChange;
import net.sf.jabref.model.groups.ExplicitGroup;
import net.sf.jabref.model.groups.GroupHierarchyType;
import net.sf.jabref.model.groups.TreeNode;
import net.sf.jabref.model.search.SearchMatcher;
import net.sf.jabref.model.search.matchers.MatcherSet;
import net.sf.jabref.model.search.matchers.MatcherSets;

public class GroupTreeNode
extends TreeNode<GroupTreeNode> {
    private AbstractGroup group;

    public GroupTreeNode(AbstractGroup group) {
        super(GroupTreeNode.class);
        this.setGroup(group);
    }

    public static GroupTreeNode fromGroup(AbstractGroup group) {
        return new GroupTreeNode(group);
    }

    public AbstractGroup getGroup() {
        return this.group;
    }

    @Deprecated
    public void setGroup(AbstractGroup newGroup) {
        this.group = Objects.requireNonNull(newGroup);
    }

    public Optional<EntriesGroupChange> setGroup(AbstractGroup newGroup, boolean shouldKeepPreviousAssignments, List<BibEntry> entriesInDatabase) {
        AbstractGroup oldGroup = this.getGroup();
        this.setGroup(newGroup);
        if (shouldKeepPreviousAssignments && newGroup.supportsAdd()) {
            List<BibEntry> entriesMatchedByOldGroup = entriesInDatabase.stream().filter(oldGroup::isMatch).collect(Collectors.toList());
            if (oldGroup instanceof ExplicitGroup && newGroup instanceof ExplicitGroup) {
                oldGroup.remove(entriesMatchedByOldGroup);
            }
            return newGroup.add(entriesMatchedByOldGroup);
        }
        return Optional.empty();
    }

    public List<String> getTreeAsString() {
        ArrayList<String> representation = new ArrayList<String>();
        representation.add(this.toString());
        for (GroupTreeNode child : this.getChildren()) {
            representation.addAll(child.getTreeAsString());
        }
        return representation;
    }

    @Deprecated
    public void refreshGroupsForNewDatabase(BibDatabase db) {
        for (GroupTreeNode node : this.getChildren()) {
            node.group.refreshForNewDatabase(db);
            node.refreshGroupsForNewDatabase(db);
        }
    }

    public SearchMatcher getSearchRule() {
        return this.getSearchRule(this.group.getHierarchicalContext());
    }

    private SearchMatcher getSearchRule(GroupHierarchyType originalContext) {
        GroupHierarchyType context = this.group.getHierarchicalContext();
        if (context == GroupHierarchyType.INDEPENDENT) {
            return this.group;
        }
        MatcherSet searchRule = MatcherSets.build(context == GroupHierarchyType.REFINING ? MatcherSets.MatcherType.AND : MatcherSets.MatcherType.OR);
        searchRule.addRule(this.group);
        if (context == GroupHierarchyType.INCLUDING && originalContext != GroupHierarchyType.REFINING) {
            for (GroupTreeNode child : this.getChildren()) {
                searchRule.addRule(child.getSearchRule(originalContext));
            }
        } else if (context == GroupHierarchyType.REFINING && !this.isRoot() && originalContext != GroupHierarchyType.INCLUDING) {
            searchRule.addRule(((GroupTreeNode)this.getParent().get()).getSearchRule(originalContext));
        }
        return searchRule;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupTreeNode that = (GroupTreeNode)o;
        return Objects.equals(this.group, that.group);
    }

    public int hashCode() {
        return Objects.hash(this.group);
    }

    public List<GroupTreeNode> getContainingGroups(List<BibEntry> entries, boolean requireAll) {
        ArrayList<GroupTreeNode> groups = new ArrayList<GroupTreeNode>();
        if (requireAll) {
            if (this.group.containsAll(entries)) {
                groups.add(this);
            }
        } else if (this.group.containsAny(entries)) {
            groups.add(this);
        }
        for (GroupTreeNode child : this.getChildren()) {
            groups.addAll(child.getContainingGroups(entries, requireAll));
        }
        return groups;
    }

    public List<GroupTreeNode> getMatchingGroups(List<BibEntry> entries) {
        ArrayList<GroupTreeNode> groups = new ArrayList<GroupTreeNode>();
        SearchMatcher matcher = this.getSearchRule();
        for (BibEntry entry : entries) {
            if (!matcher.isMatch(entry)) continue;
            groups.add(this);
            break;
        }
        for (GroupTreeNode child : this.getChildren()) {
            groups.addAll(child.getMatchingGroups(entries));
        }
        return groups;
    }

    public boolean supportsAddingEntries() {
        return this.group.supportsAdd();
    }

    public String getName() {
        return this.group.getName();
    }

    public GroupTreeNode addSubgroup(AbstractGroup subgroup) {
        GroupTreeNode child = GroupTreeNode.fromGroup(subgroup);
        this.addChild(child);
        return child;
    }

    public String toString() {
        return String.valueOf(this.getLevel()) + ' ' + this.group.toString();
    }

    @Override
    public GroupTreeNode copyNode() {
        return GroupTreeNode.fromGroup(this.group);
    }

    public int numberOfHits(List<BibEntry> entries) {
        int hits = 0;
        SearchMatcher matcher = this.getSearchRule();
        for (BibEntry entry : entries) {
            if (!matcher.isMatch(entry)) continue;
            ++hits;
        }
        return hits;
    }
}

