/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.model.groups;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import net.sf.jabref.model.groups.AbstractGroup;
import net.sf.jabref.model.groups.GroupHierarchyType;
import net.sf.jabref.model.groups.KeywordGroup;
import net.sf.jabref.model.strings.StringUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExplicitGroup
extends KeywordGroup {
    public static final String ID = "ExplicitGroup:";
    private final List<String> legacyEntryKeys = new ArrayList<String>();
    private static final Log LOGGER = LogFactory.getLog(ExplicitGroup.class);

    public ExplicitGroup(String name, GroupHierarchyType context, Character keywordSeparator) {
        super(name, "groups", name, true, false, context, keywordSeparator);
    }

    public void addLegacyEntryKey(String key) {
        this.legacyEntryKeys.add(key);
    }

    @Override
    public AbstractGroup deepCopy() {
        ExplicitGroup copy = new ExplicitGroup(this.getName(), this.getContext(), this.keywordSeparator);
        copy.legacyEntryKeys.addAll(this.legacyEntryKeys);
        return copy;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExplicitGroup)) {
            return false;
        }
        ExplicitGroup other = (ExplicitGroup)o;
        return Objects.equals(this.getName(), other.getName()) && Objects.equals((Object)this.getHierarchicalContext(), (Object)other.getHierarchicalContext()) && Objects.equals(this.getLegacyEntryKeys(), other.getLegacyEntryKeys());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ID).append(StringUtil.quote(this.getName(), ";", '\\')).append(";").append(this.getContext().ordinal()).append(";");
        TreeSet<String> sortedKeys = new TreeSet<String>();
        sortedKeys.addAll(this.legacyEntryKeys);
        for (String sortedKey : sortedKeys) {
            sb.append(StringUtil.quote(sortedKey, ";", '\\')).append(";");
        }
        return sb.toString();
    }

    public void clearLegacyEntryKeys() {
        this.legacyEntryKeys.clear();
    }

    public List<String> getLegacyEntryKeys() {
        return this.legacyEntryKeys;
    }

    @Override
    public String getTypeId() {
        return ID;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean isDynamic() {
        return false;
    }
}

