/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.model.groups;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.sf.jabref.model.database.BibDatabase;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.groups.EntriesGroupChange;
import net.sf.jabref.model.groups.GroupHierarchyType;
import net.sf.jabref.model.search.SearchMatcher;

public abstract class AbstractGroup
implements SearchMatcher {
    public static final char QUOTE_CHAR = '\\';
    public static final String SEPARATOR = ";";
    private String name;
    private GroupHierarchyType context = GroupHierarchyType.INDEPENDENT;

    protected AbstractGroup(String name, GroupHierarchyType context) {
        this.name = name;
        this.setHierarchicalContext(context);
    }

    public GroupHierarchyType getContext() {
        return this.context;
    }

    public abstract String getTypeId();

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public abstract boolean supportsAdd();

    public abstract boolean supportsRemove();

    public abstract Optional<EntriesGroupChange> add(List<BibEntry> var1);

    public Optional<EntriesGroupChange> add(BibEntry entryToAdd) {
        return this.add(Collections.singletonList(entryToAdd));
    }

    public abstract Optional<EntriesGroupChange> remove(List<BibEntry> var1);

    public abstract boolean contains(BibEntry var1);

    @Override
    public boolean isMatch(BibEntry entry) {
        return this.contains(entry);
    }

    public boolean containsAny(List<BibEntry> entries) {
        for (BibEntry entry : entries) {
            if (!this.contains(entry)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(List<BibEntry> entries) {
        for (BibEntry entry : entries) {
            if (this.contains(entry)) continue;
            return false;
        }
        return true;
    }

    public abstract boolean isDynamic();

    public GroupHierarchyType getHierarchicalContext() {
        return this.context;
    }

    public void setHierarchicalContext(GroupHierarchyType context) {
        if (context == null) {
            return;
        }
        this.context = context;
    }

    public abstract AbstractGroup deepCopy();

    public void refreshForNewDatabase(BibDatabase db) {
    }
}

