/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.model.entry.event;

import net.sf.jabref.model.FieldChange;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.event.EntryChangedEvent;
import net.sf.jabref.model.entry.event.EntryEventSource;

public class FieldChangedEvent
extends EntryChangedEvent {
    private final String fieldName;
    private final String newValue;
    private final String oldValue;

    public FieldChangedEvent(BibEntry bibEntry, String fieldName, String newValue, String oldValue, EntryEventSource location) {
        super(bibEntry, location);
        this.fieldName = fieldName;
        this.newValue = newValue;
        this.oldValue = oldValue;
    }

    public FieldChangedEvent(BibEntry bibEntry, String fieldName, String newValue, String oldValue) {
        super(bibEntry);
        this.fieldName = fieldName;
        this.newValue = newValue;
        this.oldValue = oldValue;
    }

    public FieldChangedEvent(FieldChange fieldChange, EntryEventSource location) {
        super(fieldChange.getEntry(), location);
        this.fieldName = fieldChange.getField();
        this.newValue = fieldChange.getNewValue();
        this.oldValue = fieldChange.getOldValue();
    }

    public FieldChangedEvent(FieldChange fieldChange) {
        this(fieldChange, EntryEventSource.LOCAL);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getNewValue() {
        return this.newValue;
    }

    public String getOldValue() {
        return this.oldValue;
    }
}

