/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.model.entry;

import java.util.Objects;
import java.util.Optional;
import net.sf.jabref.model.database.BibDatabase;
import net.sf.jabref.model.entry.BibEntry;

public class ParsedEntryLink {
    private String key;
    private Optional<BibEntry> linkedEntry;
    private BibDatabase dataBase;

    public ParsedEntryLink(String key, BibDatabase dataBase) {
        this.key = key;
        this.linkedEntry = dataBase.getEntryByKey(this.key);
        this.dataBase = dataBase;
    }

    public ParsedEntryLink(BibEntry bibEntry) {
        this.key = bibEntry.getCiteKeyOptional().orElse("");
        this.linkedEntry = Optional.of(bibEntry);
    }

    public String getKey() {
        return this.key;
    }

    public Optional<BibEntry> getLinkedEntry() {
        return this.linkedEntry;
    }

    public void setKey(String newKey) {
        this.key = newKey;
        this.linkedEntry = this.getDataBase().getEntryByKey(this.key);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.linkedEntry);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ParsedEntryLink)) {
            return false;
        }
        ParsedEntryLink other = (ParsedEntryLink)obj;
        return Objects.equals(this.key, other.key) && Objects.equals(this.linkedEntry, other.linkedEntry);
    }

    public BibDatabase getDataBase() {
        return this.dataBase;
    }
}

