/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.model.entry;

import java.util.Arrays;
import java.util.List;

public class MonthUtil {
    private static final Month NULL_OBJECT = new UnknownMonth();
    private static final List<Month> MONTHS = Arrays.asList(new Month("January", "jan", "01", "#jan#", 1, 0), new Month("February", "feb", "02", "#feb#", 2, 1), new Month("March", "mar", "03", "#mar#", 3, 2), new Month("April", "apr", "04", "#apr#", 4, 3), new Month("May", "may", "05", "#may#", 5, 4), new Month("June", "jun", "06", "#jun#", 6, 5), new Month("July", "jul", "07", "#jul#", 7, 6), new Month("August", "aug", "08", "#aug#", 8, 7), new Month("September", "sep", "09", "#sep#", 9, 8), new Month("October", "oct", "10", "#oct#", 10, 9), new Month("November", "nov", "11", "#nov#", 11, 10), new Month("December", "dec", "12", "#dec#", 12, 11));

    public static Month getMonthByNumber(int number) {
        return MonthUtil.getMonthByIndex(number - 1);
    }

    public static Month getMonthByIndex(int index) {
        for (Month month : MONTHS) {
            if (month.index != index) continue;
            return month;
        }
        return NULL_OBJECT;
    }

    public static Month getMonthByShortName(String shortName) {
        for (Month month : MONTHS) {
            if (!month.shortName.equalsIgnoreCase(shortName)) continue;
            return month;
        }
        return NULL_OBJECT;
    }

    public static Month getMonth(String value) {
        Month month;
        if (value == null) {
            return NULL_OBJECT;
        }
        String testString = value.replace("#", "").trim();
        if (testString.length() > 3) {
            testString = testString.substring(0, 3);
        }
        if ((month = MonthUtil.getMonthByShortName(testString)).isValid()) {
            return month;
        }
        try {
            int number = Integer.parseInt(value);
            return MonthUtil.getMonthByNumber(number);
        }
        catch (NumberFormatException e) {
            return NULL_OBJECT;
        }
    }

    private static class UnknownMonth
    extends Month {
        public UnknownMonth() {
            super(null, null, null, null, 0, -1);
        }

        @Override
        public boolean isValid() {
            return false;
        }
    }

    public static class Month {
        public final String fullName;
        public final String shortName;
        public final String twoDigitNumber;
        public final String bibtexFormat;
        public final int number;
        public final int index;

        public Month(String fullName, String shortName, String twoDigitNumber, String bibtexFormat, int number, int index) {
            this.fullName = fullName;
            this.shortName = shortName;
            this.twoDigitNumber = twoDigitNumber;
            this.bibtexFormat = bibtexFormat;
            this.number = number;
            this.index = index;
        }

        public boolean isValid() {
            return true;
        }
    }
}

