/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.model.entry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sf.jabref.model.entry.Keyword;
import net.sf.jabref.model.strings.StringUtil;

public class KeywordList
implements Iterable<Keyword> {
    private final List<Keyword> keywords = new ArrayList<Keyword>();

    public KeywordList() {
    }

    public KeywordList(Collection<Keyword> keywords) {
        keywords.forEach(this::add);
    }

    public KeywordList(List<String> keywords) {
        this(keywords.stream().map(Keyword::new).collect(Collectors.toList()));
    }

    public KeywordList(String ... keywords) {
        this(Arrays.stream(keywords).map(Keyword::new).collect(Collectors.toList()));
    }

    public static KeywordList parse(String keywordString, Character delimiter) {
        if (StringUtil.isBlank(keywordString)) {
            return new KeywordList();
        }
        ArrayList<String> keywords = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(keywordString, delimiter.toString());
        while (tok.hasMoreTokens()) {
            String word = tok.nextToken().trim();
            keywords.add(word);
        }
        return new KeywordList((List<String>)keywords);
    }

    public KeywordList createClone() {
        return new KeywordList((Collection<Keyword>)this.keywords);
    }

    public void replaceAll(KeywordList keywordsToReplace, Keyword newValue) {
        Objects.requireNonNull(newValue);
        int foundPosition = -1;
        for (Keyword specialFieldKeyword : keywordsToReplace) {
            int pos = this.keywords.indexOf(specialFieldKeyword);
            if (pos < 0) continue;
            foundPosition = pos;
            this.keywords.remove(pos);
        }
        if (foundPosition == -1) {
            this.add(newValue);
        } else {
            this.keywords.add(foundPosition, newValue);
        }
    }

    public void removeAll(KeywordList keywordsToRemove) {
        this.keywords.removeAll(keywordsToRemove.keywords);
    }

    @Deprecated
    public void replaceKeywords(KeywordList keywordsToReplace, Optional<Keyword> newValue) {
        if (newValue.isPresent()) {
            this.replaceAll(keywordsToReplace, newValue.get());
        } else {
            this.removeAll(keywordsToReplace);
        }
    }

    public boolean add(Keyword keyword) {
        if (this.contains(keyword)) {
            return false;
        }
        return this.keywords.add(keyword);
    }

    public String getAsString(Character delimiter) {
        return this.keywords.stream().map(Keyword::toString).collect(Collectors.joining(delimiter + " "));
    }

    public void add(String keywordsString) {
        this.add(new Keyword(keywordsString));
    }

    @Override
    public Iterator<Keyword> iterator() {
        return this.keywords.iterator();
    }

    public int size() {
        return this.keywords.size();
    }

    public boolean isEmpty() {
        return this.keywords.isEmpty();
    }

    public boolean contains(Object o) {
        return this.keywords.contains(o);
    }

    public boolean remove(Object o) {
        return this.keywords.remove(o);
    }

    public void addAll(KeywordList keywordsToAdd) {
        this.keywords.addAll(keywordsToAdd.keywords);
    }

    public void retainAll(KeywordList keywordToRetain) {
        this.keywords.retainAll(keywordToRetain.keywords);
    }

    public void clear() {
        this.keywords.clear();
    }

    public Keyword get(int index) {
        return this.keywords.get(index);
    }

    public Stream<Keyword> stream() {
        return this.keywords.stream();
    }

    public String toString() {
        return this.getAsString(Character.valueOf(','));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeywordList keywords1 = (KeywordList)o;
        return Objects.equals(this.keywords, keywords1.keywords);
    }

    public int hashCode() {
        return Objects.hash(this.keywords);
    }
}

