/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.model.entry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.sf.jabref.model.entry.BibtexSingleField;
import net.sf.jabref.model.entry.FieldProperty;
import net.sf.jabref.model.entry.specialfields.SpecialField;

public class InternalBibtexFields {
    private final Map<String, BibtexSingleField> fieldSet = new HashMap<String, BibtexSingleField>();
    private String timeStampField;
    private static final List<String> INTEGER_FIELDS = Arrays.asList("ctlmax_names_forced_etal", "ctlnames_show_etal", "ctlalt_stretch_factor", "volumes", "pmid");
    private static final List<String> IEEETRANBSTCTL_YES_NO_FIELDS = Arrays.asList("ctluse_article_number", "ctluse_paper", "ctluse_url", "ctluse_forced_etal", "ctluse_alt_spacing", "ctldash_repeated_names");
    private static final List<String> BIBLATEX_DATE_FIELDS = Arrays.asList("date", "eventdate", "origdate", "urldate");
    private static final List<String> BIBLATEX_PERSON_NAME_FIELDS = Arrays.asList("author", "editor", "editora", "editorb", "editorc", "translator", "annotator", "commentator", "introduction", "foreword", "afterword", "bookauthor", "holder", "shortauthor", "shorteditor", "sortname", "nameaddon", "assignee");
    private static final List<String> BIBLATEX_EDITOR_TYPE_FIELDS = Arrays.asList("editortype", "editoratype", "editorbtype", "editorctype");
    private static final List<String> BIBLATEX_PAGINATION_FIELDS = Arrays.asList("pagination", "bookpagination");
    private static final List<String> BIBLATEX_JOURNAL_NAME_FIELDS = Arrays.asList("journal", "journaltitle", "journalsubtitle");
    private static final List<String> BIBLATEX_BOOK_NAME_FIELDS = Arrays.asList("booktitle", "maintitle", "mainsubtitle", "maintitleaddon", "booksubtitle", "booktitleaddon");
    private static final List<String> BIBLATEX_LANGUAGE_FIELDS = Arrays.asList("language", "origlanguage");
    private static final List<String> BIBLATEX_MULTI_KEY_FIELDS = Arrays.asList("related", "entryset");
    private static final List<String> VERBATIM_FIELDS = Arrays.asList("url", "file", "ctlname_format_string", "ctlname_latex_cmd", "ctlname_url_prefix");
    private static final List<String> SPECIAL_FIELDS = Arrays.asList(SpecialField.PRINTED.getFieldName(), SpecialField.PRIORITY.getFieldName(), SpecialField.QUALITY.getFieldName(), SpecialField.RANKING.getFieldName(), SpecialField.READ_STATUS.getFieldName(), SpecialField.RELEVANCE.getFieldName());
    private static InternalBibtexFields RUNTIME = new InternalBibtexFields("timestamp");

    private InternalBibtexFields(String timeStampFieldName) {
        BibtexSingleField field;
        this.add(new BibtexSingleField("address", true, 0.3));
        this.add(new BibtexSingleField("annote", true, 1.5));
        this.add(new BibtexSingleField("author", true, 0.5, 280));
        this.add(new BibtexSingleField("booktitle", true, 175));
        this.add(new BibtexSingleField("chapter", true, 0.3));
        BibtexSingleField dummy = new BibtexSingleField("crossref", true, 0.3);
        dummy.setExtras(EnumSet.of(FieldProperty.CROSSREF, FieldProperty.SINGLE_ENTRY_LINK));
        this.add(dummy);
        this.add(new BibtexSingleField("edition", true, 0.3));
        this.add(new BibtexSingleField("editor", true, 0.5, 280));
        dummy = new BibtexSingleField("eprint", true, 0.3);
        dummy.setExtras(EnumSet.of(FieldProperty.EPRINT));
        this.add(dummy);
        this.add(new BibtexSingleField("howpublished", true, 0.5));
        this.add(new BibtexSingleField("institution", true, 0.5));
        dummy = new BibtexSingleField("isbn", true, 0.3);
        dummy.setExtras(EnumSet.of(FieldProperty.ISBN));
        this.add(dummy);
        this.add(new BibtexSingleField("issn", true, 0.3));
        dummy = new BibtexSingleField("journal", true, 0.3);
        dummy.setExtras(EnumSet.of(FieldProperty.JOURNAL_NAME));
        this.add(dummy);
        dummy = new BibtexSingleField("journaltitle", true, 0.3);
        dummy.setExtras(EnumSet.of(FieldProperty.JOURNAL_NAME));
        this.add(dummy);
        this.add(new BibtexSingleField("key", true));
        dummy = new BibtexSingleField("month", true, 0.3);
        dummy.setExtras(EnumSet.of(FieldProperty.MONTH));
        this.add(dummy);
        this.add(new BibtexSingleField("note", true, 0.5));
        this.add(new BibtexSingleField("number", true, 0.3, 60).setNumeric(true));
        this.add(new BibtexSingleField("organization", true, 0.5));
        this.add(new BibtexSingleField("pages", true, 0.3));
        this.add(new BibtexSingleField("publisher", true, 0.5));
        this.add(new BibtexSingleField("school", true, 0.5));
        this.add(new BibtexSingleField("series", true, 0.3));
        this.add(new BibtexSingleField("title", true, 400));
        dummy = new BibtexSingleField("type", true, 0.3);
        dummy.getFieldProperties().add(FieldProperty.TYPE);
        this.add(dummy);
        this.add(new BibtexSingleField("language", true, 0.3));
        this.add(new BibtexSingleField("volume", true, 0.3, 60).setNumeric(true));
        this.add(new BibtexSingleField("year", true, 0.3, 60).setNumeric(true));
        for (String fieldName : SPECIAL_FIELDS) {
            dummy = new BibtexSingleField(fieldName, false);
            dummy.setPrivate();
            dummy.setWriteable(false);
            dummy.setDisplayable(false);
            this.add(dummy);
        }
        dummy = new BibtexSingleField("bibtexkey", true);
        dummy.setPrivate();
        this.add(dummy);
        dummy = new BibtexSingleField("doi", true, 0.3);
        dummy.setExtras(EnumSet.of(FieldProperty.DOI));
        this.add(dummy);
        this.add(new BibtexSingleField("eid", true, 0.3));
        dummy = new BibtexSingleField("date", true);
        dummy.setExtras(EnumSet.of(FieldProperty.DATE));
        this.add(dummy);
        this.add(new BibtexSingleField("pmid", false, 0.3, 60).setNumeric(true));
        this.add(new BibtexSingleField("location", false));
        this.add(new BibtexSingleField("abstract", false, 1.5, 400));
        dummy = new BibtexSingleField("url", false, 0.3);
        dummy.setExtras(EnumSet.of(FieldProperty.EXTERNAL, FieldProperty.VERBATIM));
        this.add(dummy);
        this.add(new BibtexSingleField("comment", false, 0.5));
        this.add(new BibtexSingleField("keywords", false, 0.3));
        dummy = new BibtexSingleField("file", false);
        dummy.setExtras(EnumSet.of(FieldProperty.FILE_EDITOR, FieldProperty.VERBATIM));
        this.add(dummy);
        dummy = new BibtexSingleField("related", false);
        dummy.setExtras(EnumSet.of(FieldProperty.MULTIPLE_ENTRY_LINK));
        this.add(dummy);
        dummy = new BibtexSingleField("gender", true, 0.3);
        dummy.getFieldProperties().add(FieldProperty.GENDER);
        this.add(dummy);
        dummy = new BibtexSingleField("pubstate", true, 0.3);
        dummy.getFieldProperties().add(FieldProperty.PUBLICATION_STATE);
        this.add(dummy);
        dummy = new BibtexSingleField("#", false, 32);
        dummy.setPrivate();
        dummy.setWriteable(false);
        dummy.setDisplayable(false);
        this.add(dummy);
        dummy = new BibtexSingleField("owner", false, 0.3);
        dummy.setExtras(EnumSet.of(FieldProperty.OWNER));
        dummy.setPrivate();
        this.add(dummy);
        this.timeStampField = timeStampFieldName;
        dummy = new BibtexSingleField(timeStampFieldName, false, 0.3);
        dummy.setExtras(EnumSet.of(FieldProperty.DATE));
        dummy.setPrivate();
        this.add(dummy);
        dummy = new BibtexSingleField("entrytype", false, 75);
        dummy.setPrivate();
        this.add(dummy);
        dummy = new BibtexSingleField("__search", false);
        dummy.setPrivate();
        dummy.setWriteable(false);
        dummy.setDisplayable(false);
        this.add(dummy);
        dummy = new BibtexSingleField("__groupsearch", false);
        dummy.setPrivate();
        dummy.setWriteable(false);
        dummy.setDisplayable(false);
        this.add(dummy);
        dummy = new BibtexSingleField("__markedentry", false);
        dummy.setPrivate();
        dummy.setWriteable(true);
        dummy.setDisplayable(false);
        this.add(dummy);
        for (String yesNoField : IEEETRANBSTCTL_YES_NO_FIELDS) {
            dummy = new BibtexSingleField(yesNoField, false);
            dummy.setExtras(EnumSet.of(FieldProperty.YES_NO));
            this.add(dummy);
        }
        for (String numericField : INTEGER_FIELDS) {
            field = this.fieldSet.get(numericField);
            if (field == null) {
                field = new BibtexSingleField(numericField, true, 0.3).setNumeric(true);
            }
            field.getFieldProperties().add(FieldProperty.INTEGER);
            this.add(field);
        }
        for (String fieldText : VERBATIM_FIELDS) {
            field = this.fieldSet.get(fieldText);
            if (field == null) {
                field = new BibtexSingleField(fieldText, true, 0.3);
            }
            field.getFieldProperties().add(FieldProperty.VERBATIM);
            this.add(field);
        }
        for (String fieldText : BIBLATEX_PERSON_NAME_FIELDS) {
            field = this.fieldSet.get(fieldText);
            if (field == null) {
                field = new BibtexSingleField(fieldText, true, 0.3);
            }
            field.getFieldProperties().add(FieldProperty.PERSON_NAMES);
            this.add(field);
        }
        for (String fieldText : BIBLATEX_EDITOR_TYPE_FIELDS) {
            field = this.fieldSet.get(fieldText);
            if (field == null) {
                field = new BibtexSingleField(fieldText, true, 0.3);
            }
            field.getFieldProperties().add(FieldProperty.EDITOR_TYPE);
            this.add(field);
        }
        for (String fieldText : BIBLATEX_PAGINATION_FIELDS) {
            field = this.fieldSet.get(fieldText);
            if (field == null) {
                field = new BibtexSingleField(fieldText, true, 0.3);
            }
            field.getFieldProperties().add(FieldProperty.PAGINATION);
            this.add(field);
        }
        for (String fieldText : BIBLATEX_DATE_FIELDS) {
            field = this.fieldSet.get(fieldText);
            if (field == null) {
                field = new BibtexSingleField(fieldText, true, 0.3);
            }
            field.getFieldProperties().add(FieldProperty.DATE);
            field.getFieldProperties().add(FieldProperty.ISO_DATE);
            this.add(field);
        }
        for (String fieldText : BIBLATEX_JOURNAL_NAME_FIELDS) {
            field = this.fieldSet.get(fieldText);
            if (field == null) {
                field = new BibtexSingleField(fieldText, true, 0.3);
            }
            field.getFieldProperties().add(FieldProperty.JOURNAL_NAME);
            this.add(field);
        }
        for (String fieldText : BIBLATEX_BOOK_NAME_FIELDS) {
            field = this.fieldSet.get(fieldText);
            if (field == null) {
                field = new BibtexSingleField(fieldText, true, 0.3);
            }
            field.getFieldProperties().add(FieldProperty.BOOK_NAME);
            this.add(field);
        }
        for (String fieldText : BIBLATEX_LANGUAGE_FIELDS) {
            field = this.fieldSet.get(fieldText);
            if (field == null) {
                field = new BibtexSingleField(fieldText, true, 0.3);
            }
            field.getFieldProperties().add(FieldProperty.LANGUAGE);
            this.add(field);
        }
        for (String fieldText : BIBLATEX_MULTI_KEY_FIELDS) {
            field = this.fieldSet.get(fieldText);
            if (field == null) {
                field = new BibtexSingleField(fieldText, true, 0.3);
            }
            field.getFieldProperties().add(FieldProperty.MULTIPLE_ENTRY_LINK);
            this.add(field);
        }
    }

    public static void updateTimeStampField(String timeStampFieldName) {
        InternalBibtexFields.getField(InternalBibtexFields.RUNTIME.timeStampField).ifPresent(field -> {
            field.setName(timeStampFieldName);
            InternalBibtexFields.RUNTIME.timeStampField = timeStampFieldName;
        });
    }

    public static void updateSpecialFields(boolean serializeSpecialFields) {
        for (String fieldName : SPECIAL_FIELDS) {
            InternalBibtexFields.getField(fieldName).ifPresent(field -> {
                if (serializeSpecialFields) {
                    field.setPublic();
                } else {
                    field.setPrivate();
                }
                field.setWriteable(serializeSpecialFields);
                field.setDisplayable(serializeSpecialFields);
            });
        }
    }

    public static void setNumericFields(List<String> numFields) {
        BibtexSingleField field;
        if (numFields.isEmpty()) {
            return;
        }
        HashSet<String> nF = new HashSet<String>();
        nF.addAll(numFields);
        for (String fieldName : InternalBibtexFields.RUNTIME.fieldSet.keySet()) {
            field = InternalBibtexFields.RUNTIME.fieldSet.get(fieldName);
            if (!field.isNumeric() && nF.contains(fieldName)) {
                field.setNumeric(nF.contains(fieldName));
            }
            nF.remove(fieldName);
        }
        for (String fieldName : nF) {
            field = new BibtexSingleField(fieldName, false);
            field.setNumeric(true);
            InternalBibtexFields.RUNTIME.fieldSet.put(fieldName, field);
        }
    }

    private void add(BibtexSingleField field) {
        String key = field.getFieldName();
        this.fieldSet.put(key, field);
    }

    private static Optional<BibtexSingleField> getField(String name) {
        if (name != null) {
            return Optional.ofNullable(InternalBibtexFields.RUNTIME.fieldSet.get(name.toLowerCase(Locale.ENGLISH)));
        }
        return Optional.empty();
    }

    public static Set<FieldProperty> getFieldProperties(String name) {
        Optional<BibtexSingleField> sField = InternalBibtexFields.getField(name);
        if (sField.isPresent()) {
            return sField.get().getFieldProperties();
        }
        return EnumSet.noneOf(FieldProperty.class);
    }

    public static double getFieldWeight(String name) {
        Optional<BibtexSingleField> sField = InternalBibtexFields.getField(name);
        if (sField.isPresent()) {
            return sField.get().getWeight();
        }
        return 1.0;
    }

    public static void setFieldWeight(String fieldName, double weight) {
        Optional<BibtexSingleField> sField = InternalBibtexFields.getField(fieldName);
        if (sField.isPresent()) {
            sField.get().setWeight(weight);
        }
    }

    public static int getFieldLength(String name) {
        Optional<BibtexSingleField> sField = InternalBibtexFields.getField(name);
        if (sField.isPresent()) {
            return sField.get().getLength();
        }
        return 100;
    }

    public static boolean isWriteableField(String field) {
        Optional<BibtexSingleField> sField = InternalBibtexFields.getField(field);
        return !sField.isPresent() || sField.get().isWriteable();
    }

    public static boolean isDisplayableField(String field) {
        Optional<BibtexSingleField> sField = InternalBibtexFields.getField(field);
        return !sField.isPresent() || sField.get().isDisplayable();
    }

    public static boolean isStandardField(String field) {
        Optional<BibtexSingleField> sField = InternalBibtexFields.getField(field);
        return sField.isPresent() && sField.get().isStandard();
    }

    public static boolean isNumeric(String field) {
        Optional<BibtexSingleField> sField = InternalBibtexFields.getField(field);
        return sField.isPresent() && sField.get().isNumeric();
    }

    public static boolean isInternalField(String field) {
        return field.startsWith("__");
    }

    public static List<String> getAllPublicFieldNames() {
        ArrayList<String> publicFields = new ArrayList<String>();
        for (BibtexSingleField sField : InternalBibtexFields.RUNTIME.fieldSet.values()) {
            if (sField.isPrivate()) continue;
            publicFields.add(sField.getFieldName());
        }
        Collections.sort(publicFields);
        return publicFields;
    }

    public static List<String> getAllPublicAndInteralFieldNames() {
        ArrayList<String> publicAndInternalFields = new ArrayList<String>();
        publicAndInternalFields.addAll(InternalBibtexFields.getAllPublicFieldNames());
        publicAndInternalFields.add("all");
        publicAndInternalFields.add("all-text-fields");
        Collections.sort(publicAndInternalFields);
        return publicAndInternalFields;
    }

    public static List<String> getJournalNameFields() {
        return InternalBibtexFields.getAllPublicFieldNames().stream().filter(fieldName -> InternalBibtexFields.getFieldProperties(fieldName).contains((Object)FieldProperty.JOURNAL_NAME)).collect(Collectors.toList());
    }

    public static List<String> getBookNameFields() {
        return InternalBibtexFields.getAllPublicFieldNames().stream().filter(fieldName -> InternalBibtexFields.getFieldProperties(fieldName).contains((Object)FieldProperty.BOOK_NAME)).collect(Collectors.toList());
    }

    public static List<String> getPersonNameFields() {
        return InternalBibtexFields.getAllPublicFieldNames().stream().filter(fieldName -> InternalBibtexFields.getFieldProperties(fieldName).contains((Object)FieldProperty.PERSON_NAMES)).collect(Collectors.toList());
    }

    public static List<String> getIEEETranBSTctlYesNoFields() {
        return IEEETRANBSTCTL_YES_NO_FIELDS;
    }
}

