/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.model.entry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.jabref.model.entry.ParsedFileField;

public class FileField {
    public static List<ParsedFileField> parse(String value) {
        if (value == null || value.trim().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ParsedFileField> files = new ArrayList<ParsedFileField>();
        ArrayList<String> entry = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean inXmlChar = false;
        boolean escaped = false;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (!escaped && c == '\\') {
                escaped = true;
                continue;
            }
            if (!escaped && c == '&' && !inXmlChar) {
                sb.append(c);
                if (value.length() > i + 1 && value.charAt(i + 1) == '#') {
                    inXmlChar = true;
                }
            } else if (!escaped && inXmlChar && c == ';') {
                sb.append(c);
                inXmlChar = false;
            } else if (!escaped && c == ':') {
                entry.add(sb.toString());
                sb = new StringBuilder();
            } else if (!escaped && c == ';' && !inXmlChar) {
                entry.add(sb.toString());
                sb = new StringBuilder();
                files.add(FileField.convert(entry));
            } else {
                sb.append(c);
            }
            escaped = false;
        }
        if (sb.length() > 0) {
            entry.add(sb.toString());
        }
        if (!entry.isEmpty()) {
            files.add(FileField.convert(entry));
        }
        return files;
    }

    private static ParsedFileField convert(List<String> entry) {
        while (entry.size() < 3) {
            entry.add("");
        }
        ParsedFileField field = new ParsedFileField(entry.get(0), entry.get(1), entry.get(2));
        if (field.getDescription().isEmpty() && field.getLink().isEmpty() && !field.getFileType().isEmpty()) {
            field = new ParsedFileField("", field.getFileType(), "");
        } else if (!field.getDescription().isEmpty() && field.getLink().isEmpty() && field.getFileType().isEmpty()) {
            field = new ParsedFileField("", field.getDescription(), "");
        }
        entry.clear();
        return field;
    }

    public static String getStringRepresentation(List<ParsedFileField> fields) {
        String[][] array = new String[fields.size()][];
        int i = 0;
        for (ParsedFileField entry : fields) {
            array[i] = new String[]{entry.getDescription(), entry.getLink(), entry.getFileType()};
            ++i;
        }
        return FileField.encodeStringArray(array);
    }

    public static String getStringRepresentation(ParsedFileField field) {
        return FileField.getStringRepresentation(Collections.singletonList(field));
    }

    public static String encodeStringArray(String[][] values) {
        return Arrays.asList(values).stream().map(FileField::encodeStringArray).collect(Collectors.joining(";"));
    }

    private static String encodeStringArray(String[] entry) {
        return Arrays.asList(entry).stream().map(FileField::quote).collect(Collectors.joining(":"));
    }

    public static String quote(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == ';' || c == ':' || c == '\\') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

