/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.model.entry;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface EntryType
extends Comparable<EntryType> {
    public String getName();

    public List<String> getOptionalFields();

    public List<String> getRequiredFields();

    default public List<String> getRequiredFieldsFlat() {
        List requiredFlat = this.getRequiredFields().stream().map(field -> field.split("/")).flatMap(Arrays::stream).collect(Collectors.toList());
        return Collections.unmodifiableList(requiredFlat);
    }

    default public List<String> getAllFields() {
        List allFields = Stream.concat(this.getRequiredFieldsFlat().stream(), this.getOptionalFields().stream()).collect(Collectors.toList());
        return Collections.unmodifiableList(allFields);
    }

    public List<String> getPrimaryOptionalFields();

    public List<String> getSecondaryOptionalFields();
}

