/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.model.entry;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import java.util.TreeSet;
import net.sf.jabref.model.entry.BibEntry;

public class CanonicalBibtexEntry {
    public static String getCanonicalRepresentation(BibEntry e) {
        StringBuilder sb = new StringBuilder();
        String citeKey = e.getCiteKeyOptional().orElse("");
        sb.append(String.format("@%s{%s,", e.getType().toLowerCase(Locale.US), citeKey)).append('\n');
        HashMap<String, String> mapFieldToValue = new HashMap<String, String>();
        TreeSet<String> sortedFields = new TreeSet<String>();
        for (Map.Entry<String, String> field : e.getFieldMap().entrySet()) {
            String fieldName = field.getKey();
            String fieldValue = field.getValue();
            if (fieldName.equals("bibtexkey")) continue;
            String lowerCaseFieldName = fieldName.toLowerCase(Locale.US);
            sortedFields.add(lowerCaseFieldName);
            mapFieldToValue.put(lowerCaseFieldName, fieldValue);
        }
        StringJoiner sj = new StringJoiner(",\n", "", "\n");
        for (String fieldName : sortedFields) {
            String line = String.format("  %s = {%s}", fieldName, String.valueOf(mapFieldToValue.get(fieldName)).replaceAll("\\r\\n", "\n"));
            sj.add(line);
        }
        sb.append(sj);
        sb.append('}');
        return sb.toString();
    }
}

