/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.model.entry;

public class BibtexString
implements Cloneable {
    private String name;
    private String content;
    private String id;
    private Type type;
    private String parsedSerialization;
    private boolean hasChanged;

    public BibtexString(String id, String name, String content) {
        this.id = id;
        this.name = name;
        this.content = content;
        this.hasChanged = true;
        this.type = Type.get(name);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
        this.hasChanged = true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.hasChanged = true;
        this.type = Type.get(name);
    }

    public String getContent() {
        return this.content == null ? "" : this.content;
    }

    public void setContent(String content) {
        this.content = content;
        this.hasChanged = true;
    }

    public Object clone() {
        return new BibtexString(this.id, this.name, this.content);
    }

    public Type getType() {
        return this.type;
    }

    public void setParsedSerialization(String parsedSerialization) {
        this.parsedSerialization = parsedSerialization;
        this.hasChanged = false;
    }

    public String getParsedSerialization() {
        return this.parsedSerialization;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public String getUserComments() {
        if (this.parsedSerialization != null) {
            try {
                String prolog = this.parsedSerialization.substring(0, this.parsedSerialization.indexOf(64));
                prolog = prolog.replaceFirst("\\s+$", "");
                if (prolog.length() > 0) {
                    return prolog;
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return "";
    }

    public String toString() {
        return this.name + "=" + this.content;
    }

    public static enum Type {
        AUTHOR("a"),
        INSTITUTION("i"),
        PUBLISHER("p"),
        OTHER("");

        private final String prefix;

        private Type(String prefix) {
            this.prefix = prefix;
        }

        public static Type get(String name) {
            if (name.length() <= 1) {
                return OTHER;
            }
            if (!String.valueOf(name.charAt(1)).toUpperCase().equals(String.valueOf(name.charAt(1)))) {
                return OTHER;
            }
            for (Type t : Type.values()) {
                if (!t.prefix.equals(String.valueOf(name.charAt(0)))) continue;
                return t;
            }
            return OTHER;
        }
    }
}

