/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.model.entry;

import java.util.EnumSet;
import java.util.Set;
import net.sf.jabref.model.entry.FieldProperty;

public class BibtexSingleField {
    public static final double DEFAULT_FIELD_WEIGHT = 1.0;
    public static final double MAX_FIELD_WEIGHT = 2.0;
    public static final double SMALL_W = 0.3;
    public static final double MEDIUM_W = 0.5;
    public static final double LARGE_W = 1.5;
    public static final int DEFAULT_FIELD_LENGTH = 100;
    private String name;
    private final Set<Flag> flags = EnumSet.of(Flag.DISPLAYABLE, Flag.WRITEABLE);
    private int length = 100;
    private double weight = 1.0;
    private Set<FieldProperty> properties = EnumSet.noneOf(FieldProperty.class);

    public BibtexSingleField(String fieldName, boolean pStandard) {
        this.name = fieldName;
        this.setFlag(pStandard, Flag.STANDARD);
    }

    public BibtexSingleField(String fieldName, boolean pStandard, double pWeight) {
        this.name = fieldName;
        this.setFlag(pStandard, Flag.STANDARD);
        this.weight = pWeight;
    }

    public BibtexSingleField(String fieldName, boolean pStandard, int pLength) {
        this.name = fieldName;
        this.setFlag(pStandard, Flag.STANDARD);
        this.length = pLength;
    }

    public BibtexSingleField(String fieldName, boolean pStandard, double pWeight, int pLength) {
        this.name = fieldName;
        this.setFlag(pStandard, Flag.STANDARD);
        this.weight = pWeight;
        this.length = pLength;
    }

    private void setFlag(boolean setToOn, Flag flagID) {
        if (setToOn) {
            this.flags.add(flagID);
        } else {
            this.flags.remove((Object)flagID);
        }
    }

    public boolean isStandard() {
        return this.flags.contains((Object)Flag.STANDARD);
    }

    public void setPrivate() {
        this.flags.add(Flag.PRIVATE);
    }

    public void setPublic() {
        this.flags.remove((Object)Flag.PRIVATE);
    }

    public boolean isPrivate() {
        return this.flags.contains((Object)Flag.PRIVATE);
    }

    public void setDisplayable(boolean value) {
        this.setFlag(value, Flag.DISPLAYABLE);
    }

    public boolean isDisplayable() {
        return this.flags.contains((Object)Flag.DISPLAYABLE);
    }

    public void setWriteable(boolean value) {
        this.setFlag(value, Flag.WRITEABLE);
    }

    public boolean isWriteable() {
        return this.flags.contains((Object)Flag.WRITEABLE);
    }

    public void setExtras(Set<FieldProperty> pExtras) {
        this.properties = pExtras;
    }

    public Set<FieldProperty> getFieldProperties() {
        return this.properties;
    }

    public void setWeight(double value) {
        this.weight = value;
    }

    public double getWeight() {
        return this.weight;
    }

    public int getLength() {
        return this.length;
    }

    public String getFieldName() {
        return this.name;
    }

    public BibtexSingleField setNumeric(boolean numeric) {
        if (numeric) {
            this.properties.add(FieldProperty.NUMERIC);
        } else {
            this.properties.remove((Object)FieldProperty.NUMERIC);
        }
        return this;
    }

    public boolean isNumeric() {
        return this.properties.contains((Object)FieldProperty.NUMERIC);
    }

    public void setName(String fieldName) {
        this.name = fieldName;
    }

    private static enum Flag {
        STANDARD,
        PRIVATE,
        DISPLAYABLE,
        WRITEABLE;

    }
}

