/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.model.entry;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.sf.jabref.model.entry.BibLatexEntryType;
import net.sf.jabref.model.entry.EntryType;
import net.sf.jabref.model.entry.FieldName;

public class BibLatexEntryTypes {
    public static final BibLatexEntryType ARTICLE = new BibLatexEntryType(){
        private final List<String> primaryOptionalFields = Collections.unmodifiableList(Arrays.asList("subtitle", "editor", "series", "volume", "number", "eid", "issue", "pages", "note", "issn", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"));
        {
            this.addAllRequired("author", "title", "journaltitle", FieldName.orFields("year", "date"));
            this.addAllOptional("translator", "annotator", "commentator", "subtitle", "titleaddon", "editor", "editora", "editorb", "editorc", "journalsubtitle", "issuetitle", "issuesubtitle", "language", "origlanguage", "series", "volume", "number", "eid", "issue", "month", "pages", "version", "note", "issn", "addendum", "pubstate", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate");
        }

        @Override
        public String getName() {
            return "Article";
        }

        @Override
        public List<String> getPrimaryOptionalFields() {
            return this.primaryOptionalFields;
        }
    };
    public static final BibLatexEntryType BOOK = new BibLatexEntryType(){
        private final List<String> primaryOptionalFields = Collections.unmodifiableList(Arrays.asList("editor", "subtitle", "titleaddon", "maintitle", "mainsubtitle", "maintitleaddon", "volume", "edition", "publisher", "isbn", "chapter", "pages", "pagetotal", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"));
        {
            this.addAllRequired("author", "title", FieldName.orFields("year", "date"));
            this.addAllOptional("editor", "editora", "editorb", "editorc", "translator", "annotator", "commentator", "introduction", "foreword", "afterword", "subtitle", "titleaddon", "maintitle", "mainsubtitle", "maintitleaddon", "language", "origlanguage", "volume", "part", "edition", "volumes", "series", "number", "note", "publisher", "location", "isbn", "chapter", "pages", "pagetotal", "addendum", "pubstate", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate");
        }

        @Override
        public String getName() {
            return "Book";
        }

        @Override
        public List<String> getPrimaryOptionalFields() {
            return this.primaryOptionalFields;
        }
    };
    public static final BibLatexEntryType MVBOOK = new BibLatexEntryType(){
        private final List<String> primaryOptionalFields = Collections.unmodifiableList(Arrays.asList("editor", "subtitle", "titleaddon", "edition", "publisher", "isbn", "pagetotal", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"));
        {
            this.addAllRequired("author", "title", FieldName.orFields("year", "date"));
            this.addAllOptional("editor", "editora", "editorb", "editorc", "translator", "annotator", "commentator", "introduction", "foreword", "afterword", "subtitle", "titleaddon", "language", "origlanguage", "edition", "volumes", "series", "number", "note", "publisher", "location", "isbn", "pagetotal", "addendum", "pubstate", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate");
        }

        @Override
        public String getName() {
            return "MvBook";
        }

        @Override
        public List<String> getPrimaryOptionalFields() {
            return this.primaryOptionalFields;
        }
    };
    public static final BibLatexEntryType INBOOK = new BibLatexEntryType(){
        private final List<String> primaryOptionalFields = Collections.unmodifiableList(Arrays.asList("bookauthor", "editor", "subtitle", "titleaddon", "maintitle", "mainsubtitle", "maintitleaddon", "booksubtitle", "booktitleaddon", "volume", "edition", "publisher", "isbn", "chapter", "pages", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"));
        {
            this.addAllRequired("author", "title", "booktitle", FieldName.orFields("year", "date"));
            this.addAllOptional("bookauthor", "editor", "editora", "editorb", "editorc", "translator", "annotator", "commentator", "introduction", "foreword", "afterword", "subtitle", "titleaddon", "maintitle", "mainsubtitle", "maintitleaddon", "booksubtitle", "booktitleaddon", "language", "origlanguage", "volume", "part", "edition", "volumes", "series", "number", "note", "publisher", "location", "isbn", "chapter", "pages", "addendum", "pubstate", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate");
        }

        @Override
        public String getName() {
            return "InBook";
        }

        @Override
        public List<String> getPrimaryOptionalFields() {
            return this.primaryOptionalFields;
        }
    };
    public static final BibLatexEntryType BOOKINBOOK = new BibLatexEntryType(){

        @Override
        public String getName() {
            return "BookInBook";
        }

        @Override
        public List<String> getRequiredFields() {
            return INBOOK.getRequiredFields();
        }

        @Override
        public List<String> getOptionalFields() {
            return INBOOK.getOptionalFields();
        }

        @Override
        public List<String> getPrimaryOptionalFields() {
            return INBOOK.getPrimaryOptionalFields();
        }
    };
    public static final BibLatexEntryType SUPPBOOK = new BibLatexEntryType(){

        @Override
        public String getName() {
            return "SuppBook";
        }

        @Override
        public List<String> getRequiredFields() {
            return INBOOK.getRequiredFields();
        }

        @Override
        public List<String> getOptionalFields() {
            return INBOOK.getOptionalFields();
        }

        @Override
        public List<String> getPrimaryOptionalFields() {
            return INBOOK.getPrimaryOptionalFields();
        }
    };
    public static final BibLatexEntryType BOOKLET = new BibLatexEntryType(){
        private final List<String> primaryOptionalFields = Collections.unmodifiableList(Arrays.asList("subtitle", "titleaddon", "howpublished", "chapter", "pages", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"));
        {
            this.addAllRequired(FieldName.orFields("author", "editor"), "title", FieldName.orFields("year", "date"));
            this.addAllOptional("subtitle", "titleaddon", "language", "howpublished", "type", "note", "location", "chapter", "pages", "pagetotal", "addendum", "pubstate", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate");
        }

        @Override
        public String getName() {
            return "Booklet";
        }

        @Override
        public List<String> getPrimaryOptionalFields() {
            return this.primaryOptionalFields;
        }
    };
    public static final BibLatexEntryType COLLECTION = new BibLatexEntryType(){
        private final List<String> primaryOptionalFields = Collections.unmodifiableList(Arrays.asList("translator", "subtitle", "titleaddon", "maintitle", "mainsubtitle", "maintitleaddon", "volume", "edition", "publisher", "isbn", "chapter", "pages", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"));
        {
            this.addAllRequired("editor", "title", FieldName.orFields("year", "date"));
            this.addAllOptional("editora", "editorb", "editorc", "translator", "annotator", "commentator", "introduction", "foreword", "afterword", "subtitle", "titleaddon", "maintitle", "mainsubtitle", "maintitleaddon", "language", "origlanguage", "volume", "part", "edition", "volumes", "series", "number", "note", "publisher", "location", "isbn", "chapter", "pages", "pagetotal", "addendum", "pubstate", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate");
        }

        @Override
        public String getName() {
            return "Collection";
        }

        @Override
        public List<String> getPrimaryOptionalFields() {
            return this.primaryOptionalFields;
        }
    };
    public static final BibLatexEntryType MVCOLLECTION = new BibLatexEntryType(){
        private final List<String> primaryOptionalFields = Collections.unmodifiableList(Arrays.asList("translator", "subtitle", "titleaddon", "edition", "publisher", "isbn", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"));
        {
            this.addAllRequired("editor", "title", FieldName.orFields("year", "date"));
            this.addAllOptional("editora", "editorb", "editorc", "translator", "annotator", "commentator", "introduction", "foreword", "afterword", "subtitle", "titleaddon", "language", "origlanguage", "edition", "volumes", "series", "number", "note", "publisher", "location", "isbn", "pagetotal", "addendum", "pubstate", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate");
        }

        @Override
        public String getName() {
            return "MvCollection";
        }

        @Override
        public List<String> getPrimaryOptionalFields() {
            return this.primaryOptionalFields;
        }
    };
    public static final BibLatexEntryType INCOLLECTION = new BibLatexEntryType(){
        private final List<String> primaryOptionalFields = Collections.unmodifiableList(Arrays.asList("translator", "subtitle", "titleaddon", "maintitle", "mainsubtitle", "maintitleaddon", "booksubtitle", "booktitleaddon", "volume", "edition", "publisher", "isbn", "chapter", "pages", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"));
        {
            this.addAllRequired("author", "title", "booktitle", FieldName.orFields("year", "date"));
            this.addAllOptional("editor", "editora", "editorb", "editorc", "translator", "annotator", "commentator", "introduction", "foreword", "afterword", "subtitle", "titleaddon", "maintitle", "mainsubtitle", "maintitleaddon", "booksubtitle", "booktitleaddon", "language", "origlanguage", "volume", "part", "edition", "volumes", "series", "number", "note", "publisher", "location", "isbn", "chapter", "pages", "addendum", "pubstate", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate");
        }

        @Override
        public String getName() {
            return "InCollection";
        }

        @Override
        public List<String> getPrimaryOptionalFields() {
            return this.primaryOptionalFields;
        }
    };
    public static final BibLatexEntryType SUPPCOLLECTION = new BibLatexEntryType(){

        @Override
        public String getName() {
            return "SuppCollection";
        }

        @Override
        public List<String> getRequiredFields() {
            return INCOLLECTION.getRequiredFields();
        }

        @Override
        public List<String> getOptionalFields() {
            return INCOLLECTION.getOptionalFields();
        }

        @Override
        public List<String> getPrimaryOptionalFields() {
            return INCOLLECTION.getPrimaryOptionalFields();
        }
    };
    public static final BibLatexEntryType MANUAL = new BibLatexEntryType(){
        private final List<String> primaryOptionalFields = Collections.unmodifiableList(Arrays.asList("subtitle", "titleaddon", "edition", "publisher", "isbn", "chapter", "pages", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"));
        {
            this.addAllRequired(FieldName.orFields("author", "editor"), "title", FieldName.orFields("year", "date"));
            this.addAllOptional("subtitle", "titleaddon", "language", "edition", "type", "series", "number", "version", "note", "organization", "publisher", "location", "isbn", "chapter", "pages", "pagetotal", "addendum", "pubstate", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate");
        }

        @Override
        public String getName() {
            return "Manual";
        }

        @Override
        public List<String> getPrimaryOptionalFields() {
            return this.primaryOptionalFields;
        }
    };
    public static final BibLatexEntryType MISC = new BibLatexEntryType(){
        private final List<String> primaryOptionalFields = Collections.unmodifiableList(Arrays.asList("subtitle", "titleaddon", "howpublished", "location", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"));
        {
            this.addAllRequired(FieldName.orFields("author", "editor"), "title", FieldName.orFields("year", "date"));
            this.addAllOptional("subtitle", "titleaddon", "language", "howpublished", "type", "version", "note", "organization", "location", "month", "addendum", "pubstate", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate");
        }

        @Override
        public String getName() {
            return "Misc";
        }

        @Override
        public List<String> getPrimaryOptionalFields() {
            return this.primaryOptionalFields;
        }
    };
    public static final BibLatexEntryType ONLINE = new BibLatexEntryType(){
        private final List<String> primaryOptionalFields = Collections.unmodifiableList(Arrays.asList("subtitle", "titleaddon", "note", "organization", "urldate"));
        {
            this.addAllRequired(FieldName.orFields("author", "editor"), "title", FieldName.orFields("year", "date"), "url");
            this.addAllOptional("subtitle", "titleaddon", "language", "version", "note", "organization", "month", "addendum", "pubstate", "urldate");
        }

        @Override
        public String getName() {
            return "Online";
        }

        @Override
        public List<String> getPrimaryOptionalFields() {
            return this.primaryOptionalFields;
        }
    };
    public static final BibLatexEntryType PATENT = new BibLatexEntryType(){
        private final List<String> primaryOptionalFields = Collections.unmodifiableList(Arrays.asList("holder", "subtitle", "titleaddon", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"));
        {
            this.addAllRequired("author", "title", "number", FieldName.orFields("year", "date"));
            this.addAllOptional("holder", "subtitle", "titleaddon", "type", "version", "location", "note", "month", "addendum", "pubstate", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate");
        }

        @Override
        public String getName() {
            return "Patent";
        }

        @Override
        public List<String> getPrimaryOptionalFields() {
            return this.primaryOptionalFields;
        }
    };
    public static final BibLatexEntryType PERIODICAL = new BibLatexEntryType(){
        private final List<String> primaryOptionalFields = Collections.unmodifiableList(Arrays.asList("subtitle", "issuetitle", "issuesubtitle", "issn", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"));
        {
            this.addAllRequired("editor", "title", FieldName.orFields("year", "date"));
            this.addAllOptional("editora", "editorb", "editorc", "subtitle", "issuetitle", "issuesubtitle", "language", "series", "volume", "number", "issue", "month", "note", "issn", "addendum", "pubstate", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate");
        }

        @Override
        public String getName() {
            return "Periodical";
        }

        @Override
        public List<String> getPrimaryOptionalFields() {
            return this.primaryOptionalFields;
        }
    };
    public static final BibLatexEntryType SUPPPERIODICAL = new BibLatexEntryType(){

        @Override
        public String getName() {
            return "SuppPeriodical";
        }

        @Override
        public List<String> getRequiredFields() {
            return ARTICLE.getRequiredFields();
        }

        @Override
        public List<String> getOptionalFields() {
            return ARTICLE.getOptionalFields();
        }

        @Override
        public List<String> getPrimaryOptionalFields() {
            return ARTICLE.getPrimaryOptionalFields();
        }
    };
    public static final BibLatexEntryType PROCEEDINGS = new BibLatexEntryType(){
        private final List<String> primaryOptionalFields = Collections.unmodifiableList(Arrays.asList("subtitle", "titleaddon", "maintitle", "mainsubtitle", "maintitleaddon", "eventtitle", "volume", "publisher", "isbn", "chapter", "pages", "pagetotal", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"));
        {
            this.addAllRequired("title", FieldName.orFields("year", "date"));
            this.addAllOptional("editor", "subtitle", "titleaddon", "maintitle", "mainsubtitle", "maintitleaddon", "eventtitle", "eventtitleaddon", "eventdate", "venue", "language", "volume", "part", "volumes", "series", "number", "note", "organization", "publisher", "location", "month", "year", "isbn", "chapter", "pages", "pagetotal", "addendum", "pubstate", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate");
        }

        @Override
        public String getName() {
            return "Proceedings";
        }

        @Override
        public List<String> getPrimaryOptionalFields() {
            return this.primaryOptionalFields;
        }
    };
    public static final BibLatexEntryType MVPROCEEDINGS = new BibLatexEntryType(){
        private final List<String> primaryOptionalFields = Collections.unmodifiableList(Arrays.asList("subtitle", "titleaddon", "maintitle", "mainsubtitle", "maintitleaddon", "eventtitle", "volume", "publisher", "isbn", "chapter", "pages", "pagetotal", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"));
        {
            this.addAllRequired("title", FieldName.orFields("year", "date"));
            this.addAllOptional("editor", "subtitle", "titleaddon", "eventtitle", "eventtitleaddon", "eventdate", "venue", "language", "volumes", "series", "number", "note", "organization", "publisher", "location", "month", "isbn", "pagetotal", "addendum", "pubstate", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate");
        }

        @Override
        public String getName() {
            return "MvProceedings";
        }

        @Override
        public List<String> getPrimaryOptionalFields() {
            return this.primaryOptionalFields;
        }
    };
    public static final BibLatexEntryType INPROCEEDINGS = new BibLatexEntryType(){
        private final List<String> primaryOptionalFields = Collections.unmodifiableList(Arrays.asList("subtitle", "titleaddon", "maintitle", "mainsubtitle", "maintitleaddon", "booksubtitle", "booktitleaddon", "eventtitle", "volume", "publisher", "isbn", "chapter", "pages", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"));
        {
            this.addAllRequired("author", "title", "booktitle", FieldName.orFields("year", "date"));
            this.addAllOptional("editor", "subtitle", "titleaddon", "maintitle", "mainsubtitle", "maintitleaddon", "booksubtitle", "booktitleaddon", "eventtitle", "eventtitleaddon", "eventdate", "venue", "language", "volume", "part", "volumes", "series", "number", "note", "organization", "publisher", "location", "month", "isbn", "chapter", "pages", "addendum", "pubstate", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate");
        }

        @Override
        public String getName() {
            return "InProceedings";
        }

        @Override
        public List<String> getPrimaryOptionalFields() {
            return this.primaryOptionalFields;
        }
    };
    public static final BibLatexEntryType REFERENCE = new BibLatexEntryType(){

        @Override
        public String getName() {
            return "Reference";
        }

        @Override
        public List<String> getRequiredFields() {
            return COLLECTION.getRequiredFields();
        }

        @Override
        public List<String> getOptionalFields() {
            return COLLECTION.getOptionalFields();
        }

        @Override
        public List<String> getPrimaryOptionalFields() {
            return COLLECTION.getPrimaryOptionalFields();
        }
    };
    public static final BibLatexEntryType MVREFERENCE = new BibLatexEntryType(){

        @Override
        public String getName() {
            return "MvReference";
        }

        @Override
        public List<String> getRequiredFields() {
            return MVCOLLECTION.getRequiredFields();
        }

        @Override
        public List<String> getOptionalFields() {
            return MVCOLLECTION.getOptionalFields();
        }

        @Override
        public List<String> getPrimaryOptionalFields() {
            return MVCOLLECTION.getPrimaryOptionalFields();
        }
    };
    public static final BibLatexEntryType INREFERENCE = new BibLatexEntryType(){

        @Override
        public String getName() {
            return "InReference";
        }

        @Override
        public List<String> getRequiredFields() {
            return INCOLLECTION.getRequiredFields();
        }

        @Override
        public List<String> getOptionalFields() {
            return INCOLLECTION.getOptionalFields();
        }

        @Override
        public List<String> getPrimaryOptionalFields() {
            return INCOLLECTION.getPrimaryOptionalFields();
        }
    };
    public static final BibLatexEntryType REPORT = new BibLatexEntryType(){
        private final List<String> primaryOptionalFields = Collections.unmodifiableList(Arrays.asList("subtitle", "titleaddon", "number", "isrn", "chapter", "pages", "pagetotal", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"));
        {
            this.addAllRequired("author", "title", "type", "institution", FieldName.orFields("year", "date"));
            this.addAllOptional("subtitle", "titleaddon", "language", "number", "version", "note", "location", "month", "isrn", "chapter", "pages", "pagetotal", "addendum", "pubstate", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate");
        }

        @Override
        public String getName() {
            return "Report";
        }

        @Override
        public List<String> getPrimaryOptionalFields() {
            return this.primaryOptionalFields;
        }
    };
    public static final BibLatexEntryType SET = new BibLatexEntryType(){
        {
            this.addAllRequired("entryset", "crossref");
        }

        @Override
        public String getName() {
            return "Set";
        }
    };
    public static final BibLatexEntryType THESIS = new BibLatexEntryType(){
        private final List<String> primaryOptionalFields = Collections.unmodifiableList(Arrays.asList("subtitle", "titleaddon", "chapter", "pages", "pagetotal", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"));
        {
            this.addAllRequired("author", "title", "type", "institution", FieldName.orFields("year", "date"));
            this.addAllOptional("subtitle", "titleaddon", "language", "note", "location", "month", "isbn", "chapter", "pages", "pagetotal", "addendum", "pubstate", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate");
        }

        @Override
        public String getName() {
            return "Thesis";
        }

        @Override
        public List<String> getPrimaryOptionalFields() {
            return this.primaryOptionalFields;
        }
    };
    public static final BibLatexEntryType UNPUBLISHED = new BibLatexEntryType(){
        private final List<String> primaryOptionalFields = Collections.unmodifiableList(Arrays.asList("subtitle", "titleaddon", "howpublished", "pubstate", "url", "urldate"));
        {
            this.addAllRequired("author", "title", FieldName.orFields("year", "date"));
            this.addAllOptional("subtitle", "titleaddon", "language", "howpublished", "note", "location", "month", "addendum", "pubstate", "url", "urldate");
        }

        @Override
        public String getName() {
            return "Unpublished";
        }

        @Override
        public List<String> getPrimaryOptionalFields() {
            return this.primaryOptionalFields;
        }
    };
    public static final BibLatexEntryType CONFERENCE = new BibLatexEntryType(){

        @Override
        public String getName() {
            return "Conference";
        }

        @Override
        public List<String> getRequiredFields() {
            return INPROCEEDINGS.getRequiredFields();
        }

        @Override
        public List<String> getOptionalFields() {
            return INPROCEEDINGS.getOptionalFields();
        }

        @Override
        public List<String> getPrimaryOptionalFields() {
            return INPROCEEDINGS.getPrimaryOptionalFields();
        }
    };
    public static final BibLatexEntryType ELECTRONIC = new BibLatexEntryType(){

        @Override
        public String getName() {
            return "Electronic";
        }

        @Override
        public List<String> getRequiredFields() {
            return ONLINE.getRequiredFields();
        }

        @Override
        public List<String> getOptionalFields() {
            return ONLINE.getOptionalFields();
        }

        @Override
        public List<String> getPrimaryOptionalFields() {
            return ONLINE.getPrimaryOptionalFields();
        }
    };
    public static final BibLatexEntryType MASTERSTHESIS = new BibLatexEntryType(){
        private final List<String> primaryOptionalFields = Collections.unmodifiableList(Arrays.asList("subtitle", "titleaddon", "type", "chapter", "pages", "pagetotal", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"));
        {
            this.addAllRequired("author", "title", "institution", FieldName.orFields("year", "date"));
            this.addAllOptional("type", "subtitle", "titleaddon", "language", "note", "location", "month", "isbn", "chapter", "pages", "pagetotal", "addendum", "pubstate", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate");
        }

        @Override
        public String getName() {
            return "MastersThesis";
        }

        @Override
        public List<String> getPrimaryOptionalFields() {
            return this.primaryOptionalFields;
        }
    };
    public static final BibLatexEntryType PHDTHESIS = new BibLatexEntryType(){
        private final List<String> primaryOptionalFields = Collections.unmodifiableList(Arrays.asList("subtitle", "titleaddon", "type", "chapter", "pages", "pagetotal", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"));
        {
            this.addAllRequired("author", "title", "institution", FieldName.orFields("year", "date"));
            this.addAllOptional("type", "subtitle", "titleaddon", "language", "note", "location", "month", "isbn", "chapter", "pages", "pagetotal", "addendum", "pubstate", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate");
        }

        @Override
        public String getName() {
            return "PhdThesis";
        }

        @Override
        public List<String> getPrimaryOptionalFields() {
            return this.primaryOptionalFields;
        }
    };
    public static final BibLatexEntryType TECHREPORT = new BibLatexEntryType(){
        private final List<String> primaryOptionalFields = Collections.unmodifiableList(Arrays.asList("subtitle", "titleaddon", "type", "number", "isrn", "chapter", "pages", "pagetotal", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"));
        {
            this.addAllRequired("author", "title", "institution", FieldName.orFields("year", "date"));
            this.addAllOptional("type", "subtitle", "titleaddon", "language", "number", "version", "note", "location", "month", "isrn", "chapter", "pages", "pagetotal", "addendum", "pubstate", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate");
        }

        @Override
        public String getName() {
            return "TechReport";
        }

        @Override
        public List<String> getPrimaryOptionalFields() {
            return this.primaryOptionalFields;
        }
    };
    public static final BibLatexEntryType WWW = new BibLatexEntryType(){

        @Override
        public String getName() {
            return "WWW";
        }

        @Override
        public List<String> getRequiredFields() {
            return ONLINE.getRequiredFields();
        }

        @Override
        public List<String> getOptionalFields() {
            return ONLINE.getOptionalFields();
        }

        @Override
        public List<String> getPrimaryOptionalFields() {
            return ONLINE.getPrimaryOptionalFields();
        }
    };
    public static final BibLatexEntryType IEEETRANBSTCTL = new BibLatexEntryType(){
        {
            this.addAllOptional("ctluse_article_number", "ctluse_paper", "ctluse_forced_etal", "ctluse_url", "ctlmax_names_forced_etal", "ctlnames_show_etal", "ctluse_alt_spacing", "ctlalt_stretch_factor", "ctldash_repeated_names", "ctlname_format_string", "ctlname_latex_cmd", "ctlname_url_prefix");
        }

        @Override
        public String getName() {
            return "IEEEtranBSTCTL";
        }
    };
    public static final List<EntryType> ALL = Arrays.asList(ARTICLE, BOOK, MVBOOK, INBOOK, BOOKINBOOK, SUPPBOOK, BOOKLET, COLLECTION, MVCOLLECTION, INCOLLECTION, SUPPCOLLECTION, MANUAL, MISC, ONLINE, PATENT, PERIODICAL, SUPPPERIODICAL, PROCEEDINGS, MVPROCEEDINGS, INPROCEEDINGS, REFERENCE, MVREFERENCE, INREFERENCE, REPORT, SET, THESIS, UNPUBLISHED, CONFERENCE, ELECTRONIC, MASTERSTHESIS, PHDTHESIS, TECHREPORT, WWW, IEEETRANBSTCTL);

    public static Optional<EntryType> getType(String name) {
        return ALL.stream().filter(e -> e.getName().equalsIgnoreCase(name)).findFirst();
    }
}

