/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.model.entry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.jabref.model.entry.EntryType;

public abstract class BibLatexEntryType
implements EntryType {
    private final List<String> requiredFields = new ArrayList<String>();
    private final List<String> optionalFields = new ArrayList<String>();

    @Override
    public List<String> getOptionalFields() {
        return Collections.unmodifiableList(this.optionalFields);
    }

    @Override
    public List<String> getRequiredFields() {
        return Collections.unmodifiableList(this.requiredFields);
    }

    void addAllOptional(String ... fieldNames) {
        this.optionalFields.addAll(Arrays.asList(fieldNames));
    }

    void addAllRequired(String ... fieldNames) {
        this.requiredFields.addAll(Arrays.asList(fieldNames));
    }

    @Override
    public List<String> getPrimaryOptionalFields() {
        return this.getOptionalFields();
    }

    @Override
    public List<String> getSecondaryOptionalFields() {
        List<String> myOptionalFields = this.getOptionalFields();
        if (myOptionalFields == null) {
            return Collections.emptyList();
        }
        return myOptionalFields.stream().filter(field -> !this.isPrimary((String)field)).collect(Collectors.toList());
    }

    private boolean isPrimary(String field) {
        List<String> primaryFields = this.getPrimaryOptionalFields();
        if (primaryFields == null) {
            return false;
        }
        return primaryFields.contains(field);
    }

    @Override
    public int compareTo(EntryType o) {
        return this.getName().compareTo(o.getName());
    }
}

